/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.diagram.DDiagram;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class RefreshFCContextualElementsTest
extends BasicTestCase {
    private String projectTestName = "testRefreshContextualElements";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    public void test() throws Exception {
        Session session = this.getSession(this.projectTestName);
        RefreshFCContextualElementsTest.assertNotNull((Object)session);
        IFile airdFile = this.getAirdFileForLoadedModel(this.projectTestName);
        Assert.assertNotNull((Object)airdFile);
        GuiActions.openSession((IFile)airdFile, (boolean)true);
        this.testDiagram(session, airdFile, "[SAB] System");
        this.testDiagram(session, airdFile, "[LAB] Structure");
        this.testDiagram(session, airdFile, "[PAB] Physical System");
    }

    protected void testDiagram(Session session, IFile airdFile, String diagramName) {
        DDiagram diagram = (DDiagram)DiagramHelper.getDRepresentation((Session)session, (String)diagramName);
        RefreshFCContextualElementsTest.assertNotNull((String)MessageFormat.format("{0} diagram is not contained in the session associated to {1} file", diagramName, airdFile), (Object)diagram);
        SessionContext sessionContext = new SessionContext(session);
        DiagramContext diagramContext = new DiagramContext(sessionContext, diagram);
        diagramContext.open();
        RefreshFCContextualElementsTest.assertEquals((Object)SessionStatus.SYNC, (Object)session.getStatus());
        diagramContext.refreshDiagram();
        RefreshFCContextualElementsTest.assertEquals((Object)SessionStatus.SYNC, (Object)session.getStatus());
        diagramContext.close();
    }
}

