/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.ui.semantic.browser.sirius.view.SiriusSemanticBrowserView;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class SemanticBrowserRefreshTest
extends BasicTestCase {
    public static String OA_4_1 = "71356c27-1fbc-49f5-b453-0a1aa3026863";
    public static String OA_1 = "4ad0704e-029a-4646-ae13-5e4f35992c5f";
    public static String OA_4 = "308bbc45-8cda-45a2-886f-8adc208e3b7b";
    public static String OA_1_NAME = "OA 1";
    public static String OA_4_NAME = "OA 4";
    public static String OA_4_1_NAME = "OA 4_1";
    public static String PARENT_CATEGORY_NAME = "Parent";
    private String projectTestName = "StatusLine";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    protected SiriusSemanticBrowserView getSemanticBrowserViewer() {
        final SiriusSemanticBrowserView[] viewer = new SiriusSemanticBrowserView[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                viewer[0] = (SiriusSemanticBrowserView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
            }
        });
        return viewer[0];
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(this.projectTestName);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
        SiriusSemanticBrowserView semanticBrowserViewer = this.getSemanticBrowserViewer();
        final EObject operationalActivity_4_1 = IdManager.getInstance().getEObject(OA_4_1, (IScope)scope);
        final EObject operationalActivity_1 = IdManager.getInstance().getEObject(OA_1, (IScope)scope);
        StructuredSelection fakeSelection1 = new StructuredSelection((Object)new String("EditPart1"));
        semanticBrowserViewer.saveInput((Object)operationalActivity_4_1, (ISelection)fakeSelection1);
        semanticBrowserViewer.setFocus();
        SemanticBrowserRefreshTest.assertTrue((String)("The input of SB should be \"" + OA_4_1_NAME + "\" but is " + String.valueOf(semanticBrowserViewer.getCurrentViewer().getInput()) + "."), (semanticBrowserViewer.getCurrentViewer().getInput() == operationalActivity_4_1 ? 1 : 0) != 0);
        this.checkParentDisplayedinSB((SemanticBrowserView)semanticBrowserViewer, OA_4_NAME);
        TestHelper.getExecutionManager((Session)this.getSession(this.projectTestName)).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                ((OperationalActivity)operationalActivity_1).getOwnedFunctions().add((Object)((OperationalActivity)operationalActivity_4_1));
            }
        });
        semanticBrowserViewer.saveInput((Object)operationalActivity_4_1, (ISelection)fakeSelection1);
        semanticBrowserViewer.setFocus();
        SemanticBrowserRefreshTest.assertTrue((String)("The input of SB should be \"" + OA_4_1_NAME + "\"."), (semanticBrowserViewer.getCurrentViewer().getInput() == operationalActivity_4_1 ? 1 : 0) != 0);
        this.checkParentDisplayedinSB((SemanticBrowserView)semanticBrowserViewer, OA_4_NAME);
        StructuredSelection fakeSelection2 = new StructuredSelection((Object)new String("EditPart2"));
        semanticBrowserViewer.saveInput((Object)operationalActivity_4_1, (ISelection)fakeSelection2);
        semanticBrowserViewer.setFocus();
        SemanticBrowserRefreshTest.assertTrue((String)("The input of SB should be \"" + OA_4_1_NAME + "\"."), (semanticBrowserViewer.getCurrentViewer().getInput() == operationalActivity_4_1 ? 1 : 0) != 0);
        this.checkParentDisplayedinSB((SemanticBrowserView)semanticBrowserViewer, OA_1_NAME);
        final EObject operationalActivity_4 = IdManager.getInstance().getEObject(OA_4, (IScope)scope);
        TestHelper.getExecutionManager((Session)this.getSession(this.projectTestName)).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                ((OperationalActivity)operationalActivity_4).getOwnedFunctions().add((Object)((OperationalActivity)operationalActivity_4_1));
            }
        });
    }

    private void checkParentDisplayedinSB(SemanticBrowserView semanticBrowserViewer, String expectedParentName) {
        SemanticBrowserParentRunnable runnable = new SemanticBrowserParentRunnable(semanticBrowserViewer);
        Display.getDefault().syncExec((Runnable)((Object)runnable));
        if (!runnable.getStatus().isOK()) {
            SemanticBrowserRefreshTest.fail((String)runnable.getStatus().getMessage());
        }
        SemanticBrowserRefreshTest.assertEquals((String)"Wrong parent of \"OA 4_1\" is displayed in the Semantic Browser view.", (String)expectedParentName, (String)runnable.getResult());
    }

    private class SemanticBrowserParentRunnable
    implements RunnableWithResult<String> {
        SemanticBrowserView semanticBrowserView;
        String result;
        IStatus status = Status.OK_STATUS;

        public SemanticBrowserParentRunnable(SemanticBrowserView semanticBrowserViewer) {
            this.semanticBrowserView = semanticBrowserViewer;
        }

        public void run() {
            if (this.semanticBrowserView.getCurrentViewer().getTree().getItemCount() != 1) {
                this.setStatus((IStatus)new Status(4, "org.polarsys.capella.test.diagram.misc.ju", "The \"Current Element\" part of the \"Semantic Browser\" view must contain only one root element."));
                return;
            }
            TreeItem rootItem = this.semanticBrowserView.getCurrentViewer().getTree().getItem(0);
            if (!OA_4_1_NAME.equals(rootItem.getText())) {
                this.setStatus((IStatus)new Status(4, "org.polarsys.capella.test.diagram.misc.ju", "The root element of the \"Current Element\" part of the \"Semantic Browser\" view must be \"" + OA_4_1_NAME + "\"."));
                return;
            }
            if (rootItem.getItemCount() < 1) {
                this.setStatus((IStatus)new Status(4, "org.polarsys.capella.test.diagram.misc.ju", "The root element must contain at least one category."));
                return;
            }
            TreeItem parentCategroyItem = rootItem.getItem(0);
            if (!PARENT_CATEGORY_NAME.equals(parentCategroyItem.getText())) {
                this.setStatus((IStatus)new Status(4, "org.polarsys.capella.test.diagram.misc.ju", "The first category of the root element must be \"" + PARENT_CATEGORY_NAME + "\"."));
                return;
            }
            if (parentCategroyItem.getItemCount() < 1) {
                this.setStatus((IStatus)new Status(4, "org.polarsys.capella.test.diagram.misc.ju", "The \"" + PARENT_CATEGORY_NAME + "\" category must contain at least the parent name."));
                return;
            }
            TreeItem parentItem = parentCategroyItem.getItem(0);
            this.result = parentItem.getText();
        }

        public String getResult() {
            return this.result;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

