/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.doc.ju;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.polarsys.capella.test.doc.ju.StyleCheckTestCase;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BrokenLinksCheckTestCase
extends BasicTestCase {
    public void test() throws Exception {
        Bundle[] bundles;
        BaseHelpSystem.ensureWebappRunning();
        ArrayList<Bundle> docPlugins = new ArrayList<Bundle>();
        BundleContext ctx = FrameworkUtil.getBundle(StyleCheckTestCase.class).getBundleContext();
        Bundle[] bundleArray = bundles = ctx.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (this.isDocPlugin(bundle)) {
                docPlugins.add(bundle);
            }
            ++n2;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (Bundle docPlugin : docPlugins) {
            Enumeration entries = docPlugin.findEntries("html", "*.html", true);
            while (entries.hasMoreElements()) {
                URL htmlURL = (URL)entries.nextElement();
                String stringURL = this.getHelpServer() + docPlugin.getSymbolicName() + htmlURL.getFile().replace(" ", "%20");
                System.out.println("Analyzing... " + stringURL);
                URL rootURL = new URL(stringURL);
                if (this.isExluded(htmlURL)) continue;
                Collection<String> messages = this.extractBrokenLinkMessages(rootURL);
                errorMessages.addAll(messages);
            }
        }
        BrokenLinksCheckTestCase.assertTrue((String)errorMessages.stream().collect(Collectors.joining("\n")), (boolean)errorMessages.isEmpty());
    }

    protected String getHelpServer() {
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help/topic/";
    }

    public Collection<String> extractBrokenLinkMessages(URL rootUrl) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        Collection linkNodes = this.getAllNodes(rootUrl);
        linkNodes = linkNodes.stream().filter(BrokenLinksCheckTestCase::isOfflineLink).collect(Collectors.toList());
        for (Node linkNode : linkNodes) {
            String linkText = this.adaptToURL(linkNode);
            if (linkText != null) continue;
            String errorMessage = NLS.bind((String)"Null link in page {0}", (Object)rootUrl.toString());
            errorMessages.add(errorMessage);
        }
        Collection urls = linkNodes.stream().map(x -> this.adaptToURL((Node)x)).distinct().collect(Collectors.toList());
        for (String linkText : urls) {
            URL url = new URL(rootUrl, linkText = this.toValidURL(linkText));
            if (this.isFakeUrl(url)) continue;
            HttpURLConnection linkConnection = (HttpURLConnection)url.openConnection();
            try {
                String errorMessage;
                try {
                    int responseCode = linkConnection.getResponseCode();
                    if (responseCode == 407) {
                        errorMessage = NLS.bind((String)"Proxy issue for {0} ( {1} ) in page {2} : {3}", (Object[])new String[]{linkText, url.toString(), rootUrl.toString(), "" + responseCode});
                        errorMessages.add(errorMessage);
                    } else if (responseCode != 200) {
                        errorMessage = NLS.bind((String)"Invalid url {0} ( {1} ) in page {2} : {3}", (Object[])new String[]{linkText, url.toString(), rootUrl.toString(), "" + responseCode});
                        errorMessages.add(errorMessage);
                    }
                }
                catch (Exception e) {
                    errorMessage = NLS.bind((String)"Invalid url {0} ( {1} ) in page {2} : {3}", (Object[])new String[]{linkText, url.toString(), rootUrl.toString(), e.getMessage()});
                    errorMessages.add(errorMessage);
                    linkConnection.disconnect();
                    continue;
                }
            }
            catch (Throwable throwable) {
                linkConnection.disconnect();
                throw throwable;
            }
            linkConnection.disconnect();
        }
        return errorMessages;
    }

    protected String adaptToURL(Node linkNode) {
        Node href = linkNode.getAttributes().getNamedItem("href");
        if (href != null) {
            return href.getTextContent();
        }
        Node src = linkNode.getAttributes().getNamedItem("src");
        if (src != null) {
            return src.getTextContent();
        }
        return null;
    }

    protected String toValidURL(String href) {
        if (href.startsWith("/wiki/../")) {
            href = href.substring("/wiki/../".length() - 1);
        }
        href = URI.createURI((String)href, (boolean)true).toString();
        return href;
    }

    protected boolean isDocPlugin(Bundle bundle) {
        return bundle.getSymbolicName().startsWith("org.polarsys.capella") && bundle.getSymbolicName().endsWith("doc");
    }

    protected boolean isFakeUrl(URL url) {
        String urlValue = url.toString();
        return urlValue.startsWith("http://www.polarsys.org/capella/core/") || urlValue.startsWith("http://www.polarsys.org/capella/common/") || urlValue.startsWith("http://www.polarsys.org/capella/derived") || urlValue.startsWith("https://update-site.url");
    }

    private Collection<Node> getAllNodes(URL rootUrl) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)rootUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("ACCEPT", "application/xml");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream xmlContent = connection.getInputStream();){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(xmlContent);
                XPathFactory pathFactory = XPathFactory.newInstance();
                XPath path = pathFactory.newXPath();
                XPathExpression links = path.compile("//a | //img");
                return this.toList((NodeList)links.evaluate(document, XPathConstants.NODESET));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            String errorMessage = NLS.bind((String)"Could not process resource {0}. {1}", (Object)rootUrl.toString(), (Object)e.getMessage());
            throw new IOException(errorMessage);
        }
    }

    protected Collection<Node> toList(NodeList list) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                result.add(node);
                ++i;
            }
        }
        return result;
    }

    protected static boolean isOfflineLink(Node linkNode) {
        return linkNode.getParentNode() == null || linkNode.getParentNode().getNodeName() == null || !linkNode.getParentNode().getNodeName().equals("span");
    }

    protected boolean isExluded(URL htmlURL) {
        return htmlURL.getFile().startsWith("/html/api-docs/javadoc");
    }

    protected boolean isInternalLink(String linkURL) {
        return linkURL.contains(WebappManager.getHost());
    }
}

