/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.fastlinker.ju.testcases;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.model.helpers.ModelQueryHelper;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerActivator;
import org.polarsys.capella.test.fastlinker.ju.testcases.AbstractFastLinkerTest;

public class CreateFunctionRealizationTest
extends AbstractFastLinkerTest {
    public List<String> getRequiredTestModels() {
        return Collections.singletonList("TestsFastLinker");
    }

    public void test() throws Exception {
        this.executeCommand(new AbstractReadWriteCommand(){

            public void run() {
                Project testProject = CreateFunctionRealizationTest.this.getTestProject();
                String oa1Name = "OperationalActivity1";
                String sf1Name = "SystemFunction1";
                OperationalActivity rootOperationalActivity = ModelQueryHelper.getRootOperationalActivity((Project)testProject);
                OperationalActivity oa1 = OaFactory.eINSTANCE.createOperationalActivity();
                oa1.setName("OperationalActivity1");
                rootOperationalActivity.getOwnedFunctions().add((Object)oa1);
                SystemFunction rootSystemFunction = ModelQueryHelper.getRootSystemFunction((Project)testProject);
                SystemFunction sf1 = CtxFactory.eINSTANCE.createSystemFunction();
                sf1.setName("SystemFunction1");
                rootSystemFunction.getOwnedFunctions().add((Object)sf1);
                boolean acceptOA1 = FastLinkerActivator.getDefault().getFastLinkerManager().acceptElementInFastLinker(Collections.singletonList(oa1));
                CreateFunctionRealizationTest.assertTrue((String)"FastLinker should accept OperationalActivity1", (boolean)acceptOA1);
                FastLinkerActivator.getDefault().getFastLinkerManager().putElementInFastLinker(Collections.singletonList(oa1));
                boolean acceptSF1 = FastLinkerActivator.getDefault().getFastLinkerManager().acceptElementInFastLinker(Collections.singletonList(sf1));
                CreateFunctionRealizationTest.assertTrue((String)"FastLinker should accept SystemFunction1", (boolean)acceptSF1);
                FastLinkerActivator.getDefault().getFastLinkerManager().putElementInFastLinker(Collections.singletonList(sf1));
                EList ownedFunctionRealizations = sf1.getOwnedFunctionRealizations();
                CreateFunctionRealizationTest.assertTrue((String)"SystemFunction1 should contain exactly 1 realization", (1 == ownedFunctionRealizations.size() ? 1 : 0) != 0);
                FunctionRealization functionRealization = (FunctionRealization)ownedFunctionRealizations.get(0);
                CreateFunctionRealizationTest.assertTrue((String)"Source element of the created realization should be SystemFunction1", (sf1 == functionRealization.getSourceElement() ? 1 : 0) != 0);
                CreateFunctionRealizationTest.assertTrue((String)"Target element of the created realization should be OperationalActivity1", (oa1 == functionRealization.getTargetElement() ? 1 : 0) != 0);
            }
        });
    }
}

