/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.fragmentation.ju.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.junit.Assert;
import org.polarsys.capella.test.fragmentation.ju.messages.FragmentationMessages;
import org.polarsys.capella.test.fragmentation.ju.utils.FragmentUtils;
import org.polarsys.capella.test.framework.api.step.AbstractTestStep;
import org.polarsys.capella.test.framework.context.SessionContext;

public abstract class AbstractFragmentationTest
extends AbstractTestStep {
    protected EObject _eObject = null;
    protected List<DRepresentationDescriptor> _dRepresentations = null;
    protected List<Resource> _oldAIRDResources = null;

    public AbstractFragmentationTest(SessionContext context, String objectId) {
        super(context);
        this._eObject = context.getSemanticElement(objectId);
        this.setDRepresentationDescriptorsToMove();
    }

    public AbstractFragmentationTest(SessionContext context, EObject object) {
        super(context);
        this._eObject = object;
        this.setDRepresentationDescriptorsToMove();
    }

    protected void setDRepresentationDescriptorsToMove() {
        this._dRepresentations = FragmentUtils.getLinkedDRepresentationDescriptor(this._eObject);
    }

    public final EObject getTargetObject() {
        Assert.assertNotNull((String)FragmentationMessages.abstractFragmentationTest_EObjectNotSetted, (Object)this._eObject);
        return this._eObject;
    }

    public final boolean isThereAnyDRepresentationToMove() {
        return !this.getDRepresentationDescriptorsToMove().isEmpty();
    }

    public final List<DRepresentationDescriptor> getDRepresentationDescriptorsToMove() {
        if (this._dRepresentations == null) {
            this._dRepresentations = new ArrayList<DRepresentationDescriptor>();
        }
        return this._dRepresentations;
    }

    protected void preRunTest() {
        if (this.isThereAnyDRepresentationToMove()) {
            this._oldAIRDResources = new ArrayList<Resource>();
        }
        EObject eobj = null;
        for (DRepresentationDescriptor dRepresentation : this.getDRepresentationDescriptorsToMove()) {
            if (ViewpointPackage.Literals.DSEMANTIC_DECORATOR.isSuperTypeOf(dRepresentation.getRepresentation().eClass())) {
                eobj = (EObject)dRepresentation.getRepresentation().eGet((EStructuralFeature)ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET);
                this._oldAIRDResources.add(dRepresentation.eResource());
            } else {
                Assert.fail((String)NLS.bind((String)FragmentationMessages.abstractFragmentationTest_UnsupportedKindOfdRepresentation, (Object)dRepresentation.getName()));
            }
            Assert.assertEquals((String)NLS.bind((String)FragmentationMessages.abstractFragmentationTest_dRepresentationToMoveDoesNotMatch, (Object)dRepresentation.getName()), (Object)eobj.eResource(), (Object)this.getTargetObject().eResource());
        }
    }
}

