/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.fragmentation.ju.utils;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.osgi.util.NLS;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.test.fragmentation.ju.messages.FragmentationMessages;
import org.polarsys.capella.test.fragmentation.ju.utils.AbstractFragmentationTest;
import org.polarsys.capella.test.fragmentation.ju.utils.FragmentUtils;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class UnfragmentTest
extends AbstractFragmentationTest {
    public UnfragmentTest(SessionContext context, String objectId) {
        super(context, objectId);
    }

    public UnfragmentTest(SessionContext context, EObject object) {
        super(context, object);
    }

    public void unfragmentTest() {
        EObject objectToUnfragment = this.getTargetObject();
        Assert.assertNotNull((String)NLS.bind((String)FragmentationMessages.abstractUnfragmentTest_isNotFragmented, (Object)EObjectExt.getText((EObject)objectToUnfragment)), (Object)FragmentUtils.getDirectResource(objectToUnfragment));
        int numberOfProperChildren = FragmentUtils.getNumberOfProperEObjects(objectToUnfragment);
        Map<EObject, Integer> eObjectRefCount = FragmentUtils.getProperContentsRefCount(objectToUnfragment);
        new GuiActions().unfragment((CapellaElement)objectToUnfragment, true);
        this.postUnfragmentChecks(objectToUnfragment, numberOfProperChildren, eObjectRefCount);
    }

    protected void postUnfragmentChecks(EObject objectToUnfragment, int numberOfProperChildren, Map<EObject, Integer> eObjectRefCount) {
        Resource directResource = FragmentUtils.getDirectResource(objectToUnfragment);
        Assert.assertNull((String)NLS.bind((String)FragmentationMessages.abstractunfragmentTest_hasItsOwnResource, (Object)EObjectExt.getText((EObject)objectToUnfragment)), (Object)directResource);
        Resource targetResource = objectToUnfragment.eResource();
        FragmentUtils.checkEResource(objectToUnfragment, targetResource);
        int newNumberOfProperChildren = FragmentUtils.getNumberOfProperEObjects(objectToUnfragment);
        Assert.assertEquals((String)NLS.bind((String)FragmentationMessages.abstractFragmentTest_hasNotSameNumbersOfchildrenAfterFragmentation, (Object)EObjectExt.getText((EObject)objectToUnfragment)), (long)numberOfProperChildren, (long)newNumberOfProperChildren);
        Map<EObject, Integer> newEObjectRefCount = FragmentUtils.getProperContentsRefCount(objectToUnfragment);
        FragmentUtils.compareRefCountForTest(objectToUnfragment, eObjectRefCount, newEObjectRefCount, false);
    }

    public Object getResult() {
        return null;
    }

    protected void runTest() {
        this.unfragmentTest();
    }

    protected void postRunTest() {
        if (this.isThereAnyDRepresentationToMove()) {
            Set<Resource> newAIRDresources = FragmentUtils.getAirdResourceWithAnalysisOn(this.getTargetObject());
            for (Resource newAIRDresource : newAIRDresources) {
                boolean isnewAIRDresourceExist = WorkspaceSynchronizer.getFile((Resource)newAIRDresource) != null;
                Assert.assertTrue((String)"The fragment is not removed", (!isnewAIRDresourceExist ? 1 : 0) != 0);
            }
        }
        this._eObject = null;
        this._dRepresentations = null;
        if (this._oldAIRDResources != null) {
            this._oldAIRDResources.clear();
        }
    }
}

