/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.libraries.ui.ju.testcases.basic;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.flexibility.properties.loader.PropertiesLoader;
import org.polarsys.capella.common.flexibility.properties.property.PropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.loader.RenderersLoader;
import org.polarsys.capella.common.flexibility.wizards.renderer.RendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderers;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyDialog;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyWizard;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyWizardPage;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.Messages;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.properties.LibraryManagerModel;
import org.polarsys.capella.core.libraries.properties.ReferencesProperty;
import org.polarsys.capella.test.diagram.common.ju.context.CDBDiagram;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class LibraryManagerWizardTestCase
extends BasicTestCase {
    private String CDB_DIAGRAM = "[CDB] Data";
    private String CLASS_LIB1 = "_AV7EwGvYEe6ny_c39ZY3KA";

    public List<String> getRequiredTestModels() {
        return Arrays.asList("MyProject1", "MyLibrary1", "MyLibrary2");
    }

    public void test() {
        IProperty property;
        CapellaModel myLib1 = this.getTestModel("MyLibrary1");
        CapellaModel myLib2 = this.getTestModel("MyLibrary2");
        Session session = this.getSession("MyProject1");
        IModel.Edit rootModel = (IModel.Edit)ILibraryManager.INSTANCE.getModel(session.getTransactionalEditingDomain());
        LibraryManagerWizardTestCase.assertNotNull((Object)rootModel);
        SessionContext sessionContext = new SessionContext(session);
        CDBDiagram diagram = CDBDiagram.openDiagram((SessionContext)sessionContext, (String)this.CDB_DIAGRAM);
        final String modelName = rootModel.getIdentifier().getName();
        IProperties properties = new PropertiesLoader().getProperties("org.polarsys.capella.core.libraries.manageReferences");
        LibraryManagerModel managerModel = new LibraryManagerModel(session.getTransactionalEditingDomain(), rootModel);
        PropertyContext context = new PropertyContext(properties, (Object)managerModel);
        IRenderers renderers = new RenderersLoader().getRenderers(properties);
        RendererContext rendererContext = new RendererContext(renderers, (IPropertyContext)context);
        PropertyWizard wizard = new PropertyWizard((IPropertyContext)context, (IRendererContext)rendererContext){

            public void addPages() {
                PropertyWizardPage page = new PropertyWizardPage("propertiesEditor", this.getContext(), this.getRendererContext());
                page.setTitle(modelName + " management");
                page.setDescription("This wizard helps you to define the libraries that are referenced by the current project (first tab).\nYou can also specify among these libraries which ones must be considered in capella query scopes (second tab).");
                this.addPage((IWizardPage)page);
            }
        };
        PropertyDialog dialog = new PropertyDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        dialog.setHelpAvailable(false);
        dialog.setPageSize(200, 300);
        dialog.setBlockOnOpen(false);
        dialog.create();
        managerModel.removeReferencedLibrary((IModel)myLib1);
        ReferencesProperty referenceProperty = null;
        Iterator iterator = properties.getAllItems().iterator();
        if (iterator.hasNext() && (property = (IProperty)iterator.next()) instanceof ReferencesProperty) {
            referenceProperty = (ReferencesProperty)property;
        }
        IStatus status = referenceProperty.validate((Object)managerModel, (IPropertyContext)context);
        LibraryManagerWizardTestCase.assertEquals((int)status.getSeverity(), (int)2);
        LibraryManagerWizardTestCase.assertEquals((String)status.getMessage(), (String)Messages.warningMsg);
        rootModel.removeReference((IModel)myLib1);
        rootModel.removeReference((IModel)myLib2);
        session.save((IProgressMonitor)new NullProgressMonitor());
        DSemanticDecorator decorator = diagram.getView(this.CLASS_LIB1);
        diagram.deleteSemantic((DDiagramElement)decorator);
        properties = new PropertiesLoader().getProperties("org.polarsys.capella.core.libraries.manageReferences");
        status = referenceProperty.validate((Object)managerModel, (IPropertyContext)context);
        LibraryManagerWizardTestCase.assertEquals((int)status.getSeverity(), (int)4);
        LibraryManagerWizardTestCase.assertEquals((String)status.getMessage(), (String)Messages.dirtySessionMsg);
        session.save((IProgressMonitor)new NullProgressMonitor());
        properties = new PropertiesLoader().getProperties("org.polarsys.capella.core.libraries.manageReferences");
        status = referenceProperty.validate((Object)managerModel, (IPropertyContext)context);
        LibraryManagerWizardTestCase.assertEquals((int)status.getSeverity(), (int)4);
        LibraryManagerWizardTestCase.assertEquals((String)status.getMessage(), (String)Messages.resourceSetDirtyMsg);
    }
}

