/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.massactions.ju.testcases.view.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.polarsys.capella.test.massactions.ju.helpers.LayerHelper;
import org.polarsys.capella.test.massactions.ju.helpers.ViewHelper;
import org.polarsys.capella.test.massactions.ju.model.AbstractCapellaMATestCase;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.grid.IMAGridLayer;
import org.polarsys.kitalpha.massactions.edit.MEView;
import org.polarsys.kitalpha.massactions.shared.view.MAView;
import org.polarsys.kitalpha.massactions.visualize.MVView;

public class ColumnHideShowTest
extends AbstractCapellaMATestCase {
    @Override
    public void performTest() throws Exception {
        MEView editionView = ViewHelper.getActiveMEView();
        MVView visualizationView = ViewHelper.getActiveMVView();
        this.testColumnHideShow((MAView)editionView);
        this.testColumnHideShow((MAView)visualizationView);
    }

    public void testColumnHideShow(MAView view) {
        int columnIndex;
        ArrayList<EObject> data = new ArrayList<EObject>();
        data.add(this.getObject("3688cf59-97ee-4446-8041-7941cee6c767"));
        view.dataChanged(data);
        List<String> columnNamesToHide = Arrays.asList("name", "visibleInDoc", "ordered", "unique");
        IMAGridLayer gridLayer = LayerHelper.extractGridLayer(view);
        IMABodyLayer bodyLayer = gridLayer.getBodyLayer();
        IMAColumnPropertyAccessor columnPropertyAccessor = bodyLayer.getColumnPropertyAccessor();
        ColumnHideShowLayer columnHideShowLayer = bodyLayer.getColumnHideShowLayer();
        Set beforeHiddenColumns = Collections.emptySet();
        Set afterHiddenColumns = Collections.emptySet();
        for (String columnName : columnNamesToHide) {
            columnIndex = columnPropertyAccessor.getColumnIndex(columnName);
            if (columnIndex == -1) continue;
            int columnPosition = columnHideShowLayer.getColumnPositionByIndex(columnIndex);
            ColumnHideShowTest.assertFalse((boolean)columnHideShowLayer.isColumnIndexHidden(columnIndex));
            columnHideShowLayer.doCommand((ILayerCommand)new ColumnHideCommand((ILayer)columnHideShowLayer, columnPosition));
            ColumnHideShowTest.assertTrue((boolean)columnHideShowLayer.isColumnIndexHidden(columnIndex));
        }
        beforeHiddenColumns = new HashSet(columnHideShowLayer.getHiddenColumnIndexes());
        data.add(this.getObject("3398fdbf-3415-4d03-a457-477324d2e091"));
        view.dataChanged(data);
        afterHiddenColumns = new HashSet(columnHideShowLayer.getHiddenColumnIndexes());
        ColumnHideShowTest.assertEquals(beforeHiddenColumns, afterHiddenColumns);
        data.add(this.getObject("6ff020fc-4b56-45d1-8154-c24fe116bae1"));
        view.dataChanged(data);
        beforeHiddenColumns = new HashSet(columnHideShowLayer.getHiddenColumnIndexes());
        for (String columnName : columnNamesToHide) {
            columnIndex = columnPropertyAccessor.getColumnIndex(columnName);
            if (columnIndex == -1) continue;
            ColumnHideShowTest.assertTrue((boolean)columnHideShowLayer.isColumnIndexHidden(columnIndex));
        }
        for (String columnName : columnNamesToHide) {
            columnIndex = columnPropertyAccessor.getColumnIndex(columnName);
            if (columnIndex == -1) continue;
            ColumnHideShowTest.assertTrue((boolean)columnHideShowLayer.isColumnIndexHidden(columnIndex));
            columnHideShowLayer.doCommand((ILayerCommand)new MultiColumnShowCommand(Arrays.asList(columnIndex)));
            ColumnHideShowTest.assertFalse((boolean)columnHideShowLayer.isColumnIndexHidden(columnIndex));
        }
        ViewHelper.resetViews(view);
    }
}

