/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.accelerators;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StructuredSelection;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.projection.exchanges.handlers.GenerateLinksHandler;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.model.ju.model.MiscModel;

public class PhysicalLinkAcceleratorTest
extends MiscModel {
    public void test() throws Exception {
        CapellaModel model = this.getTestModel();
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        this.testOnSystemArchitecture((IScope)scope);
        this.testOnPhysicalArchitecture((IScope)scope);
        this.testOnLogicalArchitecture((IScope)scope);
    }

    private void testOnSystemArchitecture(IScope scope) {
        this.testPhysicalLinkAccelerator("b6cba2a7-2061-4900-975d-1fb8e64cdba6", scope, 1, "f456cf7d-933c-479d-9f68-6854e890b58a", "b6cba2a7-2061-4900-975d-1fb8e64cdba6");
    }

    private void testOnLogicalArchitecture(IScope scope) {
        this.testPhysicalLinkAccelerator("0f0c9802-be91-4cb7-8ba8-15a5c8f5e965", scope, 2, "a90fff0b-873a-40f2-98af-efb23208f0f8", "4f190174-7f6a-4c70-a554-fae57aae67a4");
        this.testPhysicalLinkAccelerator("7d43c14e-5d52-4902-a1a7-6e6cfe451ac3", scope, 1, "ea81d0f2-caab-400c-8f67-4f01e68cc816", "7d43c14e-5d52-4902-a1a7-6e6cfe451ac3");
        this.testPhysicalLinkAccelerator("4f190174-7f6a-4c70-a554-fae57aae67a4", scope, 0, "", "");
        this.testPhysicalLinkAccelerator("039e135a-e3ec-4a6e-83c4-68249002b84e", scope, 0, "", "");
    }

    private void testOnPhysicalArchitecture(IScope scope) {
        this.testPhysicalLinkAccelerator("f3bffaa0-f29d-43b4-bd02-d8acf2c4efa8", scope, 2, "4cbbbc04-3a40-4f1c-8c2b-01bc2b4164b3", "b5fe9222-5075-4ccf-9ceb-4f1211fcf917");
        this.testPhysicalLinkAccelerator("7a0bd881-61c9-45fb-87dc-03d4abc7cc13", scope, 1, "3b60352b-eb8d-4d4c-aa8e-8b3bf97500c4", "26b4dec4-0ffe-4905-8f7d-9b8f52e6562c");
        this.testPhysicalLinkAccelerator("28ad3c5c-16a2-4aef-a6af-5ddc1a90ca56", scope, 1, "85282fb6-b695-48bc-b194-fef9c4e22775", "07c482d3-f759-4bf0-ba98-1d487c8dbbf3");
        this.testPhysicalLinkAccelerator("b5fe9222-5075-4ccf-9ceb-4f1211fcf917", scope, 0, "", "");
        this.testPhysicalLinkAccelerator("26b4dec4-0ffe-4905-8f7d-9b8f52e6562c", scope, 0, "", "");
        this.testPhysicalLinkAccelerator("1ee8f69d-23a6-4b23-90c6-04349ecb0cd0", scope, 1, "95d2807c-fe32-4bd7-a119-040ff50d128c", "1ee8f69d-23a6-4b23-90c6-04349ecb0cd0");
        this.testPhysicalLinkAccelerator("b6c070bf-5c49-4ee7-9bff-9c90972bde16", scope, 1, "c82d306d-35dd-4a3a-9a30-133bcbf02be1", "b6c070bf-5c49-4ee7-9bff-9c90972bde16");
        this.testPhysicalLinkAccelerator("b1c8e398-73a0-4270-bc99-e13c02edf387", scope, 1, "38260cd0-2ba1-42b9-9274-a039f6b8b3f0", "b1c8e398-73a0-4270-bc99-e13c02edf387");
        this.testPhysicalLinkAccelerator("42aa1870-e261-4881-a462-eedc17742078", scope, 0, "", "");
    }

    protected void testPhysicalLinkAccelerator(String selectedElementId, IScope scope, int expectedNumberPL, String expectedPLtargetId, String expectedPortAllocationTargetId) {
        Part inputElement = (Part)IdManager.getInstance().getEObject(selectedElementId, scope);
        Component component = (Component)inputElement.getAbstractType();
        PhysicalLinkAcceleratorTest.assertTrue((boolean)component.getOwnedPhysicalLinks().isEmpty());
        try {
            new GenerateLinksHandler().execute(this.createExecutionEvent(inputElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        PhysicalLinkAcceleratorTest.assertEquals((int)expectedNumberPL, (int)component.getOwnedPhysicalLinks().size());
        if (expectedNumberPL != 0) {
            Part plTargetPart = (Part)IdManager.getInstance().getEObject(expectedPLtargetId, scope);
            Component expectedPLTarget = (Component)plTargetPart.getAbstractType();
            EObject plTarget = ((AbstractPhysicalLinkEnd)((PhysicalLink)component.getOwnedPhysicalLinks().get(0)).getLinkEnds().get(1)).eContainer();
            PhysicalLinkAcceleratorTest.assertEquals((Object)expectedPLTarget, (Object)plTarget);
            PhysicalLink physicalLink = (PhysicalLink)component.getOwnedPhysicalLinks().get(0);
            PhysicalLinkAcceleratorTest.assertFalse((boolean)physicalLink.getAllocatedComponentExchanges().isEmpty());
            PhysicalPort port = physicalLink.getSourcePhysicalPort();
            PhysicalLinkAcceleratorTest.assertFalse((boolean)port.getOwnedComponentPortAllocations().isEmpty());
            ComponentPortAllocation portAllocation = (ComponentPortAllocation)port.getOwnedComponentPortAllocations().get(0);
            EObject portAllocationTargetComponent = portAllocation.getTargetElement().eContainer();
            Part target = (Part)IdManager.getInstance().getEObject(expectedPortAllocationTargetId, scope);
            Component expectedTargetComponent = (Component)target.getAbstractType();
            PhysicalLinkAcceleratorTest.assertEquals((Object)portAllocationTargetComponent, (Object)expectedTargetComponent);
        }
        try {
            new GenerateLinksHandler().execute(this.createExecutionEvent(inputElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        PhysicalLinkAcceleratorTest.assertEquals((int)expectedNumberPL, (int)component.getOwnedPhysicalLinks().size());
    }

    private ExecutionEvent createExecutionEvent(Object element) {
        EvaluationContext context = new EvaluationContext(null, new Object());
        HashMap parameters = new HashMap();
        ExecutionEvent event = new ExecutionEvent(null, parameters, null, (Object)context);
        context.addVariable("selection", (Object)new StructuredSelection(element));
        return event;
    }
}

