/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.crossreferencer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.mdsofa.common.helper.EcoreHelper;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public abstract class AbstractReflectiveCrossReferencerTest
extends BasicTestCase {
    protected HashMap<EClass, List<EClass>> _hierarchies;
    private ExecutionManager _executionManager;

    protected ExecutionManager getExecutionManager() {
        if (this._executionManager == null) {
            this._executionManager = ExecutionManagerRegistry.getInstance().addNewManager();
        }
        return this._executionManager;
    }

    protected EObject createType(EClass type_p) {
        AbstractReflectiveCrossReferencerTest.assertNotNull((Object)type_p);
        EClass type = EcoreHelper.getStaticClass((EClass)type_p);
        EObject result = type.getEPackage().getEFactoryInstance().create(type);
        AbstractReflectiveCrossReferencerTest.assertNotNull((Object)result);
        HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)this.getExecutionManager().getEditingDomain()).getContents().add((Object)result);
        return result;
    }

    protected void executeTestCommand(ICommand command_p) {
        AbstractReflectiveCrossReferencerTest.assertNotNull((Object)command_p);
        this.getExecutionManager().execute(command_p);
    }

    protected abstract List<EClass> getRootTypes();

    protected EClass getSubType(EClass rootType_p, int index_p) {
        List<EClass> hierarchy = this._hierarchies.get(rootType_p);
        return hierarchy != null && index_p < hierarchy.size() ? hierarchy.get(index_p) : null;
    }

    protected int getSubTypesCount(EClass rootType_p) {
        List<EClass> hierarchy = this._hierarchies.get(rootType_p);
        return hierarchy != null ? hierarchy.size() : 0;
    }

    protected boolean isSuperType(EClass type_p, Collection<EClass> superTypes_p) {
        boolean result = false;
        if (superTypes_p == null || type_p == null) {
            return result;
        }
        for (EClass superType : superTypes_p) {
            if (!EcoreHelper.equals((EObject)type_p, (EObject)superType, (boolean)false)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void postRunTest() {
        if (this._hierarchies != null) {
            for (List<EClass> hierarchy : this._hierarchies.values()) {
                hierarchy.clear();
            }
            this._hierarchies.clear();
            this._hierarchies = null;
        }
        ExecutionManagerRegistry.getInstance().removeManager(this._executionManager);
    }

    protected void preRunTest() {
        this.loadM2();
        this._hierarchies = new HashMap(0);
        List<EClass> roots = this.getRootTypes();
        if (roots == null || roots.isEmpty()) {
            return;
        }
        ResourceSet resourceSet = this.getExecutionManager().getEditingDomain().getResourceSet();
        TreeIterator contents = resourceSet.getAllContents();
        while (contents.hasNext()) {
            EClass classType;
            Notifier type = (Notifier)contents.next();
            if (!(type instanceof EClass) || (classType = (EClass)type).isAbstract() || this.isDeprecated(classType)) continue;
            EList eAllSuperTypes = classType.getEAllSuperTypes();
            for (EClass root : roots) {
                if (!this.isSuperType(root, (Collection<EClass>)eAllSuperTypes)) continue;
                List<EClass> container = this._hierarchies.get(root);
                if (container == null) {
                    container = new ArrayList<EClass>(0);
                    this._hierarchies.put(root, container);
                }
                container.add(classType);
            }
        }
    }

    protected void removeFromResource(EObject object_p) {
        AbstractReflectiveCrossReferencerTest.assertNotNull((Object)object_p);
        if (object_p.eResource() != null) {
            object_p.eResource().getContents().remove((Object)object_p);
        }
    }

    protected boolean isDeprecated(EClass eclass_p) {
        EMap details;
        String value;
        EAnnotation annotation = eclass_p.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        return annotation != null && (value = (String)(details = annotation.getDetails()).get((Object)"documentation")) != null && value.startsWith("@deprecated");
    }

    protected void loadM2() {
        ResourceSet resourceSet = this.getExecutionManager().getEditingDomain().getResourceSet();
        resourceSet.getResource(FileHelper.getFileFullUri((String)"/org.polarsys.capella.core.data.gen/model/CapellaModeller.ecore"), true);
        int resourcesCount = resourceSet.getResources().size();
        int previousResourcesCount = 0;
        while (resourcesCount != previousResourcesCount) {
            previousResourcesCount = resourcesCount;
            ArrayList resources = new ArrayList(resourceSet.getResources());
            for (Resource resource : resources) {
                EcoreUtil.resolveAll((Resource)resource);
            }
            resourcesCount = resourceSet.getResources().size();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.preRunTest();
    }
}

