/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.diffmerge;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.junit.Assert;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.compare.CapellaComparisonMethod;
import org.polarsys.capella.core.compare.CapellaComparisonMethodFactory;
import org.polarsys.capella.core.compare.CapellaScopeFactory;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class DiffmergeDomain
extends BasicTestCase {
    private String CAPELLA1 = "DiffMergeSourcePrj/DiffMergeSourcePrj.capella";
    private String CAPELLA2 = "DiffMergeSourceV1Prj/DiffMergeSourcePrj.capella";
    private String AIRD1 = "DiffMergeSourcePrj/DiffMergeSourcePrj.aird";
    private String AIRD2 = "DiffMergeSourceV1Prj/DiffMergeSourcePrj.aird";

    protected void setUp() throws Exception {
        Session session2;
        super.setUp();
        IFile file1 = FileHelper.getPlatformFile((String)this.AIRD1);
        IFile file2 = FileHelper.getPlatformFile((String)this.AIRD2);
        Session session = SessionManager.INSTANCE.getExistingSession(EcoreUtil2.getURI((IFile)file1));
        if (session != null) {
            session.close((IProgressMonitor)new NullProgressMonitor());
        }
        if ((session2 = SessionManager.INSTANCE.getExistingSession(EcoreUtil2.getURI((IFile)file2))) != null) {
            session2.close((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void test() throws Exception {
        this.onCapellaResource();
        this.onClosedSession();
        this.onOpenedSession1();
        this.onOpenedSession2();
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("DiffMergeSourcePrj", "DiffMergeSourceV1Prj");
    }

    public void onCapellaResource() throws Exception {
        IFile file1 = FileHelper.getPlatformFile((String)this.CAPELLA1);
        IFile file2 = FileHelper.getPlatformFile((String)this.CAPELLA2);
        CapellaComparisonMethod method = this.createComparison(file1, file2);
        EditingDomain commonDomain = method.getEditingDomain();
        DiffmergeDomain.assertTrue((boolean)(commonDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain));
        DiffmergeDomain.assertNotNull((Object)ExecutionManagerRegistry.getInstance().getExecutionManager(commonDomain));
        EditingDomain specificDomain = this.getSpecificDomain(method, Role.TARGET);
        DiffmergeDomain.assertTrue((boolean)(specificDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain));
        DiffmergeDomain.assertNotNull((Object)ExecutionManagerRegistry.getInstance().getExecutionManager(specificDomain));
    }

    public void onClosedSession() throws Exception {
        IFile file1 = FileHelper.getPlatformFile((String)this.AIRD1);
        IFile file2 = FileHelper.getPlatformFile((String)this.AIRD2);
        CapellaComparisonMethod method = this.createComparison(file1, file2);
        EditingDomain commonDomain = method.getEditingDomain();
        DiffmergeDomain.assertTrue((boolean)(commonDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain));
        EditingDomain specificDomain = this.getSpecificDomain(method, Role.TARGET);
        DiffmergeDomain.assertTrue((boolean)(specificDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain));
    }

    public void onOpenedSession1() throws Exception {
        IFile file1 = FileHelper.getPlatformFile((String)this.AIRD1);
        IFile file2 = FileHelper.getPlatformFile((String)this.AIRD2);
        Session session = this.getSession("DiffMergeSourcePrj");
        CapellaComparisonMethod method = this.createComparison(file1, file2);
        EditingDomain commonDomain = method.getEditingDomain();
        DiffmergeDomain.assertTrue((boolean)(commonDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain));
        DiffmergeDomain.assertTrue((boolean)commonDomain.equals(session.getTransactionalEditingDomain()));
        DiffmergeDomain.assertNotNull((Object)ExecutionManagerRegistry.getInstance().getExecutionManager(commonDomain));
        EditingDomain specificDomain = this.getSpecificDomain(method, Role.TARGET);
        DiffmergeDomain.assertEquals((Object)commonDomain, (Object)specificDomain);
        EditingDomain specificDomain2 = this.getSpecificDomain(method, Role.REFERENCE);
        Assert.assertNotEquals((Object)commonDomain, (Object)specificDomain2);
        DiffmergeDomain.assertTrue((boolean)(specificDomain2 instanceof SemanticEditingDomainFactory.SemanticEditingDomain));
        DiffmergeDomain.assertNotNull((Object)ExecutionManagerRegistry.getInstance().getExecutionManager(specificDomain2));
    }

    public void onOpenedSession2() throws Exception {
        IFile file1 = FileHelper.getPlatformFile((String)this.AIRD1);
        IFile file2 = FileHelper.getPlatformFile((String)this.AIRD2);
        Session session = this.getSession("DiffMergeSourcePrj");
        Session session2 = this.getSession("DiffMergeSourceV1Prj");
        Assert.assertNotEquals((Object)session, (Object)session2);
        CapellaComparisonMethod method = this.createComparison(file1, file2);
        EditingDomain commonDomain = method.getEditingDomain();
        DiffmergeDomain.assertTrue((commonDomain == null ? 1 : 0) != 0);
        EditingDomain specificDomain = this.getSpecificDomain(method, Role.TARGET);
        DiffmergeDomain.assertTrue((boolean)(specificDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain));
        DiffmergeDomain.assertTrue((boolean)specificDomain.equals(session.getTransactionalEditingDomain()));
        DiffmergeDomain.assertNotNull((Object)ExecutionManagerRegistry.getInstance().getExecutionManager(specificDomain));
        EditingDomain specificDomain2 = this.getSpecificDomain(method, Role.REFERENCE);
        DiffmergeDomain.assertTrue((boolean)(specificDomain2 instanceof SemanticEditingDomainFactory.SemanticEditingDomain));
        DiffmergeDomain.assertTrue((boolean)specificDomain2.equals(session2.getTransactionalEditingDomain()));
        DiffmergeDomain.assertNotNull((Object)ExecutionManagerRegistry.getInstance().getExecutionManager(specificDomain2));
    }

    protected CapellaComparisonMethod createComparison(IFile file1, IFile file2) {
        CapellaScopeFactory scopFct = new CapellaScopeFactory();
        IModelScopeDefinition left = scopFct.createScopeDefinition((Object)file1, null, true);
        IModelScopeDefinition right = scopFct.createScopeDefinition((Object)file2, null, true);
        CapellaComparisonMethodFactory compFactory = new CapellaComparisonMethodFactory();
        CapellaComparisonMethod method = (CapellaComparisonMethod)compFactory.createComparisonMethod(left, right, null);
        method.setVerbose(false);
        return method;
    }

    protected EditingDomain getSpecificDomain(CapellaComparisonMethod method, Role role) {
        IEditableTreeDataScope _leftScope = method.getModelScopeDefinition(role).createScope((Object)method.getResourceSet(role));
        EditingDomain specificDomain = ((IEditingDomainProvider)_leftScope).getEditingDomain();
        return specificDomain;
    }
}

