/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.helpers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.ui.semantic.browser.sirius.helpers.SiriusSelectionHelper;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CapellaAdapterHelperTestCase
extends BasicTestCase {
    public static String MODEL_NAME = "copyPasteLayout";
    public static String LA__ROOT_LF__LOGICALFUNCTION_1 = "57405f1a-bc81-43b9-967d-4a4d954da095";
    public static String LA__LOGICAL_COMPONENT = "964d71a7-9199-4afc-8773-95be6c65e450";
    public static String LA__LOGICAL_COMPONENT_PART = "fecd48b1-03f8-4321-bdac-1776f2f7f311";
    public static String LAB_DIAGRAM = "[LAB] Logical System";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    public void test() throws Exception {
        LightMarkerRegistry registry;
        CapellaModel model = this.getTestModel(MODEL_NAME);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        SessionContext context = new SessionContext(session);
        DSemanticDiagram labDiagram = (DSemanticDiagram)DiagramHelper.getDRepresentation((Session)session, (String)LAB_DIAGRAM);
        DRepresentationDescriptor labDiagramDescriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)labDiagram);
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic element of a diagram should be its target.", (Object)labDiagram.getTarget(), (Object)CapellaAdapterHelper.resolveSemanticObject((Object)labDiagram));
        CapellaAdapterHelperTestCase.assertEquals((String)"Related EObject of a diagram should be its descriptor", (Object)labDiagramDescriptor, (Object)CapellaAdapterHelper.resolveEObject((Object)labDiagram));
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic element of a descriptor should be the target of its diagram", (Object)labDiagram.getTarget(), (Object)CapellaAdapterHelper.resolveSemanticObject((Object)labDiagramDescriptor));
        DiagramContext diagramContext = (DiagramContext)new OpenDiagramStep(context, LAB_DIAGRAM).run();
        DSemanticDecorator functionView = diagramContext.getView(LA__ROOT_LF__LOGICALFUNCTION_1);
        EObject function = IdManager.getInstance().getEObject(LA__ROOT_LF__LOGICALFUNCTION_1, (IScope)scope);
        DSemanticDecorator partView = diagramContext.getView(LA__LOGICAL_COMPONENT_PART);
        final Part labPart = (Part)IdManager.getInstance().getEObject(LA__LOGICAL_COMPONENT_PART, (IScope)scope);
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic element of the view of a function should be the function itself", (Object)function, (Object)CapellaAdapterHelper.resolveSemanticObject((Object)functionView));
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic element of a Function should be itself", (Object)function, (Object)CapellaAdapterHelper.resolveSemanticObject((Object)function));
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic element of a diagram should be its target.", (Object)labDiagram.getTarget(), (Object)CapellaAdapterHelper.resolveSemanticObject((Object)labDiagram));
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic element of a Part should be the part.", (Object)labPart, (Object)CapellaAdapterHelper.resolveSemanticObject((Object)labPart));
        CapellaAdapterHelperTestCase.assertEquals((String)"Business element of a Part should be its component.", (Object)labPart.getAbstractType(), (Object)CapellaAdapterHelper.resolveBusinessObject((Object)labPart));
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic element of a diagram element of a Part should be the part.", (Object)labPart, (Object)CapellaAdapterHelper.resolveSemanticObject((Object)partView));
        CapellaAdapterHelperTestCase.assertEquals((String)"Business element of a diagram element of a Part should be its component.", (Object)labPart.getAbstractType(), (Object)CapellaAdapterHelper.resolveBusinessObject((Object)partView));
        DecorationNode decorationNode = NotationFactory.eINSTANCE.createDecorationNode();
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic element of a DecorationNode should be null", null, (Object)CapellaAdapterHelper.resolveSemanticObject((Object)decorationNode));
        CapellaAdapterHelperTestCase.assertEquals((String)"Business element of a DecorationNode should be null", null, (Object)CapellaAdapterHelper.resolveBusinessObject((Object)decorationNode));
        CapellaAdapterHelperTestCase.assertEquals((String)"DescriptorOrBusinessObject of a DecorationNode element should be null", null, (Object)CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)decorationNode));
        Node node = NotationFactory.eINSTANCE.createNode();
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic element of a Node should be null", null, (Object)CapellaAdapterHelper.resolveSemanticObject((Object)node));
        CapellaAdapterHelperTestCase.assertEquals((String)"Business element of a Node should be null", null, (Object)CapellaAdapterHelper.resolveBusinessObject((Object)node));
        CapellaAdapterHelperTestCase.assertEquals((String)"DescriptorOrBusinessObject of a Node element should be null", null, (Object)CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)node));
        CapellaAdapterHelperTestCase.assertEquals((String)"Legacy Semantic object (onlySemantic=false) of a diagram should be the descriptor.", (Object)labDiagramDescriptor, (Object)CapellaAdapterHelper.resolveSemanticObject((Object)labDiagram, (boolean)false));
        CapellaAdapterHelperTestCase.assertEquals((String)"Legacy Semantic object (onlySemantic=true) of a diagram should be the target.", (Object)labDiagram.getTarget(), (Object)CapellaAdapterHelper.resolveSemanticObject((Object)labDiagram, (boolean)true));
        CapellaAdapterHelperTestCase.assertEquals((String)"Legacy Semantic object (onlySemantic=false) of a diagram element should be the business element.", (Object)labPart.getAbstractType(), (Object)CapellaAdapterHelper.resolveSemanticObject((Object)partView, (boolean)false));
        CapellaAdapterHelperTestCase.assertEquals((String)"Legacy Semantic object (onlySemantic=true) of a diagram element should be the business element.", (Object)labPart.getAbstractType(), (Object)CapellaAdapterHelper.resolveSemanticObject((Object)partView, (boolean)true));
        CapellaAdapterHelperTestCase.assertEquals((String)"DescriptorOrBusinessObject of a diagram should be the descriptor.", (Object)labDiagramDescriptor, (Object)CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)labDiagram));
        CapellaAdapterHelperTestCase.assertEquals((String)"DescriptorOrBusinessObject of a diagram element should be the business element.", (Object)labPart.getAbstractType(), (Object)CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)partView));
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic browser element of a diagram element should be the business element.", (Object)labPart.getAbstractType(), (Object)SiriusSelectionHelper.handleSelection(null, (ISelection)new StructuredSelection((Object)partView)));
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic browser element of a diagram should be the descriptor.", (Object)labDiagramDescriptor, (Object)SiriusSelectionHelper.handleSelection(null, (ISelection)new StructuredSelection((Object)labDiagram)));
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic browser element of a function should be the function.", (Object)function, (Object)SiriusSelectionHelper.handleSelection(null, (ISelection)new StructuredSelection((Object)function)));
        CapellaAdapterHelperTestCase.assertEquals((String)"Semantic browser element of a part should be the component.", (Object)labPart.getAbstractType(), (Object)SiriusSelectionHelper.handleSelection(null, (ISelection)new StructuredSelection((Object)labPart)));
        CapellaAdapterHelperTestCase.assertEquals((String)"Navigation of a diagram element should be the business element.", (Object)labPart.getAbstractType(), (Object)LocateInCapellaExplorerAction.getElement((Object)partView));
        CapellaAdapterHelperTestCase.assertEquals((String)"Navigation of a diagram should be the descriptor.", (Object)labDiagramDescriptor, (Object)LocateInCapellaExplorerAction.getElement((Object)labDiagram));
        CapellaAdapterHelperTestCase.assertEquals((String)"Navigation of a function should be the function.", (Object)function, (Object)LocateInCapellaExplorerAction.getElement((Object)function));
        CapellaAdapterHelperTestCase.assertEquals((String)"Navigation of a part should be the component.", (Object)labPart.getAbstractType(), (Object)LocateInCapellaExplorerAction.getElement((Object)labPart));
        Diagnostic fakeDiagnostic = new Diagnostic(){

            public String getSource() {
                return null;
            }

            public int getSeverity() {
                return 0;
            }

            public String getMessage() {
                return null;
            }

            public Throwable getException() {
                return null;
            }

            public List<?> getData() {
                return Collections.singletonList(labPart.getAbstractType());
            }

            public int getCode() {
                return 0;
            }

            public List<Diagnostic> getChildren() {
                return null;
            }
        };
        LightMarkerRegistry lightMarkerRegistry = registry = new LightMarkerRegistry();
        lightMarkerRegistry.getClass();
        LightMarkerRegistry.LightMarker fakeMarker = new LightMarkerRegistry.LightMarker(lightMarkerRegistry, null, null, fakeDiagnostic);
        CapellaAdapterHelperTestCase.assertEquals((String)"Navigation of a component to the Project Explorer from Information view should be the component.", (Object)labPart.getAbstractType(), (Object)LocateInCapellaExplorerAction.getElement((Object)fakeMarker));
        CapellaAdapterHelperTestCase.assertEquals((String)"Navigation of a component to the Semantic Browser from Information view should be the component.\"", (Object)labPart.getAbstractType(), (Object)SiriusSelectionHelper.handleSelection(null, (ISelection)new StructuredSelection((Object)fakeMarker)));
    }
}

