/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.helpers;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.polarsys.capella.core.model.handler.command.CapellaResourceNamingHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class CapellaResourceNamingHelperTestCase
extends BasicTestCase {
    private static final String[] INVALID_NAMES;
    private static final char[] INVALID_CHARS;
    private static final char[] VALID_CHARS;
    private static final int[] RESOURCE_TYPES;
    private static final String SUFFIX_NAME = "suffix01";
    private static final String PREFIX_NAME = "prefix02";
    private static final String NAME_SHOULD_BE_INVALID_MSG = "Resource name {0} should be invalid";
    private static final String NAME_SHOULD_BE_VALID_MSG = "Resource name {0} should be valid";

    static {
        String[] stringArray = new String[2];
        stringArray[1] = "";
        INVALID_NAMES = stringArray;
        INVALID_CHARS = new char[]{'#', '%', '$'};
        VALID_CHARS = new char[]{'-', '!', '~', '@', '^', '(', ')', '[', ']', '_'};
        RESOURCE_TYPES = new int[]{1, 2, 4};
    }

    public void test() throws Exception {
        this.assertInvalidNames();
        this.assertValidNames();
    }

    private void assertValidNames() {
        char[] cArray = VALID_CHARS;
        int n = VALID_CHARS.length;
        int n2 = 0;
        while (n2 < n) {
            char validChar = cArray[n2];
            String simpleName = String.valueOf(validChar);
            this.assertValidName(simpleName);
            String prefixName = PREFIX_NAME + simpleName;
            this.assertValidName(prefixName);
            String suffixName = simpleName + SUFFIX_NAME;
            this.assertValidName(suffixName);
            String fullName = PREFIX_NAME + simpleName + SUFFIX_NAME;
            this.assertValidName(fullName);
            ++n2;
        }
    }

    private void assertInvalidNames() {
        Object[] objectArray = INVALID_NAMES;
        int n = INVALID_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String invalidName = objectArray[n2];
            this.assertInvalidName(invalidName);
            ++n2;
        }
        objectArray = INVALID_CHARS;
        n = INVALID_CHARS.length;
        n2 = 0;
        while (n2 < n) {
            String invalidChar = objectArray[n2];
            String simpleName = String.valueOf((char)invalidChar);
            this.assertInvalidName(simpleName);
            String prefixName = PREFIX_NAME + simpleName;
            this.assertInvalidName(prefixName);
            String suffixName = simpleName + SUFFIX_NAME;
            this.assertInvalidName(suffixName);
            String fullName = PREFIX_NAME + simpleName + SUFFIX_NAME;
            this.assertInvalidName(fullName);
            ++n2;
        }
    }

    private void assertInvalidName(String invalidName) {
        int[] nArray = RESOURCE_TYPES;
        int n = RESOURCE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int resourceTypeMask = nArray[n2];
            IStatus status = CapellaResourceNamingHelper.validateName((String)invalidName, (int)resourceTypeMask);
            String message = MessageFormat.format(NAME_SHOULD_BE_INVALID_MSG, invalidName);
            CapellaResourceNamingHelperTestCase.assertFalse((String)message, (boolean)status.isOK());
            ++n2;
        }
    }

    private void assertValidName(String invalidName) {
        int[] nArray = RESOURCE_TYPES;
        int n = RESOURCE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int resourceTypeMask = nArray[n2];
            IStatus status = CapellaResourceNamingHelper.validateName((String)invalidName, (int)resourceTypeMask);
            String message = MessageFormat.format(NAME_SHOULD_BE_VALID_MSG, invalidName);
            CapellaResourceNamingHelperTestCase.assertTrue((String)message, (boolean)status.isOK());
            ++n2;
        }
    }
}

