/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.helpers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.platform.sirius.ui.session.GitConflictHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class GitConflictHelperTest
extends BasicTestCase {
    private final Collection<String> projectFiles = Arrays.asList("/gch-project/fragments/SA.capellafragment", "/gch-project/fragments/SA.airdfragment", "/gch-project/gch-project.afm", "/gch-project/gch-project.capella", "/gch-project/gch-project.aird");
    private final Collection<String> libraryFiles = Arrays.asList("/gch-library/fragments/SA.capellafragment", "/gch-library/fragments/SA.airdfragment", "/gch-library/gch-library.afm", "/gch-library/gch-library.capella", "/gch-library/gch-library.aird");
    private final Collection<String> projectAndlibraryFiles = Stream.concat(this.projectFiles.stream(), this.libraryFiles.stream()).collect(Collectors.toList());

    public List<String> getRequiredTestModels() {
        return Arrays.asList("gch-library", "gch-project");
    }

    public void test() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("gch-project");
        Collection<String> values = this.toPaths(GitConflictHelper.getFiles((IProject)project, x -> true));
        GitConflictHelperTest.assertTrue((String)("Some files are missing in GitConflictHelper.getFiles(project): " + String.valueOf(this.projectFiles.stream().filter(x -> !values.contains(x)).collect(Collectors.toList()))), (boolean)this.isEquals(values, this.projectFiles));
        Session session = this.getSession("gch-project");
        Collection<String> values3 = this.toPaths(GitConflictHelper.getFiles((Session)session, x -> true));
        GitConflictHelperTest.assertTrue((String)("Some files are missing in GitConflictHelper.getFiles(session): " + String.valueOf(this.projectAndlibraryFiles.stream().filter(x -> !values3.contains(x)).collect(Collectors.toList()))), (boolean)this.isEquals(this.projectAndlibraryFiles, values3));
        GitConflictHelperTest.assertFalse((boolean)GitConflictHelper.isInGitRepository(null));
    }

    private boolean isEquals(Collection<String> e, Collection<String> r) {
        return e.containsAll(r) && e.size() == r.size();
    }

    private Collection<String> toPaths(Collection<IFile> files) {
        return files.stream().map(x -> x.getFullPath().toPortableString()).collect(Collectors.toList());
    }
}

