/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.helpers;

import java.util.Arrays;
import java.util.List;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class PhysicalComponentExtTestCase
extends BasicTestCase {
    public static final String ACTOR_NODE_1 = "729bf141-4075-421f-a3bc-0af4f5e3ff67";
    public static final String ACTOR_NODE_2 = "c491989d-d8fb-447f-b4b8-29ea4190c2b5";
    public static final String PC_NODE_1 = "58375267-b126-4d8e-b1ae-31f1cbddaf9e";
    public static final String PC_NODE_2 = "49b9d739-5ee5-414a-b233-d1b420020f20";
    public static final String PC_BEHAVIOR_2 = "2af366ae-f8a2-4b7f-93d1-6e18fd59ad81";
    public static final String ACTOR_BEHAVIOR_1 = "10ed2342-8332-45ae-801b-43673c6f8c1e";
    public static final String PC_BEHAVIOR_1 = "c7efebbb-b9de-440a-a3af-1583e5cec664";
    public static final String ACTOR_BEHAVIOR_2 = "3eea84a2-f2a3-4efc-93f2-cf44dfc2020b";
    public static final String DEPLOYED_PC_NODE_1 = "579dcdaa-98a1-4c79-a2d9-64adc202319e";
    public static final String DEPLOYED_ACTOR_NODE_1 = "f0eb97d1-919c-453a-909c-f3db749bff04";
    public static String MODEL_NAME = "miscmodel";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(MODEL_NAME);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        PhysicalComponentExtTestCase.assertFalse((String)"Can not deploy actor node on itself", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_NODE_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_NODE_1, (IScope)scope))));
        PhysicalComponentExtTestCase.assertFalse((String)"Can not deploy pc node on itself", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_NODE_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_NODE_1, (IScope)scope))));
        PhysicalComponentExtTestCase.assertFalse((String)"Can not deploy pc behavior on itself", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_BEHAVIOR_2, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_BEHAVIOR_2, (IScope)scope))));
        PhysicalComponentExtTestCase.assertFalse((String)"Can not deploy actor behavior on itself", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_2, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_2, (IScope)scope))));
        PhysicalComponentExtTestCase.assertFalse((String)"Can not deploy Node on Behavior", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_NODE_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_BEHAVIOR_1, (IScope)scope))));
        PhysicalComponentExtTestCase.assertFalse((String)"Can not deploy Node on Behavior", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_NODE_2, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_2, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Node on Node", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_NODE_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_NODE_2, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Node on Node", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_NODE_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_NODE_2, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Node on Node", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_NODE_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_NODE_1, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Node on Node", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_NODE_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_NODE_1, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Behavior on Node", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_2, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_NODE_1, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Behavior on Node", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_2, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_NODE_1, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Behavior on Behavior", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_BEHAVIOR_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_BEHAVIOR_2, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Behavior on Behavior", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_2, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Behavior on Behavior", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_BEHAVIOR_1, (IScope)scope))));
        PhysicalComponentExtTestCase.assertTrue((String)"Can deploy Behavior on Behavior", (boolean)PhysicalComponentExt.canDeploy((PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(PC_BEHAVIOR_1, (IScope)scope)), (PhysicalComponent)((PhysicalComponent)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_1, (IScope)scope))));
    }
}

