/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.menu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.mdsofa.common.constant.ICommonConstants;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.PrimitiveWrapper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.platform.sirius.ui.handlers.CopyPathHandler;
import org.polarsys.capella.core.platform.sirius.ui.handlers.CopyUniqueIdentifierHandler;
import org.polarsys.capella.core.platform.sirius.ui.handlers.DeleteHandler;
import org.polarsys.capella.core.sirius.ui.handlers.CopyTextHandler;
import org.polarsys.capella.core.ui.properties.richtext.handlers.CopyAsHyperlinkForDescriptionHandler;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.model.ju.model.MiscModel;

public class CapellaMenusTestCase
extends MiscModel {
    ICapellaModel model;
    IScope scope;

    public void test() throws Exception {
        this.init();
        EObject selectedElement = IdManager.getInstance().getEObject("5b6b9d5b-d024-4423-9271-bcb3d77469c2", this.scope);
        CapellaMenusTestCase.assertNotNull((Object)selectedElement);
        this.testMenus("5b6b9d5b-d024-4423-9271-bcb3d77469c2", selectedElement);
        String pabDiagramID = "_HY2uQekKEem8xqbBNWv2mQ";
        EObject pabDiagram = IdManager.getInstance().getEObject(pabDiagramID, this.scope);
        String pabDiagramText = "[PAB] Structure";
        String pabDiagramID2 = "_IdZcUH-AEeuYvtZOEmS6hg";
        EObject pabDiagram2 = IdManager.getInstance().getEObject(pabDiagramID2, this.scope);
        String pabDiagram2Text = "[PAB] Structure 2";
        String sf1ID = "e543b7f1-618e-45a3-b73c-4876f14e72e0";
        EObject sf1 = IdManager.getInstance().getEObject(sf1ID, this.scope);
        String ei1ID = "9e0e8188-0b84-49fa-8cd2-0c84cbe5b1f6";
        EObject ei1 = IdManager.getInstance().getEObject(ei1ID, this.scope);
        CapellaMenusTestCase.assertTrue((boolean)(pabDiagram instanceof DRepresentationDescriptor));
        this.testCopyAsUniqueIdentifier(new Object[]{pabDiagram}, pabDiagramID);
        this.testCopyAsUniqueIdentifier(new Object[]{pabDiagram, pabDiagram2}, pabDiagramID + ICommonConstants.LINE_SEPARATOR + pabDiagramID2);
        this.testCopyAsUniqueIdentifier(new Object[]{sf1}, sf1ID);
        this.testCopyAsUniqueIdentifier(new Object[]{sf1, ei1}, sf1ID + ICommonConstants.LINE_SEPARATOR + ei1ID);
        this.testCopyAsTextNumericValue(5);
        this.testCopyAsTextNumericValue(5, 8, 9);
        this.testCopyAsText(new Object[]{pabDiagram}, pabDiagramText);
        this.testCopyAsText(new Object[]{pabDiagram, pabDiagram2}, pabDiagramText + ICommonConstants.LINE_SEPARATOR + pabDiagram2Text);
        this.testDiagramMenus(pabDiagramID, (DRepresentationDescriptor)pabDiagram);
    }

    protected void init() {
        this.model = this.getTestModel();
        this.scope = new ScopeModelWrapper((IModel)this.model);
    }

    protected void testMenus(String selectedElementId, EObject selectedElement) {
        this.testCopyAsHyperlinkForDescriptionCommand(selectedElement);
        this.testCopyAsTextCommand(selectedElement);
        this.testCopyQualifiedNameCommand(selectedElement);
        this.testDeleteCommand(selectedElementId, selectedElement);
    }

    protected void testDiagramMenus(String selectedElementId, DRepresentationDescriptor selectedElement) {
        this.testCopyAsHyperlinkForDescriptionCommand((EObject)selectedElement);
        this.testCopyAsTextCommand((EObject)selectedElement);
        this.testCopyAsTextValue((EObject)selectedElement, selectedElement.getName());
        this.testDeleteCommand(selectedElementId, (EObject)selectedElement);
    }

    protected void testDeleteCommand(String selectedElementId, EObject selectedElement) {
        try {
            new DeleteHandler(){

                protected boolean withConfirmDeletion() {
                    return false;
                }
            }.execute(this.createExecutionEvent(selectedElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (selectedElement instanceof CapellaElement) {
            CapellaElement element = (CapellaElement)selectedElement;
            String id = element.getId();
            CapellaMenusTestCase.assertEquals((String)id, (String)selectedElementId);
        }
        EObject object = IdManager.getInstance().getEObject(selectedElementId, this.scope);
        CapellaMenusTestCase.assertNull((Object)object);
    }

    protected void testCopyQualifiedNameCommand(EObject selectedElement) {
        try {
            new CopyPathHandler().execute(this.createExecutionEvent(selectedElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    protected void testCopyAsHyperlinkForDescriptionCommand(EObject selectedElement) {
        try {
            new CopyAsHyperlinkForDescriptionHandler().execute(this.createExecutionEvent(selectedElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    protected void testCopyAsTextCommand(EObject selectedElement) {
        try {
            new CopyTextHandler().execute(this.createExecutionEvent(selectedElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    protected void testCopyAsTextValue(EObject selectedElement, String checkLabel) {
        CapellaMenusTestCase.assertTrue((String)("Copied label should be: " + checkLabel), (boolean)checkLabel.equals(this.getCopyAsText(selectedElement)));
    }

    protected void testCopyAsText(Object[] selectedElements, String checkLabel) {
        CapellaMenusTestCase.assertTrue((String)("Copied label should be: " + checkLabel), (boolean)checkLabel.equals(this.getCopyAsText(selectedElements)));
    }

    protected void testCopyAsTextNumericValue(Integer ... values) {
        Object[] wrappers = Arrays.stream(values).map(value -> new PrimitiveWrapper(value)).toArray();
        String valuesStr = Arrays.stream(values).map(value -> String.valueOf(value)).collect(Collectors.joining(ICommonConstants.LINE_SEPARATOR));
        CapellaMenusTestCase.assertEquals((String)valuesStr, (String)this.getCopyAsText(wrappers));
    }

    protected void testCopyAsUniqueIdentifier(Object[] elements, String expected) {
        CapellaMenusTestCase.assertEquals((String)expected, (String)this.getCopyAsUniqueIdentifier(elements));
    }

    private String getCopyAsUniqueIdentifier(Object ... values) {
        ExecutionEvent event = this.createExecutionEvent(values);
        String result = new CopyUniqueIdentifierHandler().getSelectionAsText(event);
        return result;
    }

    private String getCopyAsText(Object ... values) {
        final ExecutionEvent event = this.createExecutionEvent(values);
        String result = new CopyTextHandler(){

            protected IStructuredSelection getSelection() {
                IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
                return (IStructuredSelection)context.getVariable("selection");
            }
        }.getSelectionAsText();
        return result;
    }

    private ExecutionEvent createExecutionEvent(Object ... elements) {
        EvaluationContext context = new EvaluationContext(null, new Object());
        HashMap parameters = new HashMap();
        ExecutionEvent event = new ExecutionEvent(null, parameters, null, (Object)context);
        context.addVariable("selection", (Object)new StructuredSelection(Arrays.asList(elements)));
        return event;
    }
}

