/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContext;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.IFileRequestor;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.model.ju.model.RenameModel;

public class RenameProjectWithOpenedSessionTestCase
extends RenameModel {
    private boolean isRenamedProject = false;
    private String newProjectName;
    private static final String LIB_IMAGE_PROJECT = "images_library";
    private static final String LOCAL_IMAGE_PATH = "/images/Capella128x128.png";
    private static final String LIB_IMAGE_PATH = "images_library/Capella256x256.png";

    @Override
    public List<String> getRequiredTestModels() {
        if (this.isRenamedProject) {
            return Arrays.asList(this.newProjectName, LIB_IMAGE_PROJECT);
        }
        ArrayList<String> lstProjects = new ArrayList<String>();
        for (String project : super.getRequiredTestModels()) {
            lstProjects.add(project);
        }
        lstProjects.add(LIB_IMAGE_PROJECT);
        return lstProjects;
    }

    public void test() throws Exception {
        String oldProjectName = this.getRequiredTestModels().get(0);
        IFile file = this.getCapellaFileForLoadedModel(oldProjectName);
        if (file.exists()) {
            block9: {
                this.newProjectName = oldProjectName + "_renamed";
                Session sessionBeforeRename = this.getSessionForTestModel(oldProjectName);
                RenameProjectWithOpenedSessionTestCase.assertTrue((String)"Session is not loaded for old project", (sessionBeforeRename != null ? 1 : 0) != 0);
                IProject oldProject = file.getProject();
                RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.rename.resource");
                RenameResourceDescriptor descriptor = (RenameResourceDescriptor)contribution.createDescriptor();
                descriptor.setResourcePath(oldProject.getFullPath());
                descriptor.setNewName(this.newProjectName);
                descriptor.setUpdateReferences(true);
                RefactoringStatus status = new RefactoringStatus();
                RefactoringContext context = descriptor.createRefactoringContext(status);
                try {
                    try {
                        Refactoring refactoring = context != null ? context.getRefactoring() : null;
                        RenameProjectWithOpenedSessionTestCase.assertTrue((boolean)status.isOK());
                        PerformRefactoringOperation op = new PerformRefactoringOperation(refactoring, 6);
                        op.run(null);
                        RefactoringStatus validationStatus = op.getValidationStatus();
                        RenameProjectWithOpenedSessionTestCase.assertFalse((boolean)validationStatus.hasFatalError());
                        RenameProjectWithOpenedSessionTestCase.assertFalse((boolean)validationStatus.hasError());
                    }
                    catch (Exception e) {
                        System.out.println(e.getLocalizedMessage());
                        if (context != null) {
                            context.dispose();
                        }
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    if (context != null) {
                        context.dispose();
                    }
                    throw throwable;
                }
                if (context != null) {
                    context.dispose();
                }
            }
            this.isRenamedProject = true;
            IProject renamedProject = IResourceHelpers.getEclipseProjectInWorkspace((String)this.newProjectName);
            RenameProjectWithOpenedSessionTestCase.assertNotNull((Object)renamedProject);
            RenameProjectWithOpenedSessionTestCase.assertTrue((String)"Renamed project does not exist", (boolean)renamedProject.exists());
            renamedProject.open((IProgressMonitor)new NullProgressMonitor());
            IFile airdFile = (IFile)new IFileRequestor().search((IContainer)renamedProject, "aird").get(0);
            Session sessionAfterRename = SessionManager.INSTANCE.getSession(EcoreUtil2.getURI((IFile)airdFile), (IProgressMonitor)new NullProgressMonitor());
            RenameProjectWithOpenedSessionTestCase.assertTrue((String)"Session is not loaded for new project", (sessionAfterRename != null ? 1 : 0) != 0);
            sessionAfterRename.open((IProgressMonitor)new NullProgressMonitor());
            Project capellaProject = SessionHelper.getCapellaProject((Session)sessionAfterRename);
            capellaProject.getOwnedModelRoots().forEach(root -> {
                if (root instanceof SystemEngineering) {
                    String rootSEDescription = ((SystemEngineering)root).getDescription();
                    RenameProjectWithOpenedSessionTestCase.assertTrue((String)"SystemEngineering element description does not contain new project path", (boolean)rootSEDescription.contains(this.newProjectName + LOCAL_IMAGE_PATH));
                    RenameProjectWithOpenedSessionTestCase.assertTrue((String)"SystemEngineering element description still contain old project path", (!rootSEDescription.contains(oldProjectName + LOCAL_IMAGE_PATH) ? 1 : 0) != 0);
                    RenameProjectWithOpenedSessionTestCase.assertTrue((String)"SystemEngineering element description does not contain lib image path that should not be updated", (boolean)rootSEDescription.contains(LIB_IMAGE_PATH));
                }
            });
            GuiActions.closeSession((Session)sessionAfterRename);
            GuiActions.deleteEclipseProject((IProject)renamedProject);
            IProject libImageProject = IResourceHelpers.getEclipseProjectInWorkspace((String)LIB_IMAGE_PROJECT);
            RenameProjectWithOpenedSessionTestCase.assertTrue((String)"Lib image project is not present", (boolean)libImageProject.exists());
            GuiActions.deleteEclipseProject((IProject)libImageProject);
        }
    }

    protected void tearDown() throws Exception {
    }
}

