/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.testcase.LCDecomposition;

import java.util.List;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionController;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.model.ju.testcase.LCDecomposition.LCDecompositionTestCase;

public class LCDecompositionAttachDetachCommunicationLinkInterface
extends LCDecompositionTestCase {
    public static String LCDECOMPOSITION__LA__LOGICAL_COMPONENT_1 = "6d9c518e-0510-4d0d-8568-fdc7a3aa46ea";

    @Override
    public void test() {
        CapellaModel model = this.getTestModel(MODEL_NAME);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        LogicalComponent logicalSystem = (LogicalComponent)IdManager.getInstance().getEObject(LCDECOMPOSITION__LA__LOGICAL_SYSTEM, (IScope)scope);
        LogicalComponent lc1 = (LogicalComponent)IdManager.getInstance().getEObject(LCDECOMPOSITION__LA__LOGICAL_COMPONENT_1, (IScope)scope);
        LCDecompositionController controller = new LCDecompositionController();
        DecompositionModel decompositionModel = controller.createDecompositionModel(logicalSystem);
        DecompositionComponent sourceComponent = decompositionModel.getSourceComponent();
        Decomposition decomposition = (Decomposition)decompositionModel.getDecompositions().get(0);
        List targetComponents = decomposition.getTargetComponents();
        List items = ((DecompositionComponent)targetComponents.get(0)).getItems();
        this.checkDetachingItems(decompositionModel, sourceComponent, targetComponents, items);
        this.checkAttachingItems(decompositionModel, sourceComponent, targetComponents, items);
        this.checkRemoveTargetComponent(logicalSystem, lc1, decompositionModel, targetComponents);
    }

    private void checkRemoveTargetComponent(LogicalComponent logicalSystem, LogicalComponent lc1, DecompositionModel decompositionModel, List<DecompositionComponent> targetComponents) {
        int targetComponentsSize = targetComponents.size();
        LCDecompositionAttachDetachCommunicationLinkInterface.assertTrue((boolean)logicalSystem.getOwnedLogicalComponents().contains((Object)lc1));
        decompositionModel.removeTargetComponent((Decomposition)decompositionModel.getDecompositions().get(0), targetComponents.get(0));
        LCDecompositionAttachDetachCommunicationLinkInterface.assertTrue((boolean)decompositionModel.finishDecomposition());
        LCDecompositionAttachDetachCommunicationLinkInterface.assertEquals((int)(targetComponentsSize - 1), (int)targetComponents.size());
        LCDecompositionAttachDetachCommunicationLinkInterface.assertFalse((boolean)logicalSystem.getOwnedLogicalComponents().contains((Object)lc1));
    }

    private void checkAttachingItems(DecompositionModel decompositionModel, DecompositionComponent sourceComponent, List<DecompositionComponent> targetComponents, List<DecompositionItem> items) {
        sourceComponent.getItems().stream().forEach(item -> {
            boolean bl = decompositionModel.attachInterface((DecompositionComponent)targetComponents.get(0), item);
        });
        LCDecompositionAttachDetachCommunicationLinkInterface.assertTrue((boolean)decompositionModel.finishDecomposition());
        LCDecompositionAttachDetachCommunicationLinkInterface.assertFalse((boolean)items.isEmpty());
        sourceComponent.getItems().stream().forEach(item -> LCDecompositionAttachDetachCommunicationLinkInterface.assertEquals((int)1, (int)item.getStatus()));
        LCDecompositionAttachDetachCommunicationLinkInterface.assertFalse((boolean)((Component)targetComponents.get(0).getValue()).getUsedInterfaces().isEmpty());
        LCDecompositionAttachDetachCommunicationLinkInterface.assertFalse((boolean)((Component)targetComponents.get(0).getValue()).getOwnedCommunicationLinks().isEmpty());
    }

    private void checkDetachingItems(DecompositionModel decompositionModel, DecompositionComponent sourceComponent, List<DecompositionComponent> targetComponents, List<DecompositionItem> items) {
        LCDecompositionAttachDetachCommunicationLinkInterface.assertFalse((boolean)items.isEmpty());
        sourceComponent.getItems().stream().forEach(item -> {
            boolean bl = decompositionModel.detachInterface((DecompositionComponent)targetComponents.get(0), item);
        });
        LCDecompositionAttachDetachCommunicationLinkInterface.assertTrue((boolean)decompositionModel.finishDecomposition());
        LCDecompositionAttachDetachCommunicationLinkInterface.assertTrue((boolean)items.isEmpty());
        sourceComponent.getItems().stream().forEach(item -> LCDecompositionAttachDetachCommunicationLinkInterface.assertEquals((int)2, (int)item.getStatus()));
        LCDecompositionAttachDetachCommunicationLinkInterface.assertTrue((boolean)((Component)targetComponents.get(0).getValue()).getUsedInterfaces().isEmpty());
        LCDecompositionAttachDetachCommunicationLinkInterface.assertTrue((boolean)((Component)targetComponents.get(0).getValue()).getOwnedCommunicationLinks().isEmpty());
    }
}

