/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.testcases.intermodelInconsistencies;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.test.model.ju.CheckInterModelInconsistencyDetectionTestCase;

public class CheckDependencyViolationOneLevel
extends CheckInterModelInconsistencyDetectionTestCase {
    public List<String> getRequiredTestModels() {
        return Arrays.asList("intermodelInconsistencies/PROJECT", "intermodelInconsistencies/LIB");
    }

    public void test() throws Exception {
        CapellaModel modelA = this.getTestModel("intermodelInconsistencies/PROJECT");
        Project projectA = modelA.getProject(modelA.getEditingDomain());
        SystemEngineering systemA = this.getSystemEngineering(projectA);
        LogicalArchitecture logArchA = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemA);
        final DataPkg dataPckA = logArchA.getOwnedDataPkg();
        final Class class4 = this.getClassNamed("Class 4", dataPckA);
        final Class class5 = this.getClassNamed("Class 5", dataPckA);
        CapellaModel modelB = this.getTestModel("intermodelInconsistencies/LIB");
        Project projectB = modelB.getProject(modelA.getEditingDomain());
        SystemEngineering systemB = this.getSystemEngineering(projectB);
        LogicalArchitecture logArchB = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemB);
        final DataPkg dataPckB = logArchB.getOwnedDataPkg();
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                dataPckB.getOwnedClasses().add((Object)class4);
            }
        };
        TransactionHelper.getExecutionManager((EObject)projectA).execute((ICommand)command);
        CheckDependencyViolationOneLevel.assertFalse((boolean)command.isRolledBack());
        command = new AbstractReadWriteCommand(){

            public void run() {
                dataPckA.getOwnedClasses().add((Object)class4);
            }
        };
        TransactionHelper.getExecutionManager((EObject)projectA).execute((ICommand)command);
        CheckDependencyViolationOneLevel.assertFalse((boolean)command.isRolledBack());
        command = new AbstractReadWriteCommand(){

            public void run() {
                dataPckB.getOwnedClasses().add((Object)class5);
            }
        };
        TransactionHelper.getExecutionManager((EObject)projectA).execute((ICommand)command);
        CheckDependencyViolationOneLevel.assertTrue((boolean)command.isRolledBack());
    }
}

