/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.recrpl.ju.testcases;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.RecCatalog;
import org.polarsys.capella.common.re.helpers.ReplicableElementExt;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.test.recrpl.ju.model.Re;

public class CompositeREC
extends Re {
    public void moveFunction(final String element, final String newContainer) throws Exception {
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.getProject()));
        manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                ((LogicalFunction)CompositeREC.this.getObject(newContainer)).getOwnedFunctions().add((Object)((LogicalFunction)CompositeREC.this.getObject(element)));
            }
        });
    }

    public LogicalFunction createFunction(final String element, final String newContainer) throws Exception {
        final LogicalFunction[] result = new LogicalFunction[1];
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.getProject()));
        manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                LogicalFunction lf = LaFactory.eINSTANCE.createLogicalFunction(element);
                ((LogicalFunction)CompositeREC.this.getObject(newContainer)).getOwnedFunctions().add((Object)lf);
                result[0] = lf;
            }
        });
        return result[0];
    }

    @Override
    public void performTest() throws Exception {
        CatalogElement REC1 = this.createREC(this.getObjects(LF1));
        CatalogElement REC2 = this.createREC(this.getObjects(LF2));
        this.moveFunction(LF2, LF1);
        this.updateCur(Collections.singletonList(REC2), REC1);
        RecCatalog catalog = (RecCatalog)REC1.eContainer();
        CatalogElement RPL1 = this.createReplica(Arrays.asList(catalog, this.getObject(LF3)), REC1);
        CatalogElement RPL_REC2 = (CatalogElement)ReplicableElementExt.getReferencingElement((CatalogElement)RPL1, (EObject)REC2);
        this.updateReplica(Arrays.asList(RPL_REC2), RPL_REC2);
        EObject RPL_LF1 = ReplicableElementExt.getReferencingElement((CatalogElement)RPL1, (EObject)this.getObject(LF1));
        EObject RPL_LF2 = ReplicableElementExt.getReferencingElement((CatalogElement)RPL_REC2, (EObject)this.getObject(LF2));
        CompositeREC.assertTrue((String)"RPL of LF2 shall be contained into RPL of LF1", (RPL_LF2.eContainer() == RPL_LF1 ? 1 : 0) != 0);
        LogicalFunction lf21 = this.createFunction("LF21", ROOT_LF);
        LogicalFunction lf22 = this.createFunction("LF22", LF1);
        this.updateCur(Arrays.asList(lf21, lf22), REC2);
        this.updateReplica(Arrays.asList(RPL_REC2), RPL_REC2);
        EObject RPL_LF21 = ReplicableElementExt.getReferencingElement((CatalogElement)RPL_REC2, (EObject)lf21);
        CompositeREC.assertTrue((String)"RPL of LF21 shall be contained into root LF", (RPL_LF21.eContainer() == this.getObject(ROOT_LF) ? 1 : 0) != 0);
        EObject RPL_LF22 = ReplicableElementExt.getReferencingElement((CatalogElement)RPL_REC2, (EObject)lf22);
        CompositeREC.assertTrue((String)"RPL of LF22 shall be contained into RPL of LF1", (RPL_LF22.eContainer() == RPL_LF1 ? 1 : 0) != 0);
        System.out.println(0);
    }
}

