/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.recrpl.ju.testcases;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.RePackage;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.test.recrpl.ju.RecRplCommandManager;
import org.polarsys.capella.test.recrpl.ju.RecRplTestCase;

public abstract class CreateRPL_SpecificPackages
extends RecRplTestCase {
    final Map<EClass, EClass> test = ImmutableMap.builder().put((Object)OaPackage.Literals.OPERATIONAL_ACTIVITY, (Object)OaPackage.Literals.OPERATIONAL_ACTIVITY_PKG).put((Object)OaPackage.Literals.OPERATIONAL_ACTIVITY_PKG, (Object)OaPackage.Literals.OPERATIONAL_ACTIVITY_PKG).put((Object)OaPackage.Literals.ENTITY, (Object)OaPackage.Literals.ENTITY_PKG).put((Object)OaPackage.Literals.ENTITY_PKG, (Object)OaPackage.Literals.ENTITY_PKG).put((Object)OaPackage.Literals.OPERATIONAL_CAPABILITY, (Object)OaPackage.Literals.OPERATIONAL_CAPABILITY_PKG).put((Object)OaPackage.Literals.OPERATIONAL_CAPABILITY_PKG, (Object)OaPackage.Literals.OPERATIONAL_CAPABILITY_PKG).put((Object)OaPackage.Literals.ROLE, (Object)OaPackage.Literals.ROLE_PKG).put((Object)OaPackage.Literals.ROLE_PKG, (Object)OaPackage.Literals.ROLE_PKG).put((Object)CtxPackage.Literals.SYSTEM_FUNCTION, (Object)CtxPackage.Literals.SYSTEM_FUNCTION_PKG).put((Object)CtxPackage.Literals.SYSTEM_COMPONENT, (Object)CtxPackage.Literals.SYSTEM_COMPONENT_PKG).put((Object)CtxPackage.Literals.SYSTEM_COMPONENT_PKG, (Object)CtxPackage.Literals.SYSTEM_COMPONENT_PKG).put((Object)CtxPackage.Literals.SYSTEM_FUNCTION_PKG, (Object)CtxPackage.Literals.SYSTEM_FUNCTION_PKG).put((Object)CtxPackage.Literals.MISSION, (Object)CtxPackage.Literals.MISSION_PKG).put((Object)CtxPackage.Literals.MISSION_PKG, (Object)CtxPackage.Literals.MISSION_PKG).put((Object)CtxPackage.Literals.CAPABILITY, (Object)CtxPackage.Literals.CAPABILITY_PKG).put((Object)CtxPackage.Literals.CAPABILITY_PKG, (Object)CtxPackage.Literals.CAPABILITY_PKG).put((Object)LaPackage.Literals.LOGICAL_FUNCTION, (Object)LaPackage.Literals.LOGICAL_FUNCTION_PKG).put((Object)LaPackage.Literals.LOGICAL_FUNCTION_PKG, (Object)LaPackage.Literals.LOGICAL_FUNCTION_PKG).put((Object)LaPackage.Literals.LOGICAL_COMPONENT, (Object)LaPackage.Literals.LOGICAL_COMPONENT_PKG).put((Object)LaPackage.Literals.LOGICAL_COMPONENT_PKG, (Object)LaPackage.Literals.LOGICAL_COMPONENT_PKG).put((Object)LaPackage.Literals.CAPABILITY_REALIZATION, (Object)LaPackage.Literals.CAPABILITY_REALIZATION_PKG).put((Object)LaPackage.Literals.CAPABILITY_REALIZATION_PKG, (Object)LaPackage.Literals.CAPABILITY_REALIZATION_PKG).put((Object)PaPackage.Literals.PHYSICAL_FUNCTION, (Object)PaPackage.Literals.PHYSICAL_FUNCTION_PKG).put((Object)PaPackage.Literals.PHYSICAL_FUNCTION_PKG, (Object)PaPackage.Literals.PHYSICAL_FUNCTION_PKG).put((Object)PaPackage.Literals.PHYSICAL_COMPONENT, (Object)PaPackage.Literals.PHYSICAL_COMPONENT_PKG).put((Object)PaPackage.Literals.PHYSICAL_COMPONENT_PKG, (Object)PaPackage.Literals.PHYSICAL_COMPONENT_PKG).put((Object)CsPackage.Literals.INTERFACE_PKG, (Object)CsPackage.Literals.INTERFACE_PKG).put((Object)CsPackage.Literals.INTERFACE, (Object)CsPackage.Literals.INTERFACE_PKG).put((Object)CapellacommonPackage.Literals.CHANGE_EVENT, (Object)InformationPackage.Literals.DATA_PKG).put((Object)CapellacommonPackage.Literals.TIME_EVENT, (Object)InformationPackage.Literals.DATA_PKG).build();
    CapellaModelSkeleton project;
    private ExecutionManager manager;
    Resource resource;

    public void setUp() throws Exception {
        super.setUp();
        InstanceScope.INSTANCE.getNode("org.polarsys.capella.common.re").put("parentLocatorOption", "packageLocator");
        this.manager = ExecutionManagerRegistry.getInstance().addNewManager();
        this.project = new CapellaModelSkeleton.Builder(this.manager).build();
        this.resource = this.project.getProject().eResource();
    }

    @Override
    protected Resource getModelResource() {
        return this.resource;
    }

    public void tearDown() throws Exception {
        ExecutionManagerRegistry.getInstance().removeManager(this.manager);
        InstanceScope.INSTANCE.getNode("org.polarsys.capella.common.re").put("parentLocatorOption", "defaultLocator");
        super.tearDown();
    }

    @Override
    public void test() throws Exception {
        CatalogElement rec = this.createREC(this.getRecElements(this.project));
        RecRplCommandManager.push("targetName", "specificPkgRPL");
        CatalogElement rpl = this.createReplica(Collections.singleton(this.project.getSystemEngineering()), rec);
        this.verify(rpl);
    }

    protected abstract Collection<EObject> getRecElements(CapellaModelSkeleton var1);

    protected void verify(CatalogElement replica) {
        HashMap<AbstractMap.SimpleImmutableEntry<EClass, EClass>, EObject> packages = new HashMap<AbstractMap.SimpleImmutableEntry<EClass, EClass>, EObject>();
        for (CatalogElementLink link : replica.getOwnedLinks()) {
            EObject target = link.getTarget();
            EClass expectedContainerClass = this.getExpectedContainerClass(target);
            if (expectedContainerClass != null) {
                EObject targetContainer = target.eContainer();
                if (!EObjectExt.getReferencers((EObject)targetContainer, (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET).isEmpty()) continue;
                CreateRPL_SpecificPackages.assertTrue((targetContainer.eClass() == expectedContainerClass ? 1 : 0) != 0);
                BlockArchitecture originBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)link.getOrigin().getTarget());
                BlockArchitecture targetBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
                CreateRPL_SpecificPackages.assertSame((Object)originBlock, (Object)targetBlock);
                AbstractMap.SimpleImmutableEntry<EClass, EClass> key = new AbstractMap.SimpleImmutableEntry<EClass, EClass>(targetBlock.eClass(), targetContainer.eClass());
                EObject previous = packages.put(key, targetContainer);
                if (previous != null && !(previous instanceof ComponentPkg)) {
                    CreateRPL_SpecificPackages.assertSame((Object)targetContainer, (Object)previous);
                }
                CreateRPL_SpecificPackages.assertSame((Object)this.getExpectedPackageContainer(targetBlock, targetContainer.eClass(), target), (Object)targetContainer.eContainer());
                continue;
            }
            CreateRPL_SpecificPackages.fail((String)("No package mapping provided for " + String.valueOf(target)));
        }
    }

    protected EClass getExpectedContainerClass(EObject target) {
        if (target instanceof ExchangeItem) {
            return this.getExpectedContainerClass(target.eContainer());
        }
        if (target instanceof Part) {
            return this.getExpectedContainerClass((EObject)((Part)target).getAbstractType());
        }
        if (target instanceof PhysicalLink) {
            return this.getExpectedContainerClass(target.eContainer());
        }
        if (target instanceof ComponentExchange) {
            return this.getExpectedContainerClass(target.eContainer());
        }
        EClass result = this.test.get(target.eClass());
        if (result == null && (target.eClass().getEPackage() == InformationPackage.eINSTANCE || target.eClass().getEPackage().getESuperPackage() == InformationPackage.eINSTANCE)) {
            result = InformationPackage.Literals.DATA_PKG;
        }
        return result;
    }

    protected EObject getExpectedPackageContainer(BlockArchitecture arch, EClass packageClass, EObject target) {
        if (packageClass == OaPackage.Literals.OPERATIONAL_ACTIVITY_PKG) {
            OperationalActivityPkg pkg = (OperationalActivityPkg)((OperationalAnalysis)arch).getOwnedFunctionPkg();
            return (EObject)pkg.getOwnedOperationalActivities().get(0);
        }
        if (packageClass == OaPackage.Literals.ENTITY_PKG) {
            return ((OperationalAnalysis)arch).getOwnedEntityPkg();
        }
        if (packageClass == OaPackage.Literals.OPERATIONAL_CAPABILITY_PKG) {
            return arch.getOwnedAbstractCapabilityPkg();
        }
        if (packageClass == OaPackage.Literals.ROLE_PKG) {
            return ((OperationalAnalysis)arch).getOwnedRolePkg();
        }
        if (packageClass == CtxPackage.Literals.SYSTEM_FUNCTION_PKG) {
            SystemFunctionPkg pkg = (SystemFunctionPkg)((SystemAnalysis)arch).getOwnedFunctionPkg();
            return (EObject)pkg.getOwnedSystemFunctions().get(0);
        }
        if (packageClass == CtxPackage.Literals.SYSTEM_COMPONENT_PKG) {
            Component root = ComponentExt.getRootComponent((EObject)target);
            if (root != null && BlockArchitectureExt.isRootComponent((Component)root)) {
                return ((SystemAnalysis)arch).getSystem();
            }
            return ((SystemAnalysis)arch).getOwnedSystemComponentPkg();
        }
        if (packageClass == CtxPackage.Literals.MISSION_PKG) {
            return ((SystemAnalysis)arch).getOwnedMissionPkg();
        }
        if (packageClass == CtxPackage.Literals.CAPABILITY_PKG) {
            return ((SystemAnalysis)arch).getOwnedAbstractCapabilityPkg();
        }
        if (packageClass == LaPackage.Literals.LOGICAL_FUNCTION_PKG) {
            LogicalFunctionPkg pkg = (LogicalFunctionPkg)((LogicalArchitecture)arch).getOwnedFunctionPkg();
            return (EObject)pkg.getOwnedLogicalFunctions().get(0);
        }
        if (packageClass == LaPackage.Literals.LOGICAL_COMPONENT_PKG) {
            Component root = ComponentExt.getRootComponent((EObject)target);
            if (root != null && BlockArchitectureExt.isRootComponent((Component)root)) {
                return ((LogicalArchitecture)arch).getSystem();
            }
            return ((LogicalArchitecture)arch).getOwnedLogicalComponentPkg();
        }
        if (packageClass == LaPackage.Literals.CAPABILITY_REALIZATION_PKG) {
            return arch.getOwnedAbstractCapabilityPkg();
        }
        if (packageClass == PaPackage.Literals.PHYSICAL_FUNCTION_PKG) {
            PhysicalFunctionPkg pkg = (PhysicalFunctionPkg)((PhysicalArchitecture)arch).getOwnedFunctionPkg();
            return (EObject)pkg.getOwnedPhysicalFunctions().get(0);
        }
        if (packageClass == PaPackage.Literals.PHYSICAL_COMPONENT_PKG) {
            Component root = ComponentExt.getRootComponent((EObject)target);
            if (root != null && BlockArchitectureExt.isRootComponent((Component)root)) {
                return ((PhysicalArchitecture)arch).getSystem();
            }
            return ((PhysicalArchitecture)arch).getOwnedPhysicalComponentPkg();
        }
        if (packageClass == CsPackage.Literals.INTERFACE_PKG) {
            return arch.getOwnedInterfacePkg();
        }
        if (packageClass == InformationPackage.Literals.DATA_PKG) {
            return arch.getOwnedDataPkg();
        }
        CreateRPL_SpecificPackages.fail((String)"Unexpected package class");
        return null;
    }
}

