/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.recrpl.ju.testcases;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.re.handlers.scope.DependenciesHandlerHelper;
import org.polarsys.capella.common.re.handlers.scope.IDependenciesHandler;
import org.polarsys.capella.core.data.capellamodeller.Library;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.core.re.project.diffmerge.SkeletonUtil;
import org.polarsys.capella.core.re.project.handlers.ProjectRecHandler;
import org.polarsys.capella.core.transition.common.handlers.activity.IActivityExtender;
import org.polarsys.capella.core.transition.common.handlers.options.DefaultOptionsHandler;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.test.recrpl.ju.RecRplCommandManager;
import org.polarsys.capella.test.recrpl.ju.RecRplTestCase;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DependenciesOnSkeleton
extends RecRplTestCase {
    public static final String INTERFACE_1 = "35d038a6-cc7e-4c37-8ae9-e8f203454ab6";
    public static final String C_1 = "f5b55163-882a-4692-a814-978066c11390";
    public static final String PL_1 = "72d1855c-543a-432a-a264-2c9b3f9ac6d6";
    public static final String CP_1 = "814727d2-d029-4dc5-ad55-50eaf6d50b74";
    public static final String PP_2 = "6c7d337a-f2e1-4cb1-ae6e-a36f49487342";
    public static final String INTERFACE_IMPLEMENTATION_TO_INTERFACE_1 = "96aadd8a-1d60-43ac-b45f-a7ede6194421";
    public static final String SA_2 = "602d64ce-733c-41ea-bb0c-b67f59cb06c6";
    public static final String ROOT_SYSTEM_FUNCTION = "f27404de-6eb6-4834-98d1-20f4dcb1460d";
    public static final String STRUCTURE = "d78f2b5e-a7f4-4792-beb8-dbbbe1d333e9";
    public static final String SYSTEM = "f2b387ab-4aa7-42d3-9f40-7bb3c77d7704";
    public static final String ACP_1 = "d27163b0-31f0-48e8-a847-737e82beacf3";
    public static final String APP_2 = "44d90b06-9115-49ea-8451-982b474fac3e";

    public List<String> getRequiredTestModels() {
        return Arrays.asList("dependencies");
    }

    @Override
    public void test() throws Exception {
        this.ttTestProjectScope();
        this.ttSkeletonHelper();
        this.ttDependencies();
    }

    public void ttSkeletonHelper() {
        SkeletonUtil util = new SkeletonUtil(this.getObject(INTERFACE_1));
        Collection roots = util.getSkeletonElements();
        DependenciesOnSkeleton.assertTrue((!roots.contains(this.getObject(INTERFACE_1)) ? 1 : 0) != 0);
        DependenciesOnSkeleton.assertTrue((!roots.contains(this.getObject(C_1)) ? 1 : 0) != 0);
        DependenciesOnSkeleton.assertTrue((!roots.contains(this.getObject(SA_2)) ? 1 : 0) != 0);
        DependenciesOnSkeleton.assertTrue((!roots.contains(this.getObject(APP_2)) ? 1 : 0) != 0);
        DependenciesOnSkeleton.assertTrue((boolean)roots.contains(this.getObject(SYSTEM)));
        DependenciesOnSkeleton.assertTrue((boolean)roots.contains(this.getObject(STRUCTURE)));
        DependenciesOnSkeleton.assertTrue((boolean)roots.contains(this.getObject(ROOT_SYSTEM_FUNCTION)));
    }

    public void ttTestProjectScope() {
        RecRplCommandManager.setChecker(new IActivityExtender(){

            public IStatus postActivity(IContext context, String activityIdentifier, ActivityParameters activityParams) {
                if ("initializeTransition".equals(activityIdentifier)) {
                    DependenciesOnSkeleton.assertTrue((boolean)ProjectRecHandler.isProjectCommand((IContext)context));
                }
                return Status.OK_STATUS;
            }

            public IStatus init(IContext context) {
                return Status.OK_STATUS;
            }

            public IStatus dispose(IContext context) {
                return Status.OK_STATUS;
            }

            public IStatus preActivity(IContext context, String activityIdentifier, ActivityParameters activityParams) {
                return Status.OK_STATUS;
            }
        });
        Library library = (Library)ProjectExt.getProject((EObject)this.getObject(SYSTEM));
        this.createRECWholeContent(library);
        RecRplCommandManager.setChecker(new IActivityExtender(){

            public IStatus postActivity(IContext context, String activityIdentifier, ActivityParameters activityParams) {
                if ("initializeTransition".equals(activityIdentifier)) {
                    DependenciesOnSkeleton.assertFalse((boolean)ProjectRecHandler.isProjectCommand((IContext)context));
                }
                return Status.OK_STATUS;
            }

            public IStatus init(IContext context) {
                return Status.OK_STATUS;
            }

            public IStatus dispose(IContext context) {
                return Status.OK_STATUS;
            }

            public IStatus preActivity(IContext context, String activityIdentifier, ActivityParameters activityParams) {
                return Status.OK_STATUS;
            }
        });
        this.createREC(this.getObjects(SYSTEM));
    }

    public void ttDependencies() {
        RecRplCommandManager.setChecker(new IActivityExtender(){

            public IStatus postActivity(IContext context, String activityIdentifier, ActivityParameters activityParams) {
                if ("initializeTransition".equals(activityIdentifier)) {
                    DependenciesOnSkeleton.this.mustNotDepends(DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.C_1), DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.SYSTEM), context);
                    DependenciesOnSkeleton.this.mustNotDepends(DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.CP_1), DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.SYSTEM), context);
                    DependenciesOnSkeleton.this.mustNotDepends(DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.PL_1), DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.SYSTEM), context);
                    DependenciesOnSkeleton.this.mustNotDepends(DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.PP_2), DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.SYSTEM), context);
                    DependenciesOnSkeleton.this.mustNotDepends(DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.INTERFACE_IMPLEMENTATION_TO_INTERFACE_1), DependenciesOnSkeleton.this.getObject(DependenciesOnSkeleton.SYSTEM), context);
                }
                return Status.OK_STATUS;
            }

            public IStatus init(IContext context) {
                return Status.OK_STATUS;
            }

            public IStatus dispose(IContext context) {
                return Status.OK_STATUS;
            }

            public IStatus preActivity(IContext context, String activityIdentifier, ActivityParameters activityParams) {
                return Status.OK_STATUS;
            }
        });
        Library library = (Library)ProjectExt.getProject((EObject)this.getObject(SYSTEM));
        this.createRECWholeContent(library);
    }

    protected void mustNotDepends(EObject source, EObject notReferenced, IContext context) {
        IPropertyContext propertyContext = ((DefaultOptionsHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, (String)context.get((Object)"_OS"));
        Collection scopeElements = (Collection)propertyContext.getCurrentValue(propertyContext.getProperties().getProperty("source.scopeElements"));
        IDependenciesHandler dp = DependenciesHandlerHelper.getInstance((IContext)context);
        DependenciesOnSkeleton.assertTrue((!dp.getDependencies(Arrays.asList(source), scopeElements, context).contains(notReferenced) ? 1 : 0) != 0);
    }
}

