/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.recrpl.ju.testcases;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.test.recrpl.ju.RecRplCommandManager;
import org.polarsys.capella.test.recrpl.ju.RecRplTestCase;

public class Location_FPCPPP
extends RecRplTestCase {
    public static final String FIP_1 = "d28af7d2-df78-49d2-bb3d-9804fd4964b9";
    public static final String FOP_1 = "c2740663-908c-4eb6-9a14-2a40a2b85774";
    public static final String SCP_1 = "c4fea7b2-ea55-4455-9ca6-f9e20d124b2b";
    public static final String SPP_2 = "38162b6e-1624-4909-9e8f-1c0fc5a7b117";
    public static final String ACP_1 = "97c364f1-2ef5-4d4d-8c9c-c646fc20c3eb";
    public static final String APP_2 = "8947d032-e3ff-42cd-ab57-a3a5c84f8a83";

    public List<String> getRequiredTestModels() {
        return Arrays.asList("lib-fecepl");
    }

    @Override
    public void test() throws Exception {
        CatalogElement rec = this.createREC(this.getObjects(FIP_1, FOP_1, SCP_1, SPP_2, ACP_1, APP_2));
        RecRplCommandManager.push("targetName", "specificPkgRPL");
        CapellaModelSkeleton project = new CapellaModelSkeleton.Builder(TransactionHelper.getExecutionManager((EObject)rec)).build();
        CatalogElement rpl = this.createPartialReplica(Collections.singleton(project.getSystemEngineering()), null, rec);
        this.mustReplicate(rpl, this.getObject(SCP_1));
        this.mustReplicate(rpl, this.getObject(SPP_2));
        this.mustNotReplicate(rpl, this.getObject(ACP_1));
        this.mustNotReplicate(rpl, this.getObject(APP_2));
        for (CatalogElementLink link : rpl.getOwnedLinks()) {
            EObject target = link.getTarget();
            EObject origin = link.getOrigin().getTarget();
            if (!(origin instanceof ComponentPort) && !(origin instanceof PhysicalPort)) continue;
            BlockArchitecture architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            Location_FPCPPP.assertTrue((boolean)target.eContainer().equals(BlockArchitectureExt.getFirstComponent((BlockArchitecture)architectureTarget, (boolean)false)));
        }
    }
}

