/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.recrpl.ju.testcases.compliance;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.helpers.ReplicableElementExt;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.test.recrpl.ju.model.Compliance;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class BlackboxComplianceTest2
extends Compliance {
    private PhysicalArchitecture pa;
    private CatalogElement rec;
    private CatalogElement rpl1;
    private PhysicalFunction rootPf;
    private PhysicalFunction pfRec1;
    private PhysicalFunction pfRec2;
    private PhysicalFunction pfRpl1;
    private PhysicalFunction pfRpl2;

    @Override
    public void test() throws Exception {
        SystemEngineering se = SystemEngineeringExt.getSystemEngineering((Project)this.getProject());
        this.pa = SystemEngineeringExt.getPhysicalArchitecture((SystemEngineering)se);
        this.rootPf = (PhysicalFunction)BlockArchitectureExt.getRootFunction((BlockArchitecture)this.pa);
        this.executeCommand(() -> {
            this.pfRec1 = PaFactory.eINSTANCE.createPhysicalFunction("pf1");
            this.pfRec2 = PaFactory.eINSTANCE.createPhysicalFunction("pf2");
            this.rootPf.getOwnedFunctions().add((Object)this.pfRec1);
            this.rootPf.getOwnedFunctions().add((Object)this.pfRec2);
        });
        this.rec = this.createREC(Arrays.asList(this.pfRec1, this.pfRec2));
        this.rpl1 = this.createReplica(Collections.singleton(this.pfRec1), this.rec, "SUFFIX");
        for (CatalogElementLink link : this.rpl1.getOwnedLinks()) {
            if (link.getOrigin().getTarget() == this.pfRec1) {
                this.pfRpl1 = (PhysicalFunction)link.getTarget();
            }
            if (link.getOrigin().getTarget() != this.pfRec2) continue;
            this.pfRpl2 = (PhysicalFunction)link.getTarget();
        }
        BlackboxComplianceTest2.assertNotNull((Object)this.pfRpl1);
        BlackboxComplianceTest2.assertNotNull((Object)this.pfRpl2);
        this.expectNoRollback(() -> {
            boolean bl = this.rootPf.getOwnedFunctions().addAll(Arrays.asList(this.pfRpl1, this.pfRpl2));
        });
        this.expectNoRollback(() -> this.rpl1.setReadOnly(true));
        new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)this.pfRpl1), Collections.singleton(this.pfRpl1), true, false, false).execute();
        BlackboxComplianceTest2.assertTrue((this.pfRpl1.eContainer() == this.rootPf ? 1 : 0) != 0);
        new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)this.pfRpl1), Arrays.asList(this.pfRpl1, (ExtensibleElement)ReplicableElementExt.getReferencingLinks((EObject)this.pfRpl1).iterator().next()), true, false, false).execute();
        BlackboxComplianceTest2.assertTrue((this.pfRpl1.eContainer() == this.rootPf ? 1 : 0) != 0);
        this.expectRollback(() -> {
            boolean bl = this.pfRpl1.getOwnedFunctions().add((Object)this.pfRpl2);
        });
        this.expectNoRollback(() -> {
            this.pfRpl1.getOwnedFunctions().add((Object)this.pfRpl2);
            this.pfRec1.getOwnedFunctions().add((Object)this.pfRec2);
        });
        this.expectRollback(() -> {
            boolean bl = this.rootPf.getOwnedFunctions().add((Object)this.pfRpl2);
        });
        this.expectNoRollback(() -> {
            boolean bl = this.rootPf.getOwnedFunctions().add((Object)this.pfRec2);
        });
        this.expectNoRollback(() -> {
            boolean bl = this.rootPf.getOwnedFunctions().add((Object)this.pfRpl2);
        });
        new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)this.pfRec1), Collections.singleton(this.pfRec1), true, false, false).execute();
        BlackboxComplianceTest2.assertTrue((this.pfRec1.eResource() == null ? 1 : 0) != 0);
        this.updateCur(Collections.singleton(this.pfRec2), this.rec);
        this.updateReplica(Collections.singleton(this.pfRpl2), this.rpl1);
        BlackboxComplianceTest2.assertTrue((this.pfRpl1.eResource() == null ? 1 : 0) != 0);
    }
}

