/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.richtext.ju.testcases;

import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableCrossEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.platform.sirius.ui.services.SiriusSelectorInPackageExplorer;
import org.polarsys.capella.core.ui.properties.richtext.navigation.CapellaNavigationModelElement;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.GuiHelper;

public class RichtextOpenLinkTest
extends BasicTestCase {
    public static String ROOT_SF = "8aec9c74-487d-4d8d-8ea2-5f733b69f23f";
    public static String SDFB = "_la3j4DNYEeieBf4kJpEPiQ";
    public static String TABLE = "_0URZYDNeEeieBf4kJpEPiQ";

    public List<String> getRequiredTestModels() {
        return Arrays.asList("RichtextTestModel");
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel("RichtextTestModel");
        RichtextOpenLinkTest.assertNotNull((Object)model);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        SystemFunction rootSF = (SystemFunction)IdManager.getInstance().getEObject(ROOT_SF, (IScope)scope);
        RichtextOpenLinkTest.assertNotNull((Object)rootSF);
        new SiriusSelectorInPackageExplorer();
        CapellaNavigationModelElement openLinkStrategy = new CapellaNavigationModelElement();
        openLinkStrategy.openLink((Object)rootSF, ROOT_SF);
        GuiActions.flushASyncGuiThread();
        IStructuredSelection currentSelection = GuiHelper.getCurrentSelectionInProjectExplorer();
        RichtextOpenLinkTest.assertNotNull((Object)currentSelection);
        RichtextOpenLinkTest.assertNotNull((Object)currentSelection.getFirstElement());
        RichtextOpenLinkTest.assertTrue((String)"Root System Function is not selected after the link is selected", (boolean)currentSelection.getFirstElement().equals(rootSF));
        openLinkStrategy.openLink((Object)rootSF, SDFB);
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor != null && activeEditor instanceof SiriusDiagramEditor) {
            SiriusDiagramEditor diagramEditor = (SiriusDiagramEditor)activeEditor;
            DRepresentation diagram = (DRepresentation)diagramEditor.getDiagram().getElement();
            RichtextOpenLinkTest.assertTrue((String)"Uid is not taken into account in open diagram link", (boolean)diagram.getUid().equals(SDFB));
            diagramEditor.close(false);
        } else {
            RichtextOpenLinkTest.fail((String)"No diagram is opened");
        }
        openLinkStrategy.openLink((Object)rootSF, TABLE);
        activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor != null && activeEditor instanceof DTableCrossEditor) {
            DTableCrossEditor tableEditor = (DTableCrossEditor)activeEditor;
            DRepresentation table = tableEditor.getRepresentation();
            RichtextOpenLinkTest.assertTrue((String)"Uid is not taken into account in open table link", (boolean)table.getUid().equals(TABLE));
        } else {
            RichtextOpenLinkTest.fail((String)"No table is opened");
        }
    }

    public static Test suite() {
        return new RichtextOpenLinkTest();
    }
}

