/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.run;

import org.apache.commons.lang.StringEscapeUtils;
import org.polarsys.capella.test.run.TestSuiteElement;

public class TestElement {
    private static final double ONE_SECOND = 1000.0;
    public boolean isRoot = true;
    public String id;
    public String name;
    public boolean failed = false;
    public String failureMessage = "";
    public String stack = "";
    public TestSuiteElement parent;
    public String status = "OK";
    public long timeStart;
    public long timeEnd;

    public TestElement(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public double getEllapsedTime() {
        return (double)(this.timeEnd - this.timeStart) / 1000.0;
    }

    public String toString() {
        Object result = "";
        String[] splitedNames = this.name.split("[\\(\\)]");
        if (splitedNames.length > 1) {
            String classname = splitedNames[1];
            String shortname = splitedNames[0];
            result = (String)result + "<testcase status=\"" + this.status + "\" name=\"" + TestElement.encode(shortname) + "\" classname=\"" + TestElement.encode(classname) + "\" time=\"" + this.getEllapsedTime() + "\">";
            if (this.isFailed()) {
                result = (String)result + "<failure message=\"" + TestElement.encode(this.failureMessage) + "\">";
                result = (String)result + "<![CDATA[";
                result = (String)result + this.stack;
                result = (String)result + "]]>";
                result = (String)result + "</failure>";
            }
            result = (String)result + "</testcase>\r\n";
        }
        return result;
    }

    public static String encode(String value) {
        return StringEscapeUtils.escapeXml((String)value);
    }

    public void setParent(TestSuiteElement newParent) {
        this.parent = newParent;
        this.parent.childs.add(this);
        --this.parent.remainingTestCount;
        this.isRoot = false;
    }
}

