/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.run;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.jdt.internal.junit.model.ITestRunListener2;
import org.polarsys.capella.test.run.ConsoleTestRunnerApplication;
import org.polarsys.capella.test.run.TestElement;
import org.polarsys.capella.test.run.TestSuiteElement;

public class TestRunListener
implements ITestRunListener2 {
    ConsoleTestRunnerApplication application = null;
    String testSuite;
    String fileName;
    BufferedWriter writer;
    HashMap<String, TestSuiteElement> testSuites = new HashMap();
    LinkedList<TestElement> remainingTests = new LinkedList();
    LinkedList<TestElement> runnedTests = new LinkedList();
    TestElement current = null;
    TestSuiteElement parent = null;

    public TestRunListener(ConsoleTestRunnerApplication consoleTestRunnerApplication, String title, Writer bwriter) {
        this(consoleTestRunnerApplication, title);
        this.writer = new BufferedWriter(bwriter);
    }

    public TestRunListener(ConsoleTestRunnerApplication consoleTestRunnerApplication, String title) {
        this.application = consoleTestRunnerApplication;
        this.testSuite = title;
        this.fileName = this.testSuite + ".xml";
        try {
            String current = new File(".").getCanonicalPath();
            System.out.println("Current dir:" + current);
            this.writer = new BufferedWriter(new FileWriter(this.fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(String content) {
        if (this.writer != null) {
            try {
                this.writer.write(content);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("write:" + e.getMessage());
            }
        }
    }

    public void testRunStarted(int testCount) {
        System.err.println("testRunStarted:" + testCount);
        System.out.println("testRunStarted:" + testCount);
        try {
            this.writer.write("<testsuites>\n");
            this.writer.write("<testsuite name=\"" + TestElement.encode(this.testSuite) + "\">");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("testRunStarted:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunEnded(long elapsedTime) {
        System.err.println("testRunEnded:" + elapsedTime);
        System.out.println("testRunEnded:" + elapsedTime);
        for (TestElement consoleTestRunnerApplication : this.testSuites.values()) {
            if (!consoleTestRunnerApplication.isRoot) continue;
            this.write(consoleTestRunnerApplication.toString());
        }
        for (TestElement testElement : this.runnedTests) {
            if (!testElement.isRoot) continue;
            this.write(testElement.toString());
        }
        if (this.writer != null) {
            try {
                this.writer.write("</testsuite>\r\n");
                this.writer.write("</testsuites>");
                this.writer.close();
            }
            catch (IOException iOException) {
                System.err.println("testRunEnded:" + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        if (this.application != null) {
            ConsoleTestRunnerApplication consoleTestRunnerApplication = this.application;
            synchronized (consoleTestRunnerApplication) {
                this.application.notifyAll();
            }
        }
    }

    public void testRunStopped(long elapsedTime) {
        System.out.println("testRunStopped:" + elapsedTime);
    }

    public void testStarted(String testId, String testName) {
        System.out.println("testStarted:" + testId + " " + testName);
        this.current = this.remainingTests.removeFirst();
        this.runnedTests.add(this.current);
        if (!testId.equals(this.current.id)) {
            System.out.println("testWrongSId:" + this.current.id + " " + testId + " " + testName);
        }
        this.current.timeStart = System.currentTimeMillis();
    }

    public void testEnded(String testId, String testName) {
        System.out.println("testEnded:" + testId + " " + testName);
        if (!testId.equals(this.current.id)) {
            System.out.println("testWrongEId:" + this.current.id + " " + testId + " " + testName);
        }
        this.current.timeEnd = System.currentTimeMillis();
    }

    public void testRunTerminated() {
        System.err.println("testRunTerminated:");
        System.out.println("testRunTerminated:");
    }

    public void testTreeEntry(String description) {
        System.out.println("testTreeEntry:" + description);
        String testId = description.split(",")[0];
        String testName = description.split(",")[1];
        int testCount = Integer.parseInt(description.split(",")[3]);
        boolean isSuite = "true".equals(description.split(",")[2]);
        TestElement element = null;
        if (isSuite) {
            if (this.testSuites.containsKey(testId)) {
                System.out.println("Duplicate id:" + testId + " " + description);
            }
            element = new TestSuiteElement(testId, testName, testCount);
            this.testSuites.put(testId, (TestSuiteElement)element);
            String parentId = description.split(",")[5];
            this.parent = this.testSuites.get(parentId);
        } else {
            element = new TestElement(testId, testName);
            this.remainingTests.addLast(element);
        }
        if (this.parent != null && this.parent.remainingTestCount == 0) {
            this.parent = this.parent.parent;
        }
        if (this.parent != null && this.parent.remainingTestCount > 0) {
            element.setParent(this.parent);
        }
        if (isSuite) {
            this.parent = (TestSuiteElement)element;
        }
    }

    public void testFailed(int status, String testId, String testName, String trace, String expected, String actual) {
        String status2;
        System.out.println("testFailed:" + this.current.id + " " + testName);
        this.current.stack = trace;
        this.current.failed = true;
        this.current.failureMessage = expected + " " + actual;
        if (expected == null && actual == null && trace != null) {
            this.current.failureMessage = trace.split("\n")[0];
        }
        this.current.status = status2 = status == 0 ? "OK" : (status == 1 ? "ERROR" : "WARNING");
    }

    public void testReran(String testId, String testClass, String testName, int status, String trace, String expected, String actual) {
        System.out.println("testReran:" + testId + " " + testName);
    }
}

