/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.semantic.queries.ju;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.query.QueryAdapter;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.EObjectHelper;

public abstract class AbstractSemanticQueryTestCase
extends BasicTestCase {
    protected abstract String getQueryCategoryIdentifier();

    protected void testQuery(String sourceId, String ... expectedResult) {
        this.testQuery(sourceId, Arrays.asList(expectedResult));
    }

    protected void testQuery(String sourceId, Collection<String> expectedResult) {
        CapellaModel model = this.getTestModel((String)this.getRequiredTestModels().iterator().next());
        EObject testObject = EObjectHelper.getObject((IModel)model, (String)sourceId);
        Collection expectedObjects = EObjectHelper.getObjects((IModel)model, expectedResult);
        ICategory category = this.getCategory(this.getQueryCategoryIdentifier());
        if (category == null) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} doesn't exist", (Object)this.getQueryCategoryIdentifier()), (boolean)false);
        }
        if (!category.isAvailableForType((Object)testObject)) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} is not applicable for {1}", (Object)this.getQueryCategoryIdentifier(), (Object)EObjectLabelProviderHelper.getText((Object)testObject)), (boolean)false);
        }
        List objResult = category.compute((Object)testObject);
        HashSet set1 = new HashSet(objResult);
        HashSet set2 = new HashSet(expectedObjects);
        AbstractSemanticQueryTestCase.assertTrue((boolean)set1.equals(set2));
    }

    protected void testQueryIncludingItemQueries(String sourceId, String ... expectedResult) {
        this.testQueryIncludingItemQueries(sourceId, Arrays.asList(expectedResult));
    }

    protected void testQueryIncludingItemQueries(String sourceId, Collection<String> expectedResult) {
        CapellaModel model = this.getTestModel((String)this.getRequiredTestModels().iterator().next());
        EObject testObject = EObjectHelper.getObject((IModel)model, (String)sourceId);
        Collection expectedObjects = EObjectHelper.getObjects((IModel)model, expectedResult);
        ICategory category = this.getCategory(this.getQueryCategoryIdentifier());
        if (category == null) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} doesn't exist", (Object)this.getQueryCategoryIdentifier()), (boolean)false);
        }
        if (!category.isAvailableForType((Object)testObject)) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} is not applicable for {1}", (Object)this.getQueryCategoryIdentifier(), (Object)EObjectLabelProviderHelper.getText((Object)testObject)), (boolean)false);
        }
        List objResult = category.compute((Object)testObject);
        ArrayList itemQueriesResult = new ArrayList();
        for (Object query : category.getItemQueries()) {
            for (Object obj : objResult) {
                List itemQueryResult = QueryAdapter.getInstance().compute(obj, query);
                itemQueriesResult.addAll(itemQueryResult);
            }
        }
        objResult.addAll(itemQueriesResult);
        HashSet set1 = new HashSet(objResult);
        HashSet set2 = new HashSet(expectedObjects);
        AbstractSemanticQueryTestCase.assertTrue((boolean)set1.equals(set2));
    }

    protected void testQueryOnlyItemQueries(String sourceId, String ... expectedResult) {
        this.testQueryOnlyItemQueries(sourceId, Arrays.asList(expectedResult));
    }

    protected void testQueryOnlyItemQueries(String sourceId, Collection<String> expectedResult) {
        CapellaModel model = this.getTestModel((String)this.getRequiredTestModels().iterator().next());
        EObject testObject = EObjectHelper.getObject((IModel)model, (String)sourceId);
        Collection expectedObjects = EObjectHelper.getObjects((IModel)model, expectedResult);
        ICategory category = this.getCategory(this.getQueryCategoryIdentifier());
        if (category == null) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} doesn't exist", (Object)this.getQueryCategoryIdentifier()), (boolean)false);
        }
        if (!category.isAvailableForType((Object)testObject)) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} is not applicable for {1}", (Object)this.getQueryCategoryIdentifier(), (Object)EObjectLabelProviderHelper.getText((Object)testObject)), (boolean)false);
        }
        List objResult = category.compute((Object)testObject);
        ArrayList itemQueriesResult = new ArrayList();
        for (Object query : category.getItemQueries()) {
            for (Object obj : objResult) {
                List itemQueryResult = QueryAdapter.getInstance().compute(obj, query);
                itemQueriesResult.addAll(itemQueryResult);
            }
        }
        objResult.clear();
        objResult.addAll(itemQueriesResult);
        HashSet set1 = new HashSet(objResult);
        HashSet set2 = new HashSet(expectedObjects);
        AbstractSemanticQueryTestCase.assertTrue((boolean)set1.equals(set2));
    }

    protected void testQueryValue(String sourceId, String ... expectedResult) {
        this.testQuery(sourceId, Arrays.asList(expectedResult));
    }

    protected void testQueryValue(String sourceId, Collection<String> expectedValues) {
        CapellaModel model = this.getTestModel((String)this.getRequiredTestModels().iterator().next());
        EObject testObject = EObjectHelper.getObject((IModel)model, (String)sourceId);
        ICategory category = this.getCategory(this.getQueryCategoryIdentifier());
        if (category == null) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} doesn't exist", (Object)this.getQueryCategoryIdentifier()), (boolean)false);
        }
        if (!category.isAvailableForType((Object)testObject)) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} is not applicable for {1}", (Object)this.getQueryCategoryIdentifier(), (Object)EObjectLabelProviderHelper.getText((Object)testObject)), (boolean)false);
        }
        List objResult = category.compute((Object)testObject);
        HashSet set1 = new HashSet(objResult);
        HashSet<String> set2 = new HashSet<String>(expectedValues);
        AbstractSemanticQueryTestCase.assertTrue((boolean)set1.equals(set2));
    }

    protected ICategory getCategory(String categoryId) {
        return CategoryRegistry.getInstance().getCategory(categoryId);
    }
}

