/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.semantic.queries.ju.testcases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.polarsys.capella.common.mdsofa.common.misc.ExtensionClassDescriptor;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class AvailableForTypeClassExistTest
extends BasicTestCase {
    public void test() throws Exception {
        Collection classDescriptors = CategoryRegistry.getInstance().getAvailableForTypeClassDescriptors();
        ArrayList<ExtensionClassDescriptor> notFoundClasses = new ArrayList<ExtensionClassDescriptor>();
        ArrayList<ExtensionClassDescriptor> notFoundContributors = new ArrayList<ExtensionClassDescriptor>();
        for (ExtensionClassDescriptor classDescriptor : classDescriptors) {
            try {
                classDescriptor.loadClass();
            }
            catch (ClassNotFoundException ex) {
                notFoundClasses.add(classDescriptor);
            }
            catch (IllegalStateException ex) {
                notFoundContributors.add(classDescriptor);
            }
        }
        AvailableForTypeClassExistTest.assertTrue((String)this.getClassNotFoundExceptionMsg(notFoundClasses), (boolean)notFoundClasses.isEmpty());
        AvailableForTypeClassExistTest.assertTrue((String)this.getIllegalStateException(notFoundContributors), (boolean)notFoundContributors.isEmpty());
    }

    private String getClassNotFoundExceptionMsg(List<ExtensionClassDescriptor> notFoundClasses) {
        StringBuilder builder = new StringBuilder();
        if (notFoundClasses.size() == 1) {
            builder.append("Unable to find class '" + notFoundClasses.get(0).getClassName() + "'");
        } else {
            builder.append("Unable to find the following classes: ");
            Iterator<ExtensionClassDescriptor> iterator = notFoundClasses.iterator();
            while (iterator.hasNext()) {
                builder.append(iterator.next().getClassName());
                if (!iterator.hasNext()) continue;
                builder.append(" / ");
            }
        }
        return builder.toString();
    }

    private String getIllegalStateException(List<ExtensionClassDescriptor> notFoundContributors) {
        StringBuilder builder = new StringBuilder();
        if (notFoundContributors.size() == 1) {
            builder.append("Cannot locate contributor plug-in '" + notFoundContributors.get(0).getContributorPluginId() + "'");
        } else {
            builder.append("Cannot locate the following contributors plug-ins: ");
            Iterator<ExtensionClassDescriptor> iterator = notFoundContributors.iterator();
            while (iterator.hasNext()) {
                builder.append(iterator.next().getContributorPluginId());
                if (!iterator.hasNext()) continue;
                builder.append(" / ");
            }
        }
        return builder.toString();
    }
}

