/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.semantic.ui.ju;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.intro.IIntroPart;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.framework.context.SessionContext;

public abstract class AbstractSemanticBrowserUITest
extends AbstractDiagramTestCase {
    public static final String SB_VIEW_ID = "org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID";
    public static final String SB_REFERENCED_VIEWER_NAME = "referenced";
    public static final String SB_REFERENCING_VIEWER_NAME = "referencing";
    public static final String SB_CURRENT_VIEWER_NAME = "current";
    public static final String OPEN_REPRESENTATION_ACTION_TITLE = "Open Diagram / Table...";
    Session session;
    SessionContext context;
    TransactionalEditingDomain ted;
    DiagramContext diagramContext;
    DDiagram diagram;

    protected String getRequiredTestModel() {
        return "DiagramNavigationModel";
    }

    protected void init() {
        this.session = this.getSessionForTestModel(this.getRequiredTestModel());
        this.context = new SessionContext(this.session);
        this.ted = this.session.getTransactionalEditingDomain();
    }

    protected List<IContributionItem> getSBViewerOpenMenuContributions(String inputElement, String elementToSelectInSBView, String viewer) {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        PlatformUI.getWorkbench().getIntroManager().closeIntro(introPart);
        try {
            PlatformUI.getWorkbench().showPerspective("capella.sirius.perspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
        AbstractSemanticBrowserUITest.emptyEventsFromUIThread();
        IViewPart view = EclipseUIUtil.showView((String)SB_VIEW_ID);
        AbstractSemanticBrowserUITest.emptyEventsFromUIThread();
        AbstractSemanticBrowserUITest.assertTrue((boolean)(view instanceof SemanticBrowserView));
        SemanticBrowserView sbView = (SemanticBrowserView)view;
        EObject semanticInputElement = this.context.getSemanticElement(inputElement);
        sbView.setInput((Object)semanticInputElement);
        EObject semanticElement = this.context.getSemanticElement(elementToSelectInSBView);
        TreeViewer treeViewer = null;
        treeViewer = viewer.equals(SB_REFERENCED_VIEWER_NAME) ? sbView.getReferencedViewer() : (viewer.equals(SB_REFERENCING_VIEWER_NAME) ? sbView.getReferencingViewer() : sbView.getCurrentViewer());
        StructuredSelection structuredSelection = new StructuredSelection((Object)new EObjectWrapper(semanticElement));
        treeViewer.setSelection((ISelection)structuredSelection, true);
        AbstractSemanticBrowserUITest.emptyEventsFromUIThread();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getControl().setMenu(menu);
        sbView.getSite().registerContextMenu(menuMgr, (ISelectionProvider)treeViewer);
        menu.notifyListeners(22, null);
        MenuItem[] items = menu.getItems();
        List openReItem = Arrays.asList(items).stream().filter(it -> it.getText().equals(OPEN_REPRESENTATION_ACTION_TITLE)).collect(Collectors.toList());
        AbstractSemanticBrowserUITest.assertTrue((String)"There should be a menu Open", (openReItem.size() == 1 ? 1 : 0) != 0);
        Menu subMenu = ((MenuItem)openReItem.get(0)).getMenu();
        subMenu.notifyListeners(22, null);
        MenuItem[] subItems = subMenu.getItems();
        ArrayList<IContributionItem> result = new ArrayList<IContributionItem>();
        Arrays.asList(subItems).stream().filter(it -> it.getData() instanceof ActionContributionItem).forEach(it -> {
            boolean bl = result.add((IContributionItem)((ActionContributionItem)it.getData()));
        });
        subMenu.dispose();
        menu.dispose();
        return result;
    }

    protected void runTestSBViewerOpenMenu(String inputElement, String elementToSelectInSBView, String viewer, Map<String, String> mapExpectedNavigationActions) throws Exception {
        this.session = this.getSessionForTestModel(this.getRequiredTestModel());
        this.context = new SessionContext(this.session);
        this.ted = this.session.getTransactionalEditingDomain();
        List<IContributionItem> actionContributions = this.getSBViewerOpenMenuContributions(inputElement, elementToSelectInSBView, viewer);
        List<DDiagramEditor> diagramEditors = this.checkNavigationAction(actionContributions, mapExpectedNavigationActions);
        for (DDiagramEditor diagramEditor2 : diagramEditors) {
            DialectUIManager.INSTANCE.closeEditor((IEditorPart)diagramEditor2, false);
        }
    }

    protected static void synchronizationWithUIThread() {
        while (PlatformUI.getWorkbench().getDisplay().readAndDispatch()) {
        }
    }

    public static void emptyEventsFromUIThread() {
        boolean shouldRetry = false;
        do {
            try {
                AbstractSemanticBrowserUITest.synchronizationWithUIThread();
                shouldRetry = false;
            }
            catch (Exception e) {
                shouldRetry = true;
            }
        } while (shouldRetry);
    }

    protected List<DDiagramEditor> checkNavigationAction(List<IContributionItem> actionContributions, Map<String, String> mapExpectedNavigationActions) {
        ArrayList<DDiagramEditor> lstEditors = new ArrayList<DDiagramEditor>();
        AbstractSemanticBrowserUITest.assertTrue((String)"ActionContributions count is not as expected", (actionContributions.size() == mapExpectedNavigationActions.size() ? 1 : 0) != 0);
        for (IContributionItem actionContribution : actionContributions) {
            AbstractSemanticBrowserUITest.assertTrue((boolean)(actionContribution instanceof ActionContributionItem));
            IAction action = ((ActionContributionItem)actionContribution).getAction();
            String actionText = action.getText();
            String expectedNavigationUid = mapExpectedNavigationActions.get(actionText);
            AbstractSemanticBrowserUITest.assertNotNull((String)"Action does not have the expected text", (Object)expectedNavigationUid);
            action.run();
            IEditorPart editor2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            AbstractSemanticBrowserUITest.assertTrue((String)"We should have a DDiagramEditor", (boolean)(editor2 instanceof DDiagramEditor));
            DDiagramEditor diagramEditor2 = (DDiagramEditor)editor2;
            DRepresentation representation = diagramEditor2.getRepresentation();
            AbstractSemanticBrowserUITest.assertTrue((String)"We should have a DDiagram", (boolean)(representation instanceof DDiagram));
            lstEditors.add(diagramEditor2);
            DRepresentationQuery q = new DRepresentationQuery(representation);
            DRepresentationDescriptor representationDescriptor = q.getRepresentationDescriptor();
            AbstractSemanticBrowserUITest.assertTrue((String)"Wrong target RepresentationDescriptor", (boolean)representationDescriptor.getUid().equals(expectedNavigationUid));
        }
        return lstEditors;
    }

    protected void undoAllChanges() {
    }
}

