/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.semantic.ui.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.preferences.Activator;
import org.polarsys.capella.core.ui.semantic.browser.handler.AbstractSemanticBrowserDoubleClickHandler;
import org.polarsys.capella.core.ui.semantic.browser.sirius.handlers.NavigationSemanticBrowserDoubleClickHandler;
import org.polarsys.capella.core.ui.semantic.browser.sirius.view.SiriusSemanticBrowserView;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class SemanticBrowserCurrentElementNavigationTest
extends BasicTestCase {
    protected final String CAPELLA_PERSPECTIVE_ID = "capella.sirius.perspective";
    protected final String SEMANTIC_BROWSER_VIEW_ID = "org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID";

    public List<String> getRequiredTestModels() {
        return Arrays.asList("SemanticBrowserNavigation");
    }

    public void test() throws Exception {
        Capability capability = null;
        try {
            CapellaModel model = this.getTestModel(this.getRequiredTestModels().get(0));
            Session session = this.getSession(this.getRequiredTestModels().get(0));
            Project project = model.getProject(session.getTransactionalEditingDomain());
            SystemEngineering eng = (SystemEngineering)project.getOwnedModelRoots().get(0);
            SystemAnalysis systemAnalysisPkg = (SystemAnalysis)eng.getContainedSystemAnalysis().get(0);
            CapabilityPkg capabilityPkg = (CapabilityPkg)systemAnalysisPkg.getOwnedAbstractCapabilityPkg();
            capability = (Capability)capabilityPkg.getOwnedCapabilities().get(0);
        }
        catch (Exception e) {
            SemanticBrowserCurrentElementNavigationTest.fail((String)"Model Elements could not be found");
        }
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            SemanticBrowserCurrentElementNavigationTest.fail((String)"No Active workbench window");
        }
        try {
            this.closeIntro();
        }
        catch (Exception E) {
            SemanticBrowserCurrentElementNavigationTest.fail((String)"Could not close intro page");
        }
        try {
            PlatformUI.getWorkbench().showPerspective("capella.sirius.perspective", activeWorkbenchWindow);
        }
        catch (Exception e) {
            SemanticBrowserCurrentElementNavigationTest.fail((String)"Could not open Capella perspective");
        }
        IViewPart semanticBrowserViewpart = activeWorkbenchWindow.getActivePage().showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
        if (semanticBrowserViewpart != null) {
            SiriusSemanticBrowserView semanticBrowserView = (SiriusSemanticBrowserView)semanticBrowserViewpart;
            semanticBrowserView.setInput(capability);
            TreeViewer viewer = semanticBrowserView.getCurrentViewer();
            Tree viewTree = viewer.getTree();
            viewer.expandAll();
            TreeItem[] items = viewTree.getItems();
            EObjectWrapper fcWrapper = (EObjectWrapper)items[0].getItems()[0].getItems()[0].getData();
            FunctionalChain fc = (FunctionalChain)fcWrapper.getElement();
            EObjectWrapper scWrapper = (EObjectWrapper)items[0].getItems()[1].getItems()[0].getData();
            Scenario sc = (Scenario)scWrapper.getElement();
            EObjectWrapper repWrapper = (EObjectWrapper)items[0].getItems()[2].getItems()[0].getData();
            DRepresentationDescriptor rep = (DRepresentationDescriptor)repWrapper.getElement();
            this.testDoubleClickBehaviors(semanticBrowserView, (Viewer)semanticBrowserView.getCurrentViewer(), (EObject)capability, false, true, false);
            this.testDoubleClickBehaviors(semanticBrowserView, (Viewer)semanticBrowserView.getCurrentViewer(), (EObject)fc, true, false, false);
            this.testDoubleClickBehaviors(semanticBrowserView, (Viewer)semanticBrowserView.getCurrentViewer(), (EObject)sc, true, false, false);
            this.testDoubleClickBehaviors(semanticBrowserView, (Viewer)semanticBrowserView.getCurrentViewer(), (EObject)rep, false, false, true);
            Activator.getDefault().getPreferenceStore().setValue("org.polarsys.capella.core.commands.preferences.ui.sirius.diagrams.navigate.doubleclick", false);
            this.testDoubleClickBehaviors(semanticBrowserView, (Viewer)semanticBrowserView.getCurrentViewer(), (EObject)capability, false, true, false);
            this.testDoubleClickBehaviors(semanticBrowserView, (Viewer)semanticBrowserView.getCurrentViewer(), (EObject)fc, false, true, false);
            this.testDoubleClickBehaviors(semanticBrowserView, (Viewer)semanticBrowserView.getCurrentViewer(), (EObject)sc, false, true, false);
            this.testDoubleClickBehaviors(semanticBrowserView, (Viewer)semanticBrowserView.getCurrentViewer(), (EObject)rep, false, false, true);
            Activator.getDefault().getPreferenceStore().setValue("org.polarsys.capella.core.commands.preferences.ui.sirius.diagrams.navigate.doubleclick", true);
        } else {
            SemanticBrowserCurrentElementNavigationTest.fail((String)"Could not open Semantic Browser View");
        }
    }

    protected void testDoubleClickBehaviors(SiriusSemanticBrowserView view, Viewer source, EObject element, boolean expectedNavigationBehavior, boolean expectedOpenWizardBehavior, boolean expectedOpenDiagramBehavior) {
        DoubleClickEvent event = new DoubleClickEvent(source, (ISelection)new StructuredSelection((Object)element));
        AbstractSemanticBrowserDoubleClickHandler handler = view.getSemanticBrowserDoubleClickHandlerFor(event);
        if (!(handler instanceof NavigationSemanticBrowserDoubleClickHandler)) {
            SemanticBrowserCurrentElementNavigationTest.fail((String)"the doubleClick handler should be an instanceof NavigationSemanticBrowserDoubleClickHandler");
        }
        NavigationSemanticBrowserDoubleClickHandler doubleClickHandler = (NavigationSemanticBrowserDoubleClickHandler)handler;
        SemanticBrowserCurrentElementNavigationTest.assertEquals((boolean)expectedNavigationBehavior, (boolean)doubleClickHandler.shouldNavigate(element));
        SemanticBrowserCurrentElementNavigationTest.assertEquals((boolean)expectedOpenWizardBehavior, (boolean)doubleClickHandler.shouldOpenPropertyWizard(element));
        SemanticBrowserCurrentElementNavigationTest.assertEquals((boolean)expectedOpenDiagramBehavior, (boolean)doubleClickHandler.shouldOpenDiagram(element));
    }

    protected CommonViewer getViewer() {
        CommonViewer[] viewer = new CommonViewer[1];
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("capella.project.explorer");
        viewer[0] = ((CapellaCommonNavigator)part).getCommonViewer();
        return viewer[0];
    }

    protected void closeIntro() {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        PlatformUI.getWorkbench().getIntroManager().closeIntro(introPart);
    }

    protected Event createDoubleClickEvent(Widget sourceWidget, Display display, Widget selectedItem) {
        Event event = new Event();
        event.type = 14;
        event.button = 0;
        event.widget = sourceWidget;
        event.display = display;
        event.item = selectedItem;
        event.doit = true;
        return event;
    }

    protected static void synchronizationWithUIThread() {
        while (PlatformUI.getWorkbench().getDisplay().readAndDispatch()) {
        }
    }
}

