/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.semantic.ui.ju.testcases;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.ui.semantic.browser.sirius.view.SiriusSemanticBrowserView;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class SemanticBrowserReferencingElementNavigationTest
extends BasicTestCase {
    protected final String CAPELLA_PERSPECTIVE_ID = "capella.sirius.perspective";
    protected final String SEMANTIC_BROWSER_VIEW_ID = "org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID";

    public List<String> getRequiredTestModels() {
        return Arrays.asList("SemanticBrowserNavigation");
    }

    public void test() throws Exception {
        Scenario scenarioToBeSelectedInNavigator = null;
        Scenario scenarioToSelectRepresentationFrom = null;
        StructuredSelection navigatorSelection = null;
        StructuredSelection semanticBrowserSelection = null;
        try {
            CapellaModel model = this.getTestModel(this.getRequiredTestModels().get(0));
            Session session = this.getSession(this.getRequiredTestModels().get(0));
            Project project = model.getProject(session.getTransactionalEditingDomain());
            SystemEngineering eng = (SystemEngineering)project.getOwnedModelRoots().get(0);
            SystemAnalysis systemAnalysisPkg = (SystemAnalysis)eng.getContainedSystemAnalysis().get(0);
            CapabilityPkg capabilityPkg = (CapabilityPkg)systemAnalysisPkg.getOwnedAbstractCapabilityPkg();
            Capability capability = (Capability)capabilityPkg.getOwnedCapabilities().get(0);
            scenarioToSelectRepresentationFrom = (Scenario)capability.getOwnedScenarios().get(0);
            Collection descriptors = RepresentationHelper.getAllRepresentationDescriptorsTargetedBy(Collections.singleton(scenarioToSelectRepresentationFrom));
            DRepresentationDescriptor representationToBeSelectedInSemanticBrowser = (DRepresentationDescriptor)descriptors.iterator().next();
            semanticBrowserSelection = new StructuredSelection((Object)new EObjectWrapper((EObject)representationToBeSelectedInSemanticBrowser));
            scenarioToBeSelectedInNavigator = (Scenario)capability.getOwnedScenarios().get(1);
            navigatorSelection = new StructuredSelection((Object)scenarioToBeSelectedInNavigator);
        }
        catch (Exception e) {
            SemanticBrowserReferencingElementNavigationTest.fail((String)"Model Elements could not be found");
        }
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            SemanticBrowserReferencingElementNavigationTest.fail((String)"No Active workbench window");
        }
        try {
            this.closeIntro();
        }
        catch (Exception E) {
            SemanticBrowserReferencingElementNavigationTest.fail((String)"Could not close intro page");
        }
        try {
            PlatformUI.getWorkbench().showPerspective("capella.sirius.perspective", activeWorkbenchWindow);
        }
        catch (Exception e) {
            SemanticBrowserReferencingElementNavigationTest.fail((String)"Could not open Capella perspective");
        }
        CommonViewer viewer = this.getViewer();
        viewer.getCommonNavigator().selectReveal(navigatorSelection);
        IViewPart semanticBrowserViewpart = activeWorkbenchWindow.getActivePage().showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
        if (semanticBrowserViewpart != null) {
            SiriusSemanticBrowserView semanticBrowserView = (SiriusSemanticBrowserView)semanticBrowserViewpart;
            semanticBrowserView.setInput(scenarioToBeSelectedInNavigator);
            TreeViewer referencingViewer = semanticBrowserView.getReferencingViewer();
            Tree referencingViewerTree = referencingViewer.getTree();
            referencingViewer.expandAll();
            TreeItem[] items = referencingViewer.getTree().getItems();
            TreeItem toSelect = items[0].getItems()[0];
            referencingViewer.setSelection(semanticBrowserSelection);
            Display display = referencingViewer.getControl().getDisplay();
            Event doubleClickEvent = this.createDoubleClickEvent((Widget)referencingViewerTree, display, (Widget)toSelect);
            Listener[] listeners = referencingViewerTree.getListeners(14);
            if (listeners == null || listeners[0] == null) {
                SemanticBrowserReferencingElementNavigationTest.fail((String)"Could not find a double click listener");
            }
            Listener listener = listeners[0];
            listener.handleEvent(doubleClickEvent);
            IEditorPart editor = EclipseUIUtil.getActiveEditor();
            SemanticBrowserReferencingElementNavigationTest.assertTrue((String)"We should have a DDiagramEditor", (boolean)(editor instanceof DDiagramEditor));
        } else {
            SemanticBrowserReferencingElementNavigationTest.fail((String)"Could not open Semantic Browser View");
        }
    }

    protected CommonViewer getViewer() {
        CommonViewer[] viewer = new CommonViewer[1];
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("capella.project.explorer");
        viewer[0] = ((CapellaCommonNavigator)part).getCommonViewer();
        return viewer[0];
    }

    protected void closeIntro() {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        PlatformUI.getWorkbench().getIntroManager().closeIntro(introPart);
    }

    protected Event createDoubleClickEvent(Widget sourceWidget, Display display, Widget selectedItem) {
        Event event = new Event();
        event.type = 14;
        event.button = 0;
        event.widget = sourceWidget;
        event.display = display;
        event.item = selectedItem;
        event.doit = true;
        return event;
    }

    protected static void synchronizationWithUIThread() {
        while (PlatformUI.getWorkbench().getDisplay().readAndDispatch()) {
        }
    }
}

