/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.semantic.ui.ju.testcases;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.ui.semantic.browser.sirius.wrapper.CustomEObjectWrapper;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class SemanticBrowserRepresentationHasSemanticQueriesTest
extends BasicTestCase {
    protected final String CAPELLA_PERSPECTIVE_ID = "capella.sirius.perspective";
    protected final String SEMANTIC_BROWSER_VIEW_ID = "org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID";

    public List<String> getRequiredTestModels() {
        return Arrays.asList("DiagramNavigationModel");
    }

    public void test() throws Exception {
        DRepresentationDescriptor representationToSelect = null;
        Scenario scenarioToSelect = null;
        StructuredSelection navigatorSelection = null;
        CustomEObjectWrapper representationCustomWrapper = null;
        CustomEObjectWrapper scenarioCustomWrapper = null;
        try {
            CapellaModel model = this.getTestModel(this.getRequiredTestModels().get(0));
            Session session = this.getSession(this.getRequiredTestModels().get(0));
            Project project = model.getProject(session.getTransactionalEditingDomain());
            SystemEngineering eng = (SystemEngineering)project.getOwnedModelRoots().get(0);
            SystemAnalysis systemAnalysisPkg = (SystemAnalysis)eng.getContainedSystemAnalysis().get(0);
            CapabilityPkg capabilityPkg = (CapabilityPkg)systemAnalysisPkg.getOwnedAbstractCapabilityPkg();
            Capability capability = (Capability)capabilityPkg.getOwnedCapabilities().get(1);
            scenarioToSelect = (Scenario)capability.getOwnedScenarios().get(1);
            Collection descriptors = RepresentationHelper.getAllRepresentationDescriptorsTargetedBy(Collections.singleton(scenarioToSelect));
            representationToSelect = (DRepresentationDescriptor)descriptors.iterator().next();
            navigatorSelection = new StructuredSelection((Object)representationToSelect);
            representationCustomWrapper = new CustomEObjectWrapper((EObject)representationToSelect);
            scenarioCustomWrapper = new CustomEObjectWrapper((EObject)scenarioToSelect);
        }
        catch (Exception e) {
            SemanticBrowserRepresentationHasSemanticQueriesTest.fail((String)"Model Elements could not be found");
        }
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            SemanticBrowserRepresentationHasSemanticQueriesTest.fail((String)"No Active workbench window");
        }
        try {
            this.closeIntro();
        }
        catch (Exception E) {
            SemanticBrowserRepresentationHasSemanticQueriesTest.fail((String)"Could not close intro page");
        }
        try {
            PlatformUI.getWorkbench().showPerspective("capella.sirius.perspective", activeWorkbenchWindow);
        }
        catch (Exception e) {
            SemanticBrowserRepresentationHasSemanticQueriesTest.fail((String)"Could not open Capella perspective");
        }
        CommonViewer viewer = this.getViewer();
        viewer.getCommonNavigator().selectReveal(navigatorSelection);
        IViewPart semanticBrowserViewpart = activeWorkbenchWindow.getActivePage().showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
        if (semanticBrowserViewpart != null) {
            SemanticBrowserView semanticBrowserView = (SemanticBrowserView)semanticBrowserViewpart;
            semanticBrowserView.setInput(representationToSelect);
            this.treeViewerHasCustomEObjectWrappers(semanticBrowserView.getReferencingViewer(), scenarioCustomWrapper);
            this.treeViewerHasCustomEObjectWrappers(semanticBrowserView.getCurrentViewer(), representationCustomWrapper, scenarioCustomWrapper);
            this.treeViewerHasCustomEObjectWrappers(semanticBrowserView.getReferencedViewer(), representationCustomWrapper, scenarioCustomWrapper);
            semanticBrowserView.setInput((Object)scenarioToSelect);
            this.treeViewerHasNoCustomEObjectWrapper(semanticBrowserView.getReferencedViewer());
            this.treeViewerHasNoCustomEObjectWrapper(semanticBrowserView.getCurrentViewer());
            this.treeViewerHasNoCustomEObjectWrapper(semanticBrowserView.getReferencingViewer());
        } else {
            SemanticBrowserRepresentationHasSemanticQueriesTest.fail((String)"Could not open Semantic Browser View");
        }
    }

    protected CommonViewer getViewer() {
        CommonViewer[] viewer = new CommonViewer[1];
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("capella.project.explorer");
        viewer[0] = ((CapellaCommonNavigator)part).getCommonViewer();
        return viewer[0];
    }

    protected void closeIntro() {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        PlatformUI.getWorkbench().getIntroManager().closeIntro(introPart);
    }

    protected void treeViewerHasNoCustomEObjectWrapper(TreeViewer treeViewer) {
        TreeItem[] items;
        treeViewer.expandAll();
        Tree tree = treeViewer.getTree();
        TreeItem[] treeItemArray = items = tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            SemanticBrowserRepresentationHasSemanticQueriesTest.assertFalse((boolean)(item.getData() instanceof CustomEObjectWrapper));
            ++n2;
        }
    }

    protected void treeViewerHasCustomEObjectWrappers(TreeViewer treeViewer, Object ... expectedResult) {
        if (expectedResult == null || expectedResult.length == 0) {
            return;
        }
        treeViewer.expandAll();
        Tree tree = treeViewer.getTree();
        TreeItem[] items = tree.getItems();
        SemanticBrowserRepresentationHasSemanticQueriesTest.assertTrue((items.length == expectedResult.length ? 1 : 0) != 0);
        int i = 0;
        while (i < items.length) {
            TreeItem currentTreeItem = items[i];
            Object currentItem = currentTreeItem.getData();
            SemanticBrowserRepresentationHasSemanticQueriesTest.assertTrue((boolean)(currentItem instanceof CustomEObjectWrapper));
            SemanticBrowserRepresentationHasSemanticQueriesTest.assertEquals((Object)expectedResult[i], (Object)currentItem);
            SemanticBrowserRepresentationHasSemanticQueriesTest.assertTrue((currentTreeItem.getItemCount() > 0 ? 1 : 0) != 0);
            ++i;
        }
    }
}

