/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.table.ju.state;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.table.ju.utils.AbstractTableToolStep;
import org.polarsys.capella.test.table.ju.utils.CreateCellFromIntersectionCommand;
import org.polarsys.capella.test.table.ju.utils.TableTestFramework;
import org.polarsys.capella.test.table.ju.utils.TableTestingHelper;

public abstract class TableStateModeFramework
extends TableTestFramework {
    protected String modelName = "SF-OA";
    protected Session session;
    protected SessionContext context;
    public static final String SF1 = "69f5c20e-5568-496a-ab5d-52e1bed91b49";
    public static final String SF11 = "3f6d7a1b-3219-4677-8483-1596d74b1490";
    public static final String SF2 = "5bc4bdb3-4002-4d58-9886-4d32911264b3";
    public static final String STATE_1 = "5c468906-f2ea-4cea-8269-f9c471090a34";
    public static final String STATE_11 = "ac3bae35-3104-4be6-8268-492516c9d3ca";
    public static final String STATE_2 = "4f6e1a65-235c-446b-a625-1a69044e50b6";
    public static final String MODE_1 = "7688b258-3b48-446c-9bcc-bb2aa83a2bbc";
    public static final String MODE_11 = "0d40aed2-e162-40d6-8ed1-bda32fc9f8b6";
    public static final String MODE_2 = "20efbb96-db7f-4696-b117-9e16295762f0";
    public static final String CAPABILITY_1 = "20be470c-8c1c-4c0b-9baf-71a5b4ec240e";
    public static final String CAPABILITY_2 = "3d54bd19-1842-4562-a0d2-44a20e705dcc";
    public static final String FUNCTIONALCHAIN_1 = "094ad7da-8335-451e-9b1a-9c0019e0b3e6";
    public static final String SYSTEM_ANALYSIS = "e348c8d5-b00e-4147-a4a8-e1450fef6a4d";
    protected SystemFunction _sf1;
    protected SystemFunction _sf11;
    protected SystemFunction _sf2;
    protected Capability _cp1;
    protected Capability _cp2;
    protected FunctionalChain _fc1;
    protected State _state1;
    protected State _state11;
    protected State _state2;
    protected State _mode1;
    protected State _mode11;
    protected State _mode2;
    protected String stateModeErrMsg = "State {0} is not available in {1}";

    protected void init() {
        this.session = this.getSession(this.modelName);
        this.context = new SessionContext(this.session);
        this._sf1 = (SystemFunction)this.context.getSemanticElement(SF1);
        this._sf11 = (SystemFunction)this.context.getSemanticElement(SF11);
        this._sf2 = (SystemFunction)this.context.getSemanticElement(SF2);
        this._cp1 = (Capability)this.context.getSemanticElement(CAPABILITY_1);
        this._cp2 = (Capability)this.context.getSemanticElement(CAPABILITY_2);
        this._fc1 = (FunctionalChain)this.context.getSemanticElement(FUNCTIONALCHAIN_1);
        this._state1 = (State)this.context.getSemanticElement(STATE_1);
        this._state11 = (State)this.context.getSemanticElement(STATE_11);
        this._state2 = (State)this.context.getSemanticElement(STATE_2);
        this._mode1 = (State)this.context.getSemanticElement(MODE_1);
        this._mode11 = (State)this.context.getSemanticElement(MODE_11);
        this._mode2 = (State)this.context.getSemanticElement(MODE_2);
        this._cp1 = (Capability)this.context.getSemanticElement(CAPABILITY_1);
        this._cp2 = (Capability)this.context.getSemanticElement(CAPABILITY_2);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.modelName);
    }

    public void createCellValue(DTable table, final EObject lineObj, final EObject colObj) {
        new AbstractTableToolStep(this.context, DescriptionPackage.Literals.CREATE_CELL_TOOL, table){

            @Override
            protected void initToolArguments() {
                DLine line = TableTestingHelper.getLine(this.table, lineObj);
                DColumn column = TableTestingHelper.getColumn(this.table, colObj);
                CreateCellFromIntersectionCommand cellCommand = new CreateCellFromIntersectionCommand(this.table, line, column, "X");
                cellCommand.execute();
                DCell container = TableTestingHelper.getIntersectionCell(line, column);
                String tableCellMask = "X";
                this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, (Object)container);
                this._toolWrapper.setArgumentValue(ArgumentType.TABLE_CELL_MASK, (Object)tableCellMask);
            }

            protected void postRunTest() {
                super.postRunTest();
                DLine line = TableTestingHelper.getLine(this.table, lineObj);
                DColumn column = TableTestingHelper.getColumn(this.table, colObj);
                DCell cell = TableTestingHelper.getIntersectionCell(line, column);
                TableStateModeFramework.assertEquals((String)cell.getLabel(), (String)"X");
                State state = TableStateModeFramework.this.getState(lineObj, colObj);
                EObject element = TableStateModeFramework.this.getElement(lineObj, colObj);
                boolean check = TableStateModeFramework.this.elementAvailableInState(element, state);
                TableStateModeFramework.assertTrue((String)NLS.bind((String)TableStateModeFramework.this.stateModeErrMsg, (Object)state.getName(), (Object)EObjectLabelProviderHelper.getMetaclassLabel((EObject)element, (boolean)true)), (boolean)check);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void deleteCellValue(DTable table, final EObject lineObj, final EObject colObj) {
        new AbstractTableToolStep(this.context, DescriptionPackage.Literals.CREATE_CELL_TOOL, table){

            @Override
            protected void initToolArguments() {
                DLine line = TableTestingHelper.getLine(this.table, lineObj);
                DColumn column = TableTestingHelper.getColumn(this.table, colObj);
                CreateCellFromIntersectionCommand cellCommand = new CreateCellFromIntersectionCommand(this.table, line, column, "");
                cellCommand.execute();
                DCell container = TableTestingHelper.getIntersectionCell(line, column);
                String tableCellMask = "";
                this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, (Object)container);
                this._toolWrapper.setArgumentValue(ArgumentType.TABLE_CELL_MASK, (Object)tableCellMask);
            }

            protected void postRunTest() {
                super.postRunTest();
                DLine line = TableTestingHelper.getLine(this.table, lineObj);
                DColumn column = TableTestingHelper.getColumn(this.table, colObj);
                DCell cell = TableTestingHelper.getIntersectionCell(line, column);
                TableStateModeFramework.assertTrue((cell == null ? 1 : 0) != 0);
                State state = TableStateModeFramework.this.getState(lineObj, colObj);
                EObject element = TableStateModeFramework.this.getElement(lineObj, colObj);
                boolean check = TableStateModeFramework.this.elementAvailableInState(element, state);
                TableStateModeFramework.assertFalse((String)NLS.bind((String)TableStateModeFramework.this.stateModeErrMsg, (Object)state.getName(), (Object)EObjectLabelProviderHelper.getMetaclassLabel((EObject)element, (boolean)true)), (boolean)check);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    private State getState(EObject lineObj, EObject colObj) {
        State state = null;
        if (lineObj instanceof State) {
            state = (State)lineObj;
        } else if (colObj instanceof State) {
            state = (State)colObj;
        }
        TableStateModeFramework.assertTrue((state != null ? 1 : 0) != 0);
        return state;
    }

    private EObject getElement(EObject lineObj, EObject colObj) {
        EObject element = null;
        if (!(lineObj instanceof State)) {
            element = lineObj;
        } else if (!(colObj instanceof State)) {
            element = colObj;
        }
        TableStateModeFramework.assertTrue((element != null ? 1 : 0) != 0);
        return element;
    }

    private boolean elementAvailableInState(EObject element, State state) {
        boolean check = false;
        if (element instanceof AbstractFunction) {
            check = ((AbstractFunction)element).getAvailableInStates().contains((Object)state);
        }
        if (element instanceof AbstractCapability) {
            check = ((AbstractCapability)element).getAvailableInStates().contains((Object)state);
        }
        if (element instanceof FunctionalChain) {
            check = ((FunctionalChain)element).getAvailableInStates().contains((Object)state);
        }
        return check;
    }
}

