/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.flexibility.properties.loader.PropertiesLoader;
import org.polarsys.capella.common.flexibility.properties.property.PropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.test.framework.api.BasicCommandTestCase;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;

public abstract class TransitionTestCase
extends BasicCommandTestCase {
    IPropertyContext _propertiesContext = null;

    protected void setPreferenceValue(String id, Object value) {
        IProperty property;
        if (this._propertiesContext == null) {
            IProperties properties = new PropertiesLoader().getProperties("capella.core.transition.system.topdown.preferences");
            this._propertiesContext = new PropertyContext(properties);
        }
        if ((property = this._propertiesContext.getProperties().getProperty(id)) == null) {
            TransitionTestCase.assertFalse((String)("Property not found : " + id), (boolean)true);
        }
        this._propertiesContext.setCurrentValue(property, value);
        this._propertiesContext.write(property);
    }

    protected void tearDown() throws Exception {
        if (this._propertiesContext != null) {
            this._propertiesContext.setDefaults();
            this._propertiesContext.writeAll();
        }
        super.tearDown();
    }

    protected List<EObject> getAllocatedElements(EObject object) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (object instanceof TraceableElement) {
            for (AbstractTrace trace : ((TraceableElement)object).getOutgoingTraces()) {
                result.add((EObject)trace.getTargetElement());
            }
        }
        return result;
    }

    protected <T extends EObject> List<T> getAllocatingElements(EObject object) {
        ArrayList<TraceableElement> result = new ArrayList<TraceableElement>();
        if (object instanceof TraceableElement) {
            for (AbstractTrace trace : ((TraceableElement)object).getIncomingTraces()) {
                if (trace instanceof ComponentFunctionalAllocation || trace instanceof PortAllocation || trace instanceof ComponentExchangeFunctionalExchangeAllocation) continue;
                result.add(trace.getSourceElement());
            }
        }
        return result;
    }

    protected EObject getAllocatingElement(EObject object) {
        return this.mustBeMonoTransitioned(object);
    }

    protected EObject checkNoElementAllocated(EObject element) {
        List transitionedElements = this.mustBeMultiTransitioned(element, 0);
        if (transitionedElements.size() == 0) {
            return null;
        }
        return (EObject)this.mustBeMultiTransitioned(element, 0).get(0);
    }

    protected void mustBeOwnedBy(EObject object, EObject container) {
        TransitionTestCase.assertTrue((object != null ? 1 : 0) != 0);
        TransitionTestCase.assertTrue((boolean)object.eContainer().equals(container));
    }

    protected void mustBeContainedBy(String objectId, String containerId) {
        TransitionTestCase.assertTrue((objectId != null ? 1 : 0) != 0);
        TransitionTestCase.assertTrue((boolean)objectId.equals(containerId));
    }

    protected <T extends EObject> T mustBeMonoTransitioned(String id) {
        EObject element = this.getObject(id);
        return (T)((EObject)this.mustBeMultiTransitioned(element, 1).get(0));
    }

    protected <T extends EObject> T mustBeMonoTransitioned(EObject element) {
        return (T)((EObject)this.mustBeMultiTransitioned(element, 1).get(0));
    }

    protected void mustBeNamed(EObject result, String name) {
        TransitionTestCase.assertTrue((boolean)((AbstractNamedElement)result).getName().equals(name));
    }

    protected <T extends EObject> List<T> mustBeMultiTransitioned(String id, int nb) {
        EObject element = this.getObject(id);
        return this.mustBeMultiTransitioned(element, nb);
    }

    protected <T extends EObject> List<T> mustBeMultiTransitioned(EObject element, int nb) {
        TransitionTestCase.assertNotNull((Object)NLS.bind((String)Messages.NullElement, (Object)EObjectLabelProviderHelper.getText((Object)element)));
        List<T> a4t = this.getAllocatingElements(element);
        TransitionTestCase.assertTrue((String)NLS.bind((String)"Should be equals to ''{0}'' but was ''{1}''", (Object)nb, (Object)a4t.size()), (a4t.size() == nb ? 1 : 0) != 0);
        return a4t;
    }

    protected EObject mustBeLinkedTo(String sourceId, String targetId, EStructuralFeature feature) {
        EObject source = this.getObject(sourceId);
        EObject target = this.getObject(targetId);
        return this.mustBeLinkedTo(source, target, feature);
    }

    protected EObject mustBeLinkedTo(EObject source, EObject target, EStructuralFeature feature) {
        if (feature.isMany()) {
            TransitionTestCase.assertTrue((String)NLS.bind((String)"''{0}'' should be linked to ''{1}'' by ''{2}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((Object)source), EObjectLabelProviderHelper.getText((Object)target), feature.getName()}), (boolean)((EList)source.eGet(feature)).contains((Object)target));
        } else {
            TransitionTestCase.assertTrue((String)NLS.bind((String)"''{0}'' should be linked to ''{1}'' by ''{2}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((Object)source), EObjectLabelProviderHelper.getText((Object)target), feature.getName()}), (boolean)target.equals(source.eGet(feature)));
        }
        return source;
    }

    protected EObject mustNotBeLinkedTo(String sourceId, String targetId, EStructuralFeature feature) {
        EObject source = this.getObject(sourceId);
        EObject target = this.getObject(targetId);
        return this.mustNotBeLinkedTo(source, target, feature);
    }

    protected EObject mustBeRealizedBy(String id, EClass clazz) {
        EObject targetObj = this.getObject(id);
        String origName = EObjectLabelProviderHelper.getText((Object)targetObj);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)origName), (Object)targetObj);
        String enrichName = origName + "X";
        for (EObject allocatedElem : this.getAllocatedElements(targetObj)) {
            if (!clazz.isInstance((Object)allocatedElem)) continue;
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)enrichName), (boolean)true);
            return allocatedElem;
        }
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)enrichName), (boolean)false);
        return null;
    }

    protected EObject mustBeRealizedBy(String id, EClass clazz, EObject container) {
        EObject targetObj = this.getObject(id);
        String origName = EObjectLabelProviderHelper.getText((Object)targetObj);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)origName), (Object)targetObj);
        String enrichName = origName + "Q";
        for (EObject allocatedElem : this.getAllocatedElements(targetObj)) {
            String containerName;
            if (!clazz.isInstance((Object)allocatedElem)) continue;
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)enrichName), (boolean)true);
            String string = containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
            if (EcoreUtil2.isOrIsContainedBy((EObject)allocatedElem, (EObject)container)) {
                TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)enrichName, (Object)containerName), (boolean)true);
            }
            return allocatedElem;
        }
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)enrichName), (boolean)false);
        return null;
    }

    protected EObject mustNotBeLinkedTo(EObject source, EObject target, EStructuralFeature feature) {
        if (feature.isMany()) {
            TransitionTestCase.assertFalse((String)NLS.bind((String)"''{0}'' should be linked to ''{1}'' by ''{2}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((Object)source), EObjectLabelProviderHelper.getText((Object)target), feature.getName()}), (boolean)((EList)source.eGet(feature)).contains((Object)target));
        } else {
            TransitionTestCase.assertFalse((String)NLS.bind((String)"''{0}'' should be linked to ''{1}'' by ''{2}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((Object)source), EObjectLabelProviderHelper.getText((Object)target), feature.getName()}), (boolean)target.equals(source.eGet(feature)));
        }
        return source;
    }

    public EObject mustBeTransitionedAndLinkedTo(String element, String referencedElement, EStructuralFeature feature) {
        EObject source = this.getObject(element);
        EObject tSource = this.getAllocatingElement(source);
        EObject target = this.getObject(referencedElement);
        this.testReferenceLinked(tSource, target, feature);
        return source;
    }

    public EObject mustBeTransitionedAndContainedBy(String element, String referencedElement, EStructuralFeature feature) {
        EObject source = this.getObject(element);
        EObject tSource = this.getAllocatingElement(source);
        EObject target = this.getObject(referencedElement);
        this.testReferenceLinked(target, tSource, feature);
        return source;
    }

    public EObject mustBeTransitionedAndContainedByTransitioned(String id, String id2, EStructuralFeature feature) {
        EObject source = this.getObject(id);
        EObject tSource = this.getAllocatingElement(source);
        EObject target = this.getObject(id2);
        EObject tTarget = this.getAllocatingElement(target);
        this.testReferenceLinked(tTarget, tSource, feature);
        return source;
    }

    public EObject mustBeTransitionedAndLinkedToTransitioned(String id, String id2, EStructuralFeature feature) {
        EObject source = this.getObject(id);
        EObject tSource = this.getAllocatingElement(source);
        EObject target = this.getObject(id2);
        EObject tTarget = this.getAllocatingElement(target);
        this.testReferenceLinked(tSource, tTarget, feature);
        return source;
    }

    public EObject mustBeTransitionedAndNotLinkedTo(String id, String id2, EStructuralFeature feature) {
        EObject source = this.getObject(id);
        EObject tSource = this.getAllocatingElement(source);
        EObject target = this.getObject(id2);
        this.testReferenceNotLinked(tSource, target, feature);
        return source;
    }

    public EObject mustBeTransitionedAndNotLinkedToTransitioned(String id, String id2, EStructuralFeature feature) {
        TraceableElement source = (TraceableElement)this.getObject(id);
        ModelElement tSource = ProjectionTestUtils.getAllocatingElement(source);
        TraceableElement target = (TraceableElement)this.getObject(id2);
        ModelElement tTarget = ProjectionTestUtils.getAllocatingElement(target);
        this.testReferenceNotLinked((EObject)tSource, (EObject)tTarget, feature);
        return source;
    }

    public void testReferenceLinked(EObject source, EObject target, EStructuralFeature feature) {
        if (feature.isMany()) {
            TransitionTestCase.assertTrue((boolean)((EList)source.eGet(feature)).contains((Object)target));
        } else {
            TransitionTestCase.assertTrue((boolean)source.eGet(feature).equals(target));
        }
    }

    public void testReferenceNotLinked(EObject source, EObject target, EStructuralFeature feature) {
        if (target == null) {
            if (feature.isMany()) {
                TransitionTestCase.assertTrue((source.eGet(feature) == null || !((EList)source.eGet(feature)).contains(null) ? 1 : 0) != 0);
            } else {
                TransitionTestCase.assertTrue((source.eGet(feature) == null ? 1 : 0) != 0);
            }
        } else if (feature.isMany()) {
            TransitionTestCase.assertTrue((!source.eGet(feature).equals(target) && !((EList)source.eGet(feature)).contains((Object)target) ? 1 : 0) != 0);
        } else {
            TransitionTestCase.assertTrue((!source.eGet(feature).equals(target) ? 1 : 0) != 0);
        }
    }

    protected <T extends EObject> T mustBeTransitioned(String id) {
        EObject a4 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)a4);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        EObject a4t = this.getAllocatingElement(a4);
        String namet = name + "t";
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeTransitioned, (Object)namet), (Object)a4t);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)name), (Object)a4t.eContainer());
        return (T)a4t;
    }

    protected EObject mustBeTransitionedDirecltyContainedBy(String id, EObject container) {
        TraceableElement a4 = (TraceableElement)this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)a4);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        EObject a4t = this.getAllocatingElement((EObject)a4);
        Object namet = a4 instanceof NamedElement ? ((NamedElement)a4).getName() : name + "t";
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeTransitioned, (Object)namet), (Object)a4t);
        String containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)namet, (Object)containerName), (a4t.eContainer() == container ? 1 : 0) != 0);
        return a4t;
    }

    protected EObject mustBeTransitionedIndirecltyContainedBy(String id, EObject container) {
        EObject a4 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)a4);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        EObject a4t = this.getAllocatingElement(a4);
        String namet = name + "t";
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeTransitioned, (Object)namet), (Object)a4t);
        String containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)namet, (Object)containerName), (boolean)EcoreUtil2.isOrIsContainedBy((EObject)a4t, (EObject)container));
        return a4t;
    }

    protected EObject mustBeTransitioned(String id, EObject container) {
        EObject a4 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)a4);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        EObject a4t = this.getAllocatingElement(a4);
        String namet = name + "t";
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeTransitioned, (Object)namet), (Object)a4t);
        String containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)namet, (Object)containerName), (a4t.eContainer() == container ? 1 : 0) != 0);
        return a4t;
    }

    protected EObject mustBeTransitionedAndReference(String id, EObject container) {
        EObject a4 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)a4);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        EObject obj = this.mustBeTransitionedTo(id, a4.eClass(), container);
        EReference[] references = new EReference[]{};
        if (obj instanceof InteractionFragment) {
            references = new EReference[]{InteractionPackage.Literals.INTERACTION_FRAGMENT__COVERED_INSTANCE_ROLES};
        }
        EReference[] eReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            EReference reference = eReferenceArray[n2];
            Object sourceRef = a4.eGet((EStructuralFeature)reference);
            Object targetRef = obj.eGet((EStructuralFeature)reference);
            if (sourceRef == null) {
                TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)reference.getName(), (Object)sourceRef), (targetRef == null ? 1 : 0) != 0);
            } else if (sourceRef instanceof List && targetRef instanceof List) {
                TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)reference.getName(), (Object)("" + ((List)sourceRef).size())), (((List)sourceRef).size() == ((List)targetRef).size() ? 1 : 0) != 0);
            } else {
                TransitionTestCase.assertFalse((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)reference.getName(), (Object)sourceRef), (sourceRef == null ? 1 : 0) != 0);
            }
            ++n2;
        }
        return obj;
    }

    protected EObject mustBeTransitionedTo(String id, EClass clazz) {
        EObject lc1 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)lc1);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)lc1);
        String namet = name + "t";
        for (EObject a4t : this.getAllocatingElements(lc1)) {
            if (!clazz.isInstance((Object)a4t)) continue;
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)namet, (Object)clazz.getName()), (boolean)true);
            return a4t;
        }
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)namet, (Object)clazz.getName()), (boolean)false);
        return null;
    }

    protected EObject mustBeTransitionedTo(String id, EClass clazz, EObject container) {
        EObject lc1 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)lc1);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)lc1);
        String namet = name + "t";
        for (EObject a4t : this.getAllocatingElements(lc1)) {
            String containerName;
            if (!clazz.isInstance((Object)a4t)) continue;
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)namet), (boolean)true);
            String string = containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
            if (EcoreUtil2.isOrIsContainedBy((EObject)a4t, (EObject)container)) {
                TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)namet, (Object)containerName), (boolean)true);
            }
            return a4t;
        }
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)namet), (boolean)false);
        return null;
    }

    protected <T extends EObject> T shouldExist(String id) {
        EObject i2 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)i2);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)i2);
        return (T)i2;
    }

    protected <T extends EObject> T shouldNotBeTransitioned(String id) {
        EObject a5 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)a5);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a5);
        EObject a5t = this.checkNoElementAllocated(a5);
        String namet = name + "t";
        TransitionTestCase.assertNull((String)NLS.bind((String)Messages.ShouldNotBeTransitioned, (Object)namet), (Object)a5t);
        return (T)a5;
    }

    protected boolean shouldNotBeTransitioned(String id, EClass clazz) {
        EObject a5 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)a5);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a5);
        String namet = name + "t";
        for (EObject a5t : this.getAllocatingElements(a5)) {
            if (!clazz.isInstance((Object)a5t)) continue;
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldNotBeTransitioned, (Object)namet), (boolean)false);
            return false;
        }
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldNotBeTransitioned, (Object)namet), (boolean)true);
        return true;
    }

    protected EObject shouldNotBeTransitionedTo(String id, EObject container) {
        EObject lc1 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((Object)lc1);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)lc1);
        String namet = name + "t";
        for (EObject a4t : this.getAllocatingElements(lc1)) {
            String containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldNotBeTransitionedInto, (Object)namet, (Object)containerName), (!EcoreUtil2.isOrIsContainedBy((EObject)a4t, (EObject)container) ? 1 : 0) != 0);
        }
        return null;
    }

    protected boolean shouldAllocate(Interface itf, ExchangeItem item) {
        for (ExchangeItemAllocation a5t : itf.getOwnedExchangeItemAllocations()) {
            if (!item.equals(a5t.getAllocatedItem())) continue;
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldAllocateEI, (Object)item.getName()), (boolean)true);
            return true;
        }
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldAllocateEI, (Object)item.getName()), (boolean)false);
        return false;
    }

    protected EObject mustBeTransitionedDirecltyContainedBy(String name, String id, EObject container) {
        TraceableElement a4 = (TraceableElement)this.getObject(id);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        ModelElement a4t = ProjectionTestUtils.getAllocatingElement(a4);
        Object namet = a4 instanceof NamedElement ? ((NamedElement)a4).getName() : name + "t";
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeTransitioned, (Object)namet), (Object)a4t);
        String containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)namet, (Object)containerName), (a4t.eContainer() == container ? 1 : 0) != 0);
        return a4t;
    }

    public void mustNotBeNull(EObject object) {
        TransitionTestCase.assertNotNull((String)"Element shall not be null", (Object)object);
    }
}

