/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.CodeHelper;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelLaPa;

public class CapabilityTransition
extends TopDownTransitionTestCase {
    private CapabilityRealizationPkg laRootCRPkg;
    private CapabilityRealizationPkg laSubCRPkg;
    private CapabilityRealization laCR1;
    private CapabilityRealization laCR2;
    private CapabilityRealization laCR11;
    private CapabilityRealization laCR3;
    private CapabilityRealization laSubCR1;
    private CapabilityRealization CR1;
    private CapabilityRealizationPkg paRootCRPkg;
    private CapabilityRealizationPkg paSubCRPkg;
    private CapabilityRealization paCR1;
    private CapabilityRealization paCR11;
    private CapabilityRealization paCR2;
    private CapabilityRealization paCR3;
    private CapabilityRealization paSubCR1;
    private PhysicalComponent PA_LC1;
    private PhysicalComponent PA_LA1;

    private void initSession() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.laRootCRPkg = (CapabilityRealizationPkg)this.getObject(ModelLaPa.rootLACRPkgId);
        this.laCR1 = (CapabilityRealization)this.getObject(ModelLaPa.CR1Id);
        this.laCR2 = (CapabilityRealization)this.getObject(ModelLaPa.CR2Id);
        this.laCR11 = (CapabilityRealization)this.getObject(ModelLaPa.CR11Id);
        this.paRootCRPkg = (CapabilityRealizationPkg)this.getObject(ModelLaPa.rootPACRPkgId);
        this.CR1 = (CapabilityRealization)this.getObject("9ec8790b-f979-452e-a26e-489463483422");
        this.PA_LC1 = (PhysicalComponent)this.getObject("4fec699d-fefb-42fc-9a35-3e6e7d44c6a4");
        this.PA_LA1 = (PhysicalComponent)this.getObject("b874943b-5951-4556-898d-4a6402e889e4");
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this.initSession();
        this.CR11TransitionTest();
        this.rootCRPkgProjection1Test();
        this.rootcapaPkgProjection2Test();
        this.rootcapaPkgProjection3Test();
        this.performTestOnCR1();
    }

    private void CR11TransitionTest() {
        this.performCapabilityTransition(Arrays.asList(this.laCR11));
        this.paCR11 = (CapabilityRealization)this.paRootCRPkg.getOwnedCapabilityRealizations().get(0);
        this.mustNotBeNull((EObject)this.laCR11);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR11.getName(), (Object)this.laCR11.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR11) == this.laCR11 ? 1 : 0) != 0);
    }

    private void rootCRPkgProjection1Test() {
        this.performCapabilityTransition(Arrays.asList(this.laRootCRPkg));
        this.paCR1 = (CapabilityRealization)CodeHelper.getChildTracingElement((EObject)this.paRootCRPkg, (EObject)this.laCR1);
        this.mustNotBeNull((EObject)this.paCR1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this.laCR1.getName()), (this.laCR1.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this.paCR1.getName()), (this.paCR1.eContainer() == this.paRootCRPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR1.getName(), (Object)this.laCR1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR1) == this.laCR1 ? 1 : 0) != 0);
        this.paCR2 = (CapabilityRealization)CodeHelper.getChildTracingElement((EObject)this.paRootCRPkg, (EObject)this.laCR2);
        this.mustNotBeNull((EObject)this.paCR2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this.laCR2.getName()), (this.laCR2.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this.paCR2.getName()), (this.paCR2.eContainer() == this.paRootCRPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR2.getName(), (Object)this.laCR2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR2) == this.laCR2 ? 1 : 0) != 0);
    }

    private void rootcapaPkgProjection2Test() {
        this.performCapabilityTransition(Arrays.asList(this.laRootCRPkg));
        int laSize = this.laRootCRPkg.getOwnedCapabilityRealizations().size();
        int paSize = this.paRootCRPkg.getOwnedCapabilityRealizations().size();
        CapabilityTransition.assertTrue((String)Messages.WrongSize, (laSize == paSize ? 1 : 0) != 0);
    }

    private void rootcapaPkgProjection3Test() {
        this.laCR2.destroy();
        this.laCR3 = LaFactory.eINSTANCE.createCapabilityRealization("CR3");
        this.laRootCRPkg.getOwnedCapabilityRealizations().add((Object)this.laCR3);
        this.laSubCRPkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg("SubCRPkg");
        this.laRootCRPkg.getOwnedCapabilityRealizationPkgs().add((Object)this.laSubCRPkg);
        this.laSubCR1 = LaFactory.eINSTANCE.createCapabilityRealization("SubCR1");
        this.laSubCRPkg.getOwnedCapabilityRealizations().add((Object)this.laSubCR1);
        this.performCapabilityTransition(Arrays.asList(this.laRootCRPkg));
        this.mustNotBeNull((EObject)this.paCR2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR2.getName(), (Object)this.laCR2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR2) == null ? 1 : 0) != 0);
        this.paCR3 = (CapabilityRealization)CodeHelper.getChildTracingElement((EObject)this.paRootCRPkg, (EObject)this.laCR3);
        this.mustNotBeNull((EObject)this.paCR3);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this.laCR3.getName()), (this.laCR3.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this.paCR3.getName()), (this.paCR3.eContainer() == this.paRootCRPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR3.getName(), (Object)this.laCR3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR3) == this.laCR3 ? 1 : 0) != 0);
        this.paSubCRPkg = (CapabilityRealizationPkg)this.paRootCRPkg.getOwnedCapabilityRealizationPkgs().get(0);
        this.mustNotBeNull((EObject)this.paSubCRPkg);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubCRPkg.getName(), (Object)this.laSubCRPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubCRPkg) == this.laSubCRPkg ? 1 : 0) != 0);
        this.paSubCR1 = (CapabilityRealization)this.paSubCRPkg.getOwnedCapabilityRealizations().get(0);
        this.mustNotBeNull((EObject)this.paSubCR1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubCR1.getName(), (Object)this.laSubCR1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubCR1) == this.laSubCR1 ? 1 : 0) != 0);
    }

    public void performTestOnCR1() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this.CR1));
        CapabilityRealization paCR1 = (CapabilityRealization)this.mustBeTransitioned("9ec8790b-f979-452e-a26e-489463483422");
        CapabilityTransition.assertTrue((String)"There must be an involvement between the transitioned CR3 and the transitioned LC1 ", (paCR1.getOwnedCapabilityRealizationInvolvements().stream().filter(i -> i.getInvolved() == this.PA_LC1).count() == 1L ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)"There must be an involvement between the transitioned CR3 and the transitioned LA1 ", (paCR1.getOwnedCapabilityRealizationInvolvements().stream().filter(i -> i.getInvolved() == this.PA_LA1).count() == 1L ? 1 : 0) != 0);
        CapabilityRealization laCR2 = (CapabilityRealization)this.mustBeTransitioned("d0ff6399-63fb-4a17-bbc5-1d46693947d9");
        CapabilityRealization laCR3 = (CapabilityRealization)this.mustBeTransitioned("63510412-f54a-4a4c-aadb-2faec518a043");
        CapabilityRealization laCR4 = (CapabilityRealization)this.mustBeTransitioned("595018b2-fbf4-4fc6-b542-b58a6e3456f7");
        paCR1.getExtendedAbstractCapabilities().contains((Object)laCR2);
        paCR1.getIncludedAbstractCapabilities().contains((Object)laCR3);
        paCR1.getSuper().contains((Object)laCR4);
    }
}

