/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelLaPa;

public class ExchangeItemTransition
extends TopDownTransitionTestCase {
    private DataPkg laDataPkg;
    private ExchangeItem laei1;
    private ExchangeItemElement laeie1_1;
    private ExchangeItemElement laeie1_2;
    private ExchangeItem laei2;
    private ExchangeItemElement laeie2_1;
    private ExchangeItem laei3;
    private ExchangeItemElement laeie3_1;
    private ExchangeItem laei4;
    private ExchangeItemElement laeie4_1;
    private ExchangeItem laei5;
    private ExchangeItemElement laeie5_1;
    private ExchangeItemElement laeie5_2;
    private DataPkg paDataPkg;
    private ExchangeItem paei1;
    private ExchangeItemElement paeie1_1;
    private ExchangeItemElement paeie1_2;
    private ExchangeItem paei2;
    private ExchangeItemElement paeie2_1;
    private ExchangeItem paei3;
    private ExchangeItemElement paeie3_1;
    private ExchangeItem paei4;
    private ExchangeItemElement paeie4_1;
    private ExchangeItem paei5;
    private ExchangeItemElement paeie5_1;
    private ExchangeItemElement paeie5_2;

    private void initSession() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.laDataPkg = (DataPkg)this.getObject(ModelLaPa.laDataPkgId);
        this.laei1 = (ExchangeItem)this.getObject(ModelLaPa.ei1Id);
        this.laeie1_1 = (ExchangeItemElement)this.getObject(ModelLaPa.eie1_1Id);
        this.laei2 = (ExchangeItem)this.getObject(ModelLaPa.ei2Id);
        this.laeie2_1 = (ExchangeItemElement)this.getObject(ModelLaPa.eie2_1Id);
        this.laei3 = (ExchangeItem)this.getObject(ModelLaPa.ei3Id);
        this.laeie3_1 = (ExchangeItemElement)this.getObject(ModelLaPa.eie3_1Id);
        this.laei4 = (ExchangeItem)this.getObject(ModelLaPa.ei4Id);
        this.laeie4_1 = (ExchangeItemElement)this.getObject(ModelLaPa.eie4_1Id);
        this.laei5 = (ExchangeItem)this.getObject(ModelLaPa.ei5Id);
        this.laeie5_1 = (ExchangeItemElement)this.getObject(ModelLaPa.eie5_1Id);
        this.laeie5_2 = (ExchangeItemElement)this.getObject(ModelLaPa.eie5_2Id);
        this.paDataPkg = (DataPkg)this.getObject(ModelLaPa.paDataPkgId);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this.initSession();
        this.exchangeItem1TransitionTest();
        this.exchangeItem2TransitionTest();
        this.exchangeItem3TransitionTest();
        this.exchangeItem3TransitionTest();
        this.exchangeItem4TransitionTest();
        this.exchangeItem4TransitionTest();
        this.exchangeItem5TransitionTest();
        this.exchangeItem1Transition2Test();
        this.ei1TransitionAfterChangesTest();
    }

    private void exchangeItem1TransitionTest() {
        this.performExchangeItemTransition(Arrays.asList(this.laei1));
        this.paei1 = (ExchangeItem)this.paDataPkg.getOwnedExchangeItems().get(0);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paei1);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paei1.getName(), (Object)this.laei1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paei1) == this.laei1 ? 1 : 0) != 0);
        ExchangeMechanism paei1Mechanism = this.paei1.getExchangeMechanism();
        ExchangeMechanism laei1Mechanism = this.laei1.getExchangeMechanism();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongValue, this.paei1.getName(), paei1Mechanism.getName(), laei1Mechanism.getName()), (boolean)paei1Mechanism.equals((Object)laei1Mechanism));
        this.paeie1_1 = (ExchangeItemElement)this.paei1.getOwnedElements().get(0);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paeie1_1);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paeie1_1.getName(), (Object)this.laeie1_1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paeie1_1) == this.laeie1_1 ? 1 : 0) != 0);
        Type paeie1_1Type = this.paeie1_1.getType();
        Type laeie1_1Type = this.laeie1_1.getType();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongType, this.paeie1_1.getName(), paeie1_1Type.getName(), laeie1_1Type.getName()), (boolean)paeie1_1Type.equals(laeie1_1Type));
    }

    private void exchangeItem2TransitionTest() {
        this.performExchangeItemTransition(Arrays.asList(this.laei2));
        this.paei2 = (ExchangeItem)this.paDataPkg.getOwnedExchangeItems().get(1);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paei2);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paei2.getName(), (Object)this.laei2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paei2) == this.laei2 ? 1 : 0) != 0);
        ExchangeMechanism paei2Mechanism = this.paei2.getExchangeMechanism();
        ExchangeMechanism laei2Mechanism = this.laei2.getExchangeMechanism();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongValue, this.paei2.getName(), paei2Mechanism.getName(), laei2Mechanism.getName()), (boolean)paei2Mechanism.equals((Object)laei2Mechanism));
        this.paeie2_1 = (ExchangeItemElement)this.paei2.getOwnedElements().get(0);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paeie2_1);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paeie2_1.getName(), (Object)this.laeie2_1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paeie2_1) == this.laeie2_1 ? 1 : 0) != 0);
        Type paeie2_1Type = this.paeie2_1.getType();
        Type laeie2_1Type = this.laeie2_1.getType();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongType, this.paeie2_1.getName(), paeie2_1Type.getName(), laeie2_1Type.getName()), (boolean)paeie2_1Type.equals(laeie2_1Type));
    }

    private void exchangeItem3TransitionTest() {
        this.performExchangeItemTransition(Arrays.asList(this.laei3));
        this.paei3 = (ExchangeItem)this.paDataPkg.getOwnedExchangeItems().get(2);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paei3);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paei3.getName(), (Object)this.laei3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paei3) == this.laei3 ? 1 : 0) != 0);
        ExchangeMechanism paei3Mechanism = this.paei3.getExchangeMechanism();
        ExchangeMechanism laei3Mechanism = this.laei3.getExchangeMechanism();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongValue, this.paei3.getName(), paei3Mechanism.getName(), laei3Mechanism.getName()), (boolean)paei3Mechanism.equals((Object)laei3Mechanism));
        this.paeie3_1 = (ExchangeItemElement)this.paei3.getOwnedElements().get(0);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paeie3_1);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paeie3_1.getName(), (Object)this.laeie3_1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paeie3_1) == this.laeie3_1 ? 1 : 0) != 0);
        Type paeie3_1Type = this.paeie3_1.getType();
        Type laeie3_1Type = this.laeie3_1.getType();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongType, this.paeie3_1.getName(), paeie3_1Type.getName(), laeie3_1Type.getName()), (boolean)paeie3_1Type.equals(laeie3_1Type));
    }

    private void exchangeItem4TransitionTest() {
        this.performExchangeItemTransition(Arrays.asList(this.laei4));
        this.paei4 = (ExchangeItem)this.paDataPkg.getOwnedExchangeItems().get(3);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paei4);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paei4.getName(), (Object)this.laei4.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paei4) == this.laei4 ? 1 : 0) != 0);
        ExchangeMechanism paei4Mechanism = this.paei4.getExchangeMechanism();
        ExchangeMechanism laei4Mechanism = this.laei4.getExchangeMechanism();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongValue, this.paei4.getName(), paei4Mechanism.getName(), laei4Mechanism.getName()), (boolean)paei4Mechanism.equals((Object)laei4Mechanism));
        this.paeie4_1 = (ExchangeItemElement)this.paei4.getOwnedElements().get(0);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paeie4_1);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paeie4_1.getName(), (Object)this.laeie4_1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paeie4_1) == this.laeie4_1 ? 1 : 0) != 0);
        Type paeie4_1Type = this.paeie4_1.getType();
        Type laeie4_1Type = this.laeie4_1.getType();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongType, this.paeie4_1.getName(), paeie4_1Type.getName(), laeie4_1Type.getName()), (boolean)paeie4_1Type.equals(laeie4_1Type));
    }

    private void exchangeItem5TransitionTest() {
        this.performExchangeItemTransition(Arrays.asList(this.laei5));
        this.paei5 = (ExchangeItem)this.paDataPkg.getOwnedExchangeItems().get(4);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paei5);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paei5.getName(), (Object)this.laei5.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paei5) == this.laei5 ? 1 : 0) != 0);
        ExchangeMechanism paei5Mechanism = this.paei5.getExchangeMechanism();
        ExchangeMechanism laei5Mechanism = this.laei5.getExchangeMechanism();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongValue, this.paei5.getName(), paei5Mechanism.getName(), laei5Mechanism.getName()), (boolean)paei5Mechanism.equals((Object)laei5Mechanism));
        this.paeie5_1 = (ExchangeItemElement)this.paei5.getOwnedElements().get(0);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paeie5_1);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paeie5_1.getName(), (Object)this.laeie5_1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paeie5_1) == this.laeie5_1 ? 1 : 0) != 0);
        Type paeie5_1Type = this.paeie5_1.getType();
        Type laeie5_1Type = this.laeie5_1.getType();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongType, this.paeie5_1.getName(), paeie5_1Type.getName(), laeie5_1Type.getName()), (boolean)paeie5_1Type.equals(laeie5_1Type));
        this.paeie5_2 = (ExchangeItemElement)this.paei5.getOwnedElements().get(1);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paeie5_2);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paeie5_2.getName(), (Object)this.laeie5_2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paeie5_2) == this.laeie5_2 ? 1 : 0) != 0);
        Type paeie5_2Type = this.paeie5_2.getType();
        Type laeie5_2Type = this.laeie5_2.getType();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongType, this.paeie5_2.getName(), paeie5_2Type.getName(), laeie5_2Type.getName()), (boolean)paeie5_2Type.equals(laeie5_2Type));
    }

    private void exchangeItem1Transition2Test() {
        this.performExchangeItemTransition(Arrays.asList(this.laei1));
        ExchangeItemTransition.assertEquals((String)Messages.ProjectionSizeError, (int)this.laDataPkg.getOwnedExchangeItems().size(), (int)this.paDataPkg.getOwnedExchangeItems().size());
        ExchangeItemTransition.assertEquals((String)Messages.ProjectionSizeError, (int)this.laei1.getOwnedElements().size(), (int)this.paei1.getOwnedElements().size());
        ExchangeMechanism paei1Mechanism = this.paei1.getExchangeMechanism();
        ExchangeMechanism laei1Mechanism = this.laei1.getExchangeMechanism();
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongValue, this.paei1.getName(), paei1Mechanism.getName(), laei1Mechanism.getName()), (boolean)paei1Mechanism.equals((Object)laei1Mechanism));
    }

    private void ei1TransitionAfterChangesTest() {
        this.laeie1_1.destroy();
        this.laeie1_2 = InformationFactory.eINSTANCE.createExchangeItemElement("ExchangeItemElement1_2");
        this.laei1.getOwnedElements().add((Object)this.laeie1_2);
        this.laei1.setExchangeMechanism(ExchangeMechanism.FLOW);
        this.performExchangeItemTransition(Arrays.asList(this.laei1));
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paeie1_1);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paeie1_1.getName(), null), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paeie1_1) == null ? 1 : 0) != 0);
        this.paeie1_2 = (ExchangeItemElement)this.paei1.getOwnedElements().get(1);
        ExchangeItemTransition.assertNotNull((String)Messages.NullError, (Object)this.paeie1_2);
        ExchangeItemTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paeie1_2.getName(), (Object)this.laeie1_2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paeie1_2) == this.laeie1_2 ? 1 : 0) != 0);
        ExchangeItemTransition.assertTrue((String)MessageFormat.format(Messages.WrongValue, this.laei1.getName(), this.laei1.getExchangeMechanism().getName(), ExchangeMechanism.FLOW.getName()), (boolean)this.paei1.getExchangeMechanism().equals((Object)ExchangeMechanism.FLOW));
    }
}

