/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;

public class LCPCNatureTransition
extends TopDownTransitionTestCase {
    private static final String MODEL_NAME = "lc-to-pc-nature-transition";
    public static final String LA_3_1_ID = "30288654-bae6-4bc8-a7a5-f2528f9611e9";
    public static final String LA_3_ID = "faa4c7ce-31d0-49cc-8747-e7fe91e03e96";
    public static final String LC_2 = "aaa1c0bf-c034-45a1-969b-6f5f65d14744";
    protected LogicalComponent la1;
    protected LogicalComponentPkg logicalComponentPkg;
    protected PhysicalComponentPkg physicalComponentPkg;
    protected Map<LogicalComponent, PhysicalComponentNature> expectedComponentToNature;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Session session = this.getSession(MODEL_NAME);
        SessionContext sessionContext = new SessionContext(session);
        this.la1 = (LogicalComponent)sessionContext.getSemanticElement("2e04b442-1fb6-4aca-bfdb-bf36dc232775");
        this.logicalComponentPkg = (LogicalComponentPkg)sessionContext.getSemanticElement("db6418bb-f0e8-40e0-a8ee-ec55b7f29153");
        this.physicalComponentPkg = (PhysicalComponentPkg)sessionContext.getSemanticElement("781143cf-9620-40de-89a6-9ec662da8b88");
        List logicalComponents = ComponentPkgExt.getAllSubDefinedComponents((ComponentPkg)this.logicalComponentPkg);
        Component logicalSystem = BlockArchitectureExt.getRootBlockArchitecture((EObject)this.logicalComponentPkg).getSystem();
        LCPCNatureTransition.assertTrue((boolean)logicalComponents.remove(logicalSystem));
        LCPCNatureTransition.assertEquals((int)9, (int)logicalComponents.size());
        this.expectedComponentToNature = new HashMap<LogicalComponent, PhysicalComponentNature>();
        for (Component component : logicalComponents) {
            if (!(component instanceof LogicalComponent)) continue;
            LogicalComponent logicalComponent = (LogicalComponent)component;
            String id = logicalComponent.getId();
            if (LA_3_ID.equals(id) || LA_3_1_ID.equals(id)) {
                this.expectedComponentToNature.put(logicalComponent, PhysicalComponentNature.NODE);
                continue;
            }
            this.expectedComponentToNature.put(logicalComponent, PhysicalComponentNature.BEHAVIOR);
        }
    }

    public void performTest() throws Exception {
        this.assertSingularTransition();
        this.assertMultipleTransition();
    }

    private void assertSingularTransition() {
        Predicate<PhysicalComponent> singularTransitionPredicate = physicalComponent -> PhysicalComponentNature.NODE == physicalComponent.getNature();
        this.assertLCPCNatureTransition(Arrays.asList(this.la1), singularTransitionPredicate);
    }

    private void assertMultipleTransition() {
        Predicate<PhysicalComponent> multiTransitionPredicate = physicalComponent -> {
            LogicalComponent logicalComponent = (LogicalComponent)ProjectionTestUtils.getRealizedTargetElement((TraceableElement)physicalComponent);
            PhysicalComponentNature expectedNature = this.expectedComponentToNature.get(logicalComponent);
            return physicalComponent.getNature() == expectedNature;
        };
        this.assertLCPCNatureTransition(Arrays.asList(this.logicalComponentPkg), multiTransitionPredicate);
    }

    protected void assertLCPCNatureTransition(Collection<EObject> logicalElements, Predicate<PhysicalComponent> testPredicate) {
        this.performLCtoPCTransition(logicalElements);
        List transionedPhysicalComponents = ComponentPkgExt.getAllSubDefinedComponents((ComponentPkg)this.physicalComponentPkg);
        Component physicalSystem = BlockArchitectureExt.getRootBlockArchitecture((EObject)this.physicalComponentPkg).getSystem();
        LCPCNatureTransition.assertTrue((boolean)transionedPhysicalComponents.remove(physicalSystem));
        for (Component component : transionedPhysicalComponents) {
            LCPCNatureTransition.assertTrue((boolean)(component instanceof PhysicalComponent));
            PhysicalComponent transitionedComponent = (PhysicalComponent)component;
            TraceableElement realizedTargetElement = ProjectionTestUtils.getRealizedTargetElement((TraceableElement)transitionedComponent);
            LCPCNatureTransition.assertTrue((boolean)(realizedTargetElement instanceof LogicalComponent));
            LCPCNatureTransition.assertTrue((boolean)testPredicate.test(transitionedComponent));
        }
    }
}

