/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.ChoicePseudoState;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.ForkPseudoState;
import org.polarsys.capella.core.data.capellacommon.InitialPseudoState;
import org.polarsys.capella.core.data.capellacommon.JoinPseudoState;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacommon.TerminatePseudoState;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelLaPa;

public class StateMachineTransition
extends TopDownTransitionTestCase {
    private LogicalComponent laSystem;
    private StateMachine laSystemStateMachine;
    private Region laSystemRegion;
    private InitialPseudoState laInitialState;
    private Mode laMode1;
    private Region laMode1Region;
    private State laMode1State1;
    private Mode laMode2;
    private Region laMode2Region;
    private InitialPseudoState laMode2Initial;
    private State laMode2State1;
    private State laMode2State2;
    private FinalState laMode2Final;
    private Mode laMode3;
    private ForkPseudoState laFork;
    private JoinPseudoState laJoin;
    private ChoicePseudoState laChoice;
    private TerminatePseudoState laTerminate;
    private FinalState laFinal;
    private StateMachine laLeafStateMachine;
    private Region laLeafRegion;
    private PhysicalComponent physicalSystem;
    private StateMachine physicalSystemStateMachine;
    private Region physicalSystemRegion;
    private InitialPseudoState paInitialState;
    private Mode paMode1;
    private Region paMode1Region;
    private State paMode1State1;
    private Mode paMode2;
    private Region paMode2Region;
    private InitialPseudoState paMode2Initial;
    private State paMode2State1;
    private State paMode2State2;
    private FinalState paMode2Final;
    private Mode paMode3;
    private ForkPseudoState paFork;
    private JoinPseudoState paJoin;
    private ChoicePseudoState paChoice;
    private TerminatePseudoState paTerminate;
    private FinalState paFinal;
    private StateMachine paLeafStateMachine;
    private Region paLeafRegion;

    private void initSession() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.laSystem = (LogicalComponent)this.getObject(ModelLaPa.logicalSystemId);
        this.laSystemStateMachine = (StateMachine)this.getObject(ModelLaPa.logicalSystemStateMachineId);
        this.laSystemRegion = (Region)this.getObject(ModelLaPa.logicalSystemRegionId);
        this.laInitialState = (InitialPseudoState)this.getObject(ModelLaPa.initialStateId);
        this.laMode1 = (Mode)this.getObject(ModelLaPa.mode1Id);
        this.laMode2 = (Mode)this.getObject(ModelLaPa.mode2Id);
        this.laMode2Region = (Region)this.getObject(ModelLaPa.mode2RegionId);
        this.laMode2Initial = (InitialPseudoState)this.getObject(ModelLaPa.mode2InitialId);
        this.laMode2State1 = (State)this.getObject(ModelLaPa.mode2State1Id);
        this.laMode2State2 = (State)this.getObject(ModelLaPa.mode2State2Id);
        this.laMode2Final = (FinalState)this.getObject(ModelLaPa.mode2FinalId);
        this.laMode3 = (Mode)this.getObject(ModelLaPa.mode3Id);
        this.laFork = (ForkPseudoState)this.getObject(ModelLaPa.forkId);
        this.laJoin = (JoinPseudoState)this.getObject(ModelLaPa.joinId);
        this.laChoice = (ChoicePseudoState)this.getObject(ModelLaPa.choiceId);
        this.laTerminate = (TerminatePseudoState)this.getObject(ModelLaPa.terminateId);
        this.laFinal = (FinalState)this.getObject(ModelLaPa.finalId);
        this.laLeafStateMachine = (StateMachine)this.getObject(ModelLaPa.leafStateMachineId);
        this.laLeafRegion = (Region)this.getObject(ModelLaPa.leafRegionId);
        this.physicalSystem = (PhysicalComponent)this.getObject(ModelLaPa.physicalSystemId);
    }

    public void performTest() throws Exception {
        this.initSession();
        this.leafSMProjectionTest();
        this.logicalSystemSMProjection1Test();
        this.logicalSMProjection2Test();
        this.logicalSMProjection3Test();
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    private void leafSMProjectionTest() {
        this.performStateMachineTransition(Arrays.asList(this.laLeafStateMachine));
        this.paLeafStateMachine = ProjectionTestUtils.getRecentlyAddedStateMachine((Component)this.physicalSystem);
        this.mustNotBeNull((EObject)this.paLeafStateMachine);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paLeafStateMachine.getName(), (Object)this.laLeafStateMachine.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paLeafStateMachine) == this.laLeafStateMachine ? 1 : 0) != 0);
        this.paLeafRegion = (Region)this.paLeafStateMachine.getOwnedRegions().get(0);
        this.mustNotBeNull((EObject)this.paLeafRegion);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paLeafRegion.getName(), (Object)this.laLeafRegion.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paLeafRegion) == this.laLeafRegion ? 1 : 0) != 0);
    }

    private void logicalSystemSMProjection1Test() {
        this.performStateMachineTransition(Arrays.asList(this.laSystemStateMachine));
        this.physicalSystemStateMachine = ProjectionTestUtils.getRecentlyAddedStateMachine((Component)this.physicalSystem);
        this.mustNotBeNull((EObject)this.physicalSystemStateMachine);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.physicalSystemStateMachine.getName(), (Object)this.laSystemStateMachine.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalSystemStateMachine) == this.laSystemStateMachine ? 1 : 0) != 0);
        this.physicalSystemRegion = (Region)this.physicalSystemStateMachine.getOwnedRegions().get(0);
        this.mustNotBeNull((EObject)this.physicalSystemRegion);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.physicalSystemRegion.getName(), (Object)this.laSystemRegion.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalSystemRegion) == this.laSystemRegion ? 1 : 0) != 0);
        this.paInitialState = (InitialPseudoState)this.physicalSystemRegion.getOwnedStates().get(0);
        this.mustNotBeNull((EObject)this.paInitialState);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paInitialState.getName(), (Object)this.laInitialState.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paInitialState) == this.laInitialState ? 1 : 0) != 0);
        this.paMode1 = (Mode)this.physicalSystemRegion.getOwnedStates().get(1);
        this.mustNotBeNull((EObject)this.paMode1);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode1.getName(), (Object)this.laMode1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode1) == this.laMode1 ? 1 : 0) != 0);
        this.laMode1Region = (Region)this.laMode1.getOwnedRegions().get(0);
        this.paMode1Region = (Region)this.paMode1.getOwnedRegions().get(0);
        this.mustNotBeNull((EObject)this.paMode1Region);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode1Region.getName(), (Object)this.laMode1Region.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode1Region) == this.laMode1Region ? 1 : 0) != 0);
        this.paMode2 = (Mode)this.physicalSystemRegion.getOwnedStates().get(2);
        this.mustNotBeNull((EObject)this.paMode2);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode2.getName(), (Object)this.laMode2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode2) == this.laMode2 ? 1 : 0) != 0);
        this.paMode2Region = (Region)this.paMode2.getOwnedRegions().get(0);
        this.mustNotBeNull((EObject)this.paMode2Region);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode2Region.getName(), (Object)this.laMode2Region.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode2Region) == this.laMode2Region ? 1 : 0) != 0);
        this.paMode2Initial = (InitialPseudoState)this.paMode2Region.getOwnedStates().get(0);
        this.mustNotBeNull((EObject)this.paMode2Initial);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode2Initial.getName(), (Object)this.laMode2Initial.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode2Initial) == this.laMode2Initial ? 1 : 0) != 0);
        this.paMode2State1 = (State)this.paMode2Region.getOwnedStates().get(1);
        this.mustNotBeNull((EObject)this.paMode2State1);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode2State1.getName(), (Object)this.laMode2State1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode2State1) == this.laMode2State1 ? 1 : 0) != 0);
        this.paMode2State2 = (State)this.paMode2Region.getOwnedStates().get(2);
        this.mustNotBeNull((EObject)this.paMode2State2);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode2State2.getName(), (Object)this.laMode2State2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode2State2) == this.laMode2State2 ? 1 : 0) != 0);
        this.paMode2Final = (FinalState)this.paMode2Region.getOwnedStates().get(3);
        this.mustNotBeNull((EObject)this.paMode2Final);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode2Final.getName(), (Object)this.laMode2Final.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode2Final) == this.laMode2Final ? 1 : 0) != 0);
        this.paMode3 = (Mode)this.physicalSystemRegion.getOwnedStates().get(3);
        this.mustNotBeNull((EObject)this.paMode3);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode3.getName(), (Object)this.laMode3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode3) == this.laMode3 ? 1 : 0) != 0);
        this.paFork = (ForkPseudoState)this.physicalSystemRegion.getOwnedStates().get(4);
        this.mustNotBeNull((EObject)this.paFork);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFork.getName(), (Object)this.laFork.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFork) == this.laFork ? 1 : 0) != 0);
        this.paJoin = (JoinPseudoState)this.physicalSystemRegion.getOwnedStates().get(5);
        this.mustNotBeNull((EObject)this.paJoin);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paJoin.getName(), (Object)this.laJoin.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paJoin) == this.laJoin ? 1 : 0) != 0);
        this.paChoice = (ChoicePseudoState)this.physicalSystemRegion.getOwnedStates().get(6);
        this.mustNotBeNull((EObject)this.paChoice);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paChoice.getName(), (Object)this.laChoice.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paChoice) == this.laChoice ? 1 : 0) != 0);
        this.paTerminate = (TerminatePseudoState)this.physicalSystemRegion.getOwnedStates().get(7);
        this.mustNotBeNull((EObject)this.paTerminate);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paTerminate.getName(), (Object)this.laTerminate.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paTerminate) == this.laTerminate ? 1 : 0) != 0);
        this.paFinal = (FinalState)this.physicalSystemRegion.getOwnedStates().get(8);
        this.mustNotBeNull((EObject)this.paFinal);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFinal.getName(), (Object)this.laFinal.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFinal) == this.laFinal ? 1 : 0) != 0);
    }

    private void logicalSMProjection2Test() {
        this.performStateMachineTransition(Arrays.asList(this.laSystemStateMachine));
        StateMachineTransition.assertEquals((String)Messages.WrongAllocation, (int)this.physicalSystem.getOwnedStateMachines().size(), (int)3);
        StateMachineTransition.assertEquals((String)Messages.WrongAllocation, (int)this.physicalSystemRegion.getOwnedStates().size(), (int)9);
        StateMachineTransition.assertEquals((String)Messages.WrongAllocation, (int)this.paMode2Region.getOwnedStates().size(), (int)4);
    }

    private void logicalSMProjection3Test() {
        this.laMode3.destroy();
        this.laMode2State2.destroy();
        this.laMode1State1 = CapellacommonFactory.eINSTANCE.createState("State1");
        this.laMode1Region.getOwnedStates().add((Object)this.laMode1State1);
        this.performStateMachineTransition(Arrays.asList(this.laSystemStateMachine));
        this.mustNotBeNull((EObject)this.paMode2State2);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode2State2.getName(), (Object)this.laMode2State2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode2State2) == null ? 1 : 0) != 0);
        this.mustNotBeNull((EObject)this.paMode3);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode3.getName(), (Object)this.laMode3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode3) == null ? 1 : 0) != 0);
        this.paMode1Region = (Region)this.paMode1.getOwnedRegions().get(0);
        this.mustNotBeNull((EObject)this.paMode1Region);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode1Region.getName(), (Object)this.laMode1Region.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode1Region) == this.laMode1Region ? 1 : 0) != 0);
        this.paMode1State1 = (State)this.paMode1Region.getOwnedStates().get(0);
        this.mustNotBeNull((EObject)this.paMode1State1);
        StateMachineTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMode1State1.getName(), (Object)this.laMode1State1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMode1State1) == this.laMode1State1 ? 1 : 0) != 0);
    }
}

