/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.sa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelCtxLa;

public class ActorTransition
extends TopDownTransitionTestCase {
    private SystemComponentPkg _ctxRootActorPkg;
    private SystemComponent _ctxActor1;
    private SystemComponent _ctxActor2;
    private SystemComponent _ctxActor3;
    private Interface _ctxInterface1;
    private Interface _ctxInterface2;
    private InterfaceImplementation _ctxInterfaceImpl;
    private InterfaceUse _ctxInterfaceUse;
    private SystemComponentPkg _ctxSubactorPkg;
    private SystemComponent _ctxSubactor1;
    private SystemComponent _ctxSubactor2;
    private ComponentPort _ctxComponentPort1;
    private LogicalComponentPkg _laRootActorPkg;
    private LogicalComponent _laActor1;
    private LogicalComponent _laActor2;
    private LogicalComponent _laActor3;
    private InterfaceImplementation _laInterfaceImpl;
    private InterfaceUse _laInterfaceUse;
    private LogicalComponentPkg _laSubactorPkg;
    private LogicalComponent _laSubactor1;
    private LogicalComponent _laSubactor2;
    private ComponentPort _laComponentPort1;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this._ctxRootActorPkg = (SystemComponentPkg)this.getObject(ModelCtxLa.rootActorPkgId);
        this._ctxActor1 = (SystemComponent)this.getObject(ModelCtxLa.actor1Id);
        this._ctxActor2 = (SystemComponent)this.getObject(ModelCtxLa.actor2Id);
        this._ctxActor3 = (SystemComponent)this.getObject(ModelCtxLa.actor3Id);
        this._ctxInterface1 = (Interface)this.getObject(ModelCtxLa.interface1Id);
        this._ctxInterface2 = (Interface)this.getObject(ModelCtxLa.interface2Id);
        this._ctxInterfaceImpl = (InterfaceImplementation)this.getObject(ModelCtxLa.interfaceImplId);
        this._ctxInterfaceUse = (InterfaceUse)this.getObject(ModelCtxLa.interfaceUseId);
        this._ctxSubactorPkg = (SystemComponentPkg)this.getObject(ModelCtxLa.subActorPkgId);
        this._ctxSubactor1 = (SystemComponent)this.getObject(ModelCtxLa.subActor1Id);
        this._ctxComponentPort1 = (ComponentPort)this.getObject(ModelCtxLa.componentPort1Id);
        this._laRootActorPkg = (LogicalComponentPkg)this.getObject(ModelCtxLa.rootLAActorPkgId);
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
        this.performTest5();
    }

    public void performTest1() throws Exception {
        this.performActorTransition(Collections.singletonList(this._ctxActor3));
        this._laActor3 = ProjectionTestUtils.getRecentlyCreatedLogicalActor(this._laRootActorPkg);
        this.mustNotBeNull((EObject)this._laActor3);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laActor3.getName(), (Object)this._ctxActor3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laActor3) == this._ctxActor3 ? 1 : 0) != 0);
    }

    public void performTest2() throws Exception {
        this.performActorTransition(Collections.singletonList(this._ctxSubactorPkg));
        this._laSubactorPkg = (LogicalComponentPkg)this._laRootActorPkg.getOwnedLogicalComponentPkgs().get(0);
        this.mustNotBeNull((EObject)this._laSubactorPkg);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSubactorPkg.getName(), (Object)this._ctxSubactorPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSubactorPkg) == this._ctxSubactorPkg ? 1 : 0) != 0);
        this._laSubactor1 = (LogicalComponent)this._laSubactorPkg.getOwnedLogicalComponents().get(0);
        this.mustNotBeNull((EObject)this._laSubactor1);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSubactor1.getName(), (Object)this._ctxSubactor1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSubactor1) == this._ctxSubactor1 ? 1 : 0) != 0);
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)2), (int)this._laSubactor1.getContainedComponentPorts().size(), (int)2);
        this._laComponentPort1 = (ComponentPort)this._laSubactor1.getContainedComponentPorts().get(0);
        this.mustNotBeNull((EObject)this._laComponentPort1);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laComponentPort1.getName(), (Object)this._ctxComponentPort1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laComponentPort1) == this._ctxComponentPort1 ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performActorTransition(Collections.singletonList(this._ctxRootActorPkg));
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)5L), (int)this._laRootActorPkg.getOwnedLogicalComponents().size(), (int)5);
        this._laActor1 = (LogicalComponent)ProjectionTestUtils.getAllocatingComponent((Component)this._ctxActor1);
        this.mustNotBeNull((EObject)this._laActor1);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laActor1.getName(), (Object)this._ctxActor1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laActor1) == this._ctxActor1 ? 1 : 0) != 0);
        this._laActor2 = (LogicalComponent)ProjectionTestUtils.getAllocatingComponent((Component)this._ctxActor2);
        this.mustNotBeNull((EObject)this._laActor2);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laActor2.getName(), (Object)this._ctxActor2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laActor2) == this._ctxActor2 ? 1 : 0) != 0);
        this._laInterfaceImpl = (InterfaceImplementation)this._laActor1.getImplementedInterfaceLinks().get(0);
        this.mustNotBeNull((EObject)this._laInterfaceImpl);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laInterfaceImpl, (Object)this._ctxInterfaceImpl), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laInterfaceImpl) == this._ctxInterfaceImpl ? 1 : 0) != 0);
        ActorTransition.assertTrue((this._laInterfaceImpl.getImplementedInterface() == this._ctxInterface1 ? 1 : 0) != 0);
        this._laInterfaceUse = (InterfaceUse)this._laActor2.getUsedInterfaceLinks().get(0);
        this.mustNotBeNull((EObject)this._laInterfaceUse);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laInterfaceUse, (Object)this._ctxInterfaceUse), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laInterfaceUse) == this._ctxInterfaceUse ? 1 : 0) != 0);
        ActorTransition.assertTrue((this._laInterfaceUse.getUsedInterface() == this._ctxInterface2 ? 1 : 0) != 0);
        this._laSubactor1 = (LogicalComponent)this._laSubactorPkg.getOwnedLogicalComponents().get(0);
    }

    public void performTest4() throws Exception {
        this.performActorTransition(Collections.singletonList(this._ctxRootActorPkg));
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)5L), (int)this._laRootActorPkg.getOwnedLogicalComponents().size(), (int)5);
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)1), (int)this._laSubactorPkg.getOwnedLogicalComponents().size(), (int)1);
    }

    public void performTest5() throws Exception {
        this.getExecutionManager((EObject)this._ctxRootActorPkg).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                ActorTransition.this._ctxSubactor1.destroy();
                ActorTransition.this._ctxSubactor2 = CtxFactory.eINSTANCE.createSystemComponent("Sub Actor 2");
                ActorTransition.this._ctxSubactor2.setActor(true);
                ActorTransition.this._ctxSubactorPkg.getOwnedSystemComponents().add((Object)ActorTransition.this._ctxSubactor2);
                ActorTransition.this._ctxActor3.setName("Ctx Actor 3");
            }
        });
        this.performActorTransition(Collections.singletonList(this._ctxRootActorPkg));
        this.mustNotBeNull((EObject)this._laSubactor1);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSubactor1.getName(), null), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSubactor1) == null ? 1 : 0) != 0);
        this._laSubactor2 = (LogicalComponent)this._laSubactorPkg.getOwnedLogicalComponents().get(1);
        this.mustNotBeNull((EObject)this._laSubactor2);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSubactor2.getName(), (Object)this._ctxSubactor2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSubactor2) == this._ctxSubactor2 ? 1 : 0) != 0);
        ActorTransition.assertFalse((boolean)this._laActor3.getName().equals("Ctx Actor 3"));
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)5L), (int)this._laRootActorPkg.getOwnedLogicalComponents().size(), (int)5);
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)2), (int)this._laSubactorPkg.getOwnedLogicalComponents().size(), (int)2);
    }
}

