/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.sa;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionKind;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;

public class FunctionalTransitionInLib
extends TopDownTransitionTestCase {
    private String WrongRealization = "Wrong Realization";
    private String ErrorMessage = "Error Message";
    private SystemFunction sf1;
    private SystemFunction sf2;
    private LogicalFunction rootLF;
    private LogicalFunction lf1;
    private LogicalFunction lf2;
    private String sf1_Id = "085a534c-236b-4566-9dad-2620daef212a";
    private String sf2_Id = "86df1fda-795e-4b32-966a-abb74a09b472";
    private String rootLF_Id = "65734a29-4691-42ba-b43e-56e0e504245f";

    public List<String> getRequiredTestModels() {
        return Arrays.asList("Library");
    }

    public void performTest() throws Exception {
        this.sf1 = (SystemFunction)this.getObject(this.sf1_Id);
        this.sf2 = (SystemFunction)this.getObject(this.sf2_Id);
        this.rootLF = (LogicalFunction)this.getObject(this.rootLF_Id);
        this.doTest();
    }

    public void doTest() throws Exception {
        this.performFunctionalTransition(Collections.singletonList(this.sf2));
        FunctionalTransitionInLib.assertEquals((int)1, (int)this.rootLF.getOwnedFunctions().size());
        this.lf2 = (LogicalFunction)this.getAllocatingFunction((AbstractFunction)this.sf2);
        FunctionalTransitionInLib.assertNotNull((String)"Element shall not be null", (Object)this.lf2);
        FunctionRealization realization = (FunctionRealization)this.lf2.getOutFunctionRealizations().get(0);
        FunctionalTransitionInLib.assertTrue((String)NLS.bind((String)this.WrongRealization, (Object)this.lf2.getName(), (Object)this.sf2.getName()), (realization.getAllocatedFunction() == this.sf2 ? 1 : 0) != 0);
        FunctionKind actualKindLF2 = this.lf2.getKind();
        FunctionKind expectedKindLF2 = this.sf2.getKind();
        FunctionalTransitionInLib.assertTrue((String)MessageFormat.format(this.ErrorMessage, this.lf2.getName(), actualKindLF2.getName(), expectedKindLF2.getName()), (boolean)actualKindLF2.equals((Object)expectedKindLF2));
        this.lf1 = (LogicalFunction)this.getAllocatingFunction((AbstractFunction)this.sf1);
        FunctionalTransitionInLib.assertNull((Object)this.lf1);
    }

    private AbstractFunction getAllocatingFunction(AbstractFunction function) {
        EList allocatingFunctions = function.getInFunctionRealizations();
        int size = allocatingFunctions.size();
        if (size > 0) {
            return ((FunctionRealization)allocatingFunctions.get(size - 1)).getAllocatingFunction();
        }
        return null;
    }
}

