/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.re.ReAbstractElement;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.core.validation.CapellaValidationActivator;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.api.ComposedOracleDefinition;
import org.polarsys.capella.test.framework.api.IOracleDefinition;
import org.polarsys.capella.test.framework.api.OracleDefinition;

public abstract class ValidationRuleTestCase
extends BasicTestCase {
    private static final String RULE_DOES_NOT_EXIST_PATTERN = "Rule {0} does not exist. Test can not be performed";
    private static final String MISSING_ERROR_ON_OBJECT_PATTERN = "Validation rule {0} has not detected an error on object {1} while it must be the case";
    private static final String UNEXPECTED_ERROR_ON_OBJECT_PATTERN = "Validation rule {0} has detected an error on object(s): \n{1}\nwhile it must not be the case.";
    private static final String LESS_ERRORS_THAN_EXPECTED_PATTERN = "Validation rule {0} has only detected {1} of {2} expected error(s) on object {3}";
    private static final String MORE_ERRORS_THAT_EXPECTED_PATTER = "Validation rule {0} has detected {1} error(s) instead of {2} error(s) on object {3}";
    private static final String UNEXPECTED_EMF_ERROR_KIND_PATTERN = "Validation rule {0} has detected another kind of error, please check EMF integrity of the model: {1}";
    private static final String UNEXPECTED_ERROR_KIND = "Validation rule {0} has detected an error but {1} expected";
    protected String ruleID = this.getRuleID();
    protected EClass targetedEClass = this.getTargetedEClass();
    protected boolean quickFix = this.getCheckQuickFix();
    protected IConstraintDescriptor ruleDescriptor;
    protected IConstraintFilter filter;
    protected IBatchValidator validator;
    private boolean ruleWasDisabled;

    protected abstract String getRequiredTestModel();

    protected abstract EClass getTargetedEClass();

    protected abstract String getRuleID();

    protected abstract List<OracleDefinition> getOracleDefinitions();

    protected boolean getCheckQuickFix() {
        return false;
    }

    protected IStatus testCheckQuickFix(List<IMarker> markers) {
        return Status.OK_STATUS;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validator = CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator();
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
        ConstraintRegistry registry = ConstraintRegistry.getInstance();
        if (this.ruleID != null) {
            this.ruleDescriptor = registry.getDescriptor(this.ruleID);
            if (this.ruleDescriptor == null) {
                throw new InternalError(MessageFormat.format(RULE_DOES_NOT_EXIST_PATTERN, this.ruleID));
            }
            if (!this.ruleDescriptor.isEnabled()) {
                this.ruleDescriptor.setEnabled(true);
                this.ruleWasDisabled = true;
            }
            this.filter = new IConstraintFilter(){

                public boolean accept(IConstraintDescriptor constraint_p, EObject target_p) {
                    return ValidationRuleTestCase.this.ruleDescriptor == constraint_p;
                }
            };
            this.validator.addConstraintFilter(this.filter);
        }
    }

    public void test() throws Exception {
        IStatus status;
        List<EObject> elementsToValidate = this.getElementsToValidate();
        List<OracleDefinition> oracleDefinitions = this.getOracleDefinitions();
        Map<String, IOracleDefinition> elementIdToOracleMap = this.computeElementIdToOracleMap(oracleDefinitions);
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        ArrayList<Object> unexpectedFailingElements = new ArrayList<Object>();
        Diagnostician diagnostician = new Diagnostician();
        for (EObject element : elementsToValidate) {
            Diagnostic diagnostic;
            String elementId = this.getId(element);
            IOracleDefinition rootOracle = elementIdToOracleMap.get(elementId);
            if (this.missingValidationError(rootOracle, diagnostic = diagnostician.validate(element))) {
                ValidationRuleTestCase.fail((String)MessageFormat.format(MISSING_ERROR_ON_OBJECT_PATTERN, this.ruleID, elementId));
                continue;
            }
            if (diagnostic.getSeverity() == 0) continue;
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (rootOracle instanceof ComposedOracleDefinition) {
                    List<CapellaElement> childFailedElements = this.getElements(childDiagnostic);
                    for (CapellaElement childFailedElement : childFailedElements) {
                        String childId = this.getId((EObject)childFailedElement);
                        IOracleDefinition childOracle = elementIdToOracleMap.get(childId);
                        if (childOracle == null || childOracle.getNbExpectedErrors() == 0) {
                            unexpectedFailingElements.add(childFailedElement);
                            continue;
                        }
                        childOracle.countOneError();
                    }
                }
                IFile resourceFile = EcoreUtil2.getFile((Resource)element.eResource());
                IMarker marker = LightMarkerRegistry.getInstance().createMarker((IResource)resourceFile, childDiagnostic, "org.polarsys.capella.core.validation.markers");
                if (marker == null) continue;
                markers.add(marker);
            }
            this.assertExpectedRuleHasBeenThrown(diagnostic, element);
            if (rootOracle != null) {
                rootOracle.countOneError();
                continue;
            }
            unexpectedFailingElements.add(element);
        }
        if (!unexpectedFailingElements.isEmpty()) {
            String objects = unexpectedFailingElements.stream().map(elt -> " - " + this.getId((EObject)elt)).collect(Collectors.joining("\n"));
            ValidationRuleTestCase.fail((String)MessageFormat.format(UNEXPECTED_ERROR_ON_OBJECT_PATTERN, this.ruleID, objects));
        }
        for (IOracleDefinition oracleDef : elementIdToOracleMap.values()) {
            int nbExpectedErrors = oracleDef.getNbExpectedErrors();
            int nbFoundErrors = oracleDef.getNbFoundErrors();
            if (nbFoundErrors < nbExpectedErrors) {
                ValidationRuleTestCase.fail((String)MessageFormat.format(LESS_ERRORS_THAN_EXPECTED_PATTERN, this.ruleID, nbFoundErrors, nbExpectedErrors, oracleDef.getObjectID()));
                continue;
            }
            if (nbFoundErrors <= nbExpectedErrors) continue;
            ValidationRuleTestCase.fail((String)MessageFormat.format(MORE_ERRORS_THAT_EXPECTED_PATTER, this.ruleID, nbFoundErrors, nbExpectedErrors, oracleDef.getObjectID()));
        }
        if (this.getCheckQuickFix() && (status = this.testCheckQuickFix(markers)) != null && !status.isOK()) {
            ValidationRuleTestCase.fail((String)status.getMessage());
        }
    }

    private List<CapellaElement> getElements(Diagnostic diagnostic) {
        return diagnostic.getData().stream().filter(CapellaElement.class::isInstance).map(CapellaElement.class::cast).collect(Collectors.toList());
    }

    private boolean missingValidationError(IOracleDefinition rootOracle, Diagnostic diagnostic) {
        return diagnostic.getSeverity() == 0 && rootOracle != null && rootOracle.getNbExpectedErrors() > 0;
    }

    public List<String> getRequiredTestModels() {
        String requiredTestModel = this.getRequiredTestModel();
        return requiredTestModel != null ? Collections.singletonList(requiredTestModel) : Collections.emptyList();
    }

    protected List<EObject> getTestScope(ICapellaModel model) {
        ArrayList<EObject> scope = new ArrayList<EObject>();
        Project project = model.getProject(this.getSessionForTestModel(this.getRequiredTestModel()).getTransactionalEditingDomain());
        if (project != null) {
            for (EObject object : EObjectExt.getAll((EObject)project, (EClass)this.targetedEClass)) {
                if (!(object instanceof CapellaElement) && !(object instanceof ReAbstractElement)) continue;
                scope.add(object);
            }
        }
        return scope;
    }

    private List<EObject> getElementsToValidate() {
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        return this.getTestScope((ICapellaModel)model);
    }

    protected Map<String, IOracleDefinition> computeElementIdToOracleMap(List<OracleDefinition> oracleDefinitions) {
        HashMap<String, IOracleDefinition> elementIdToOracleMap = new HashMap<String, IOracleDefinition>();
        if (oracleDefinitions != null) {
            for (OracleDefinition oracle : oracleDefinitions) {
                elementIdToOracleMap.put(oracle.getObjectID(), (IOracleDefinition)oracle);
                if (!(oracle instanceof ComposedOracleDefinition)) continue;
                ComposedOracleDefinition composedOracle = (ComposedOracleDefinition)oracle;
                Collection childOracleDefinitions = composedOracle.getChildren();
                for (IOracleDefinition childOracle : childOracleDefinitions) {
                    elementIdToOracleMap.put(childOracle.getObjectID(), childOracle);
                }
            }
        }
        return elementIdToOracleMap;
    }

    protected void assertExpectedRuleHasBeenThrown(Diagnostic diagnostic, EObject object) {
        ValidationRuleTestCase.assertFalse((boolean)diagnostic.getChildren().isEmpty());
        Diagnostic nestedDiag = (Diagnostic)diagnostic.getChildren().get(0);
        ValidationRuleTestCase.assertTrue((String)MessageFormat.format(UNEXPECTED_EMF_ERROR_KIND_PATTERN, this.ruleID, this.getAirdURI(object)), (boolean)(nestedDiag instanceof ConstraintStatusDiagnostic));
        String ruleIdThrown = ((ConstraintStatusDiagnostic)nestedDiag).getConstraintStatus().getConstraint().getDescriptor().getId();
        ValidationRuleTestCase.assertEquals((String)MessageFormat.format(UNEXPECTED_ERROR_KIND, ruleIdThrown, this.ruleID), (String)ruleIdThrown, (String)this.ruleID);
    }

    protected String getAirdURI(EObject object) {
        return SessionManager.INSTANCE.getSession(object).getSessionResource().getURI().toPlatformString(true);
    }

    protected String getId(EObject object) {
        if (object instanceof CapellaElement) {
            return ((CapellaElement)object).getId();
        }
        if (object instanceof ReAbstractElement) {
            return ((ReAbstractElement)object).getId();
        }
        throw new IllegalArgumentException(object.eClass().getName() + "is not supported as a validation targeted EClass");
    }

    protected void tearDown() throws Exception {
        if (this.ruleWasDisabled && this.ruleDescriptor != null) {
            this.ruleDescriptor.setEnabled(false);
        }
        if (this.validator != null) {
            this.validator.removeConstraintFilter(this.filter);
        }
        super.tearDown();
    }
}

