/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.i;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.test.framework.api.OracleDefinition;
import org.polarsys.capella.test.validation.rules.ju.testcases.ValidationRulePartialTestCase;

public class Rule_I_35
extends ValidationRulePartialTestCase {
    private final String PREFIX_OK = "ok_";
    private final String PREFIX_FAIL = "fail_";
    List<FunctionalExchange> okElements = new ArrayList<FunctionalExchange>();
    List<FunctionalExchange> failElements = new ArrayList<FunctionalExchange>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        TransactionalEditingDomain domain = model.getEditingDomain();
        Project project = model.getProject(domain);
        TreeIterator it = project.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof FunctionalExchange)) continue;
            if (this.matchOk(next)) {
                this.okElements.add((FunctionalExchange)next);
                continue;
            }
            if (!this.matchFail(next)) continue;
            this.failElements.add((FunctionalExchange)next);
        }
    }

    protected boolean matchFail(EObject element) {
        return this.matchPrefix(element, (EStructuralFeature)CapellacorePackage.Literals.CAPELLA_ELEMENT__SUMMARY, "fail_");
    }

    protected boolean matchOk(EObject element) {
        return this.matchPrefix(element, (EStructuralFeature)CapellacorePackage.Literals.CAPELLA_ELEMENT__SUMMARY, "ok_");
    }

    protected boolean matchPrefix(EObject element, EStructuralFeature attribute, String prefix) {
        boolean result = false;
        String value = (String)element.eGet(attribute);
        if (value != null && value.startsWith(prefix)) {
            result = true;
        }
        return result;
    }

    @Override
    public void test() throws Exception {
        Rule_I_35.assertFalse((boolean)this.okElements.isEmpty());
        Rule_I_35.assertFalse((boolean)this.failElements.isEmpty());
        super.test();
    }

    @Override
    protected List<String> getScopeDefinition() {
        ArrayList<String> result = new ArrayList<String>();
        for (EObject eObject : this.okElements) {
            result.add(EcoreUtil.getID((EObject)eObject));
        }
        for (EObject eObject : this.failElements) {
            result.add(EcoreUtil.getID((EObject)eObject));
        }
        return result;
    }

    @Override
    protected String getRequiredTestModel() {
        return "testFunctionalExchangeNameConsistency";
    }

    @Override
    protected EClass getTargetedEClass() {
        return FaPackage.Literals.FUNCTIONAL_EXCHANGE;
    }

    @Override
    protected String getRuleID() {
        return "org.polarsys.capella.core.data.fa.validation.I_35";
    }

    @Override
    protected List<OracleDefinition> getOracleDefinitions() {
        ArrayList<OracleDefinition> result = new ArrayList<OracleDefinition>();
        for (EObject eObject : this.okElements) {
            result.add(new OracleDefinition(EcoreUtil.getID((EObject)eObject), 0));
        }
        for (EObject eObject : this.failElements) {
            result.add(new OracleDefinition(EcoreUtil.getID((EObject)eObject), 1));
        }
        return result;
    }
}

