/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.StringPropertyValue;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.core.ui.quickfix.resolver.DWF_D25_Resolver;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.test.framework.api.OracleDefinition;
import org.polarsys.capella.test.validation.rules.ju.testcases.ValidationRuleTestCase;

public abstract class AbstractPackageCycleTest
extends ValidationRuleTestCase {
    @Override
    public void test() throws Exception {
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        Project project = model.getProject(this.getSessionForTestModel(this.getRequiredTestModel()).getTransactionalEditingDomain());
        if (project != null) {
            SystemEngineering se = (SystemEngineering)project.getOwnedModelRoots().get(0);
            Couple scc = new DWF_D25_Resolver().computeCyclesGraph(se);
            Collection<Object> foundCycles = null;
            foundCycles = scc == null ? Collections.emptyList() : (Collection)scc.getValue();
            List<String> expectedCycles = this.getExpectedCycles(se);
            AbstractPackageCycleTest.assertEquals((int)expectedCycles.size(), (int)foundCycles.size());
            for (String expected : this.getExpectedCycles(se)) {
                this.findCycle(foundCycles, expected);
            }
        }
    }

    protected Set<String> cycleFromString(String cycle) {
        String[] elems;
        HashSet<String> s = new HashSet<String>();
        String[] stringArray = elems = cycle.split("\\s+");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            s.add(e);
            ++n2;
        }
        return s;
    }

    protected Set<String> cycleFromEObjectList(List<EObject> list) {
        HashSet<String> s = new HashSet<String>();
        for (EObject e : list) {
            if (e instanceof AbstractNamedElement) {
                String name = ((AbstractNamedElement)e).getName();
                if (s.add(name)) continue;
                AbstractPackageCycleTest.fail((String)("Found duplicate ocurrence of element '" + name + "' in cycle"));
                continue;
            }
            AbstractPackageCycleTest.fail((String)"Expected an AbstractNamedElement in cycle!");
        }
        return s;
    }

    private void findCycle(Collection<List<EObject>> foundCycles, String descriptor) {
        Set<String> expected = this.cycleFromString(descriptor);
        boolean found = false;
        for (List<EObject> cycle : foundCycles) {
            Set<String> current = this.cycleFromEObjectList(cycle);
            if (!current.equals(expected)) continue;
            found = true;
            break;
        }
        AbstractPackageCycleTest.assertTrue((String)("Expected cycle " + String.valueOf(expected) + " was not detected!"), (boolean)found);
    }

    public List<String> getExpectedCycles(SystemEngineering se) {
        ArrayList<String> result = new ArrayList<String>();
        EList ppv = se.getOwnedPropertyValues();
        for (AbstractPropertyValue val : ppv) {
            if (!val.getName().startsWith("cycle")) continue;
            StringPropertyValue sval = (StringPropertyValue)val;
            result.add(sval.getValue());
        }
        return result;
    }

    @Override
    protected EClass getTargetedEClass() {
        return null;
    }

    @Override
    protected String getRuleID() {
        return null;
    }

    @Override
    protected List<OracleDefinition> getOracleDefinitions() {
        return null;
    }
}

