/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.fa.ComponentExchangeRealization;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class Bug2438TestCase
extends BasicTestCase {
    private static String testModelName = "Bug2438";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(testModelName);
    }

    public void test() throws Exception {
        Diagnostician diagnostician = new Diagnostician();
        CapellaModel model = this.getTestModel(testModelName);
        Project project = this.getProject((ICapellaModel)model);
        Diagnostic diagnostic = diagnostician.validate((EObject)project);
        Bug2438TestCase.assertTrue((4 == diagnostic.getSeverity() ? 1 : 0) != 0);
        List<BasicDiagnostic> basicDiagnostics = this.getBasicDiagnostics(diagnostic);
        Bug2438TestCase.assertTrue((basicDiagnostics.size() == 3 ? 1 : 0) != 0);
        Bug2438TestCase.assertTrue((boolean)this.containsData(basicDiagnostics, ComponentExchangeRealization.class, ModellingcorePackage.eINSTANCE.getAbstractTrace_SourceElement()));
        Bug2438TestCase.assertTrue((boolean)this.containsData(basicDiagnostics, ComponentExchangeRealization.class, FaPackage.eINSTANCE.getExchangeSpecificationRealization_RealizingExchangeSpecification()));
        Bug2438TestCase.assertTrue((boolean)this.containsData(basicDiagnostics, ComponentExchangeRealization.class, FaPackage.eINSTANCE.getComponentExchangeRealization_AllocatingComponentExchange()));
    }

    private boolean containsData(List<BasicDiagnostic> basicDiagnostics, Class<ComponentExchangeRealization> clazz, EReference eRef) {
        for (BasicDiagnostic diag : basicDiagnostics) {
            List data = diag.getData();
            Bug2438TestCase.assertTrue((data.size() == 2 ? 1 : 0) != 0);
            if (!clazz.isAssignableFrom(data.get(0).getClass()) || !data.get(1).equals(eRef)) continue;
            return true;
        }
        return false;
    }

    private Project getProject(ICapellaModel model) {
        return model.getProject(this.getSessionForTestModel(testModelName).getTransactionalEditingDomain());
    }

    private List<BasicDiagnostic> getBasicDiagnostics(Diagnostic diagnostic) {
        ArrayList<BasicDiagnostic> result = new ArrayList<BasicDiagnostic>();
        for (Diagnostic child : diagnostic.getChildren()) {
            if (!(child instanceof BasicDiagnostic)) continue;
            result.add((BasicDiagnostic)child);
        }
        return result;
    }
}

