/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.misc;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.osgi.util.NLS;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.validation.CapellaValidationActivator;
import org.polarsys.capella.core.validation.utils.ValidationHelper;
import org.polarsys.capella.test.framework.api.OracleDefinition;
import org.polarsys.capella.test.validation.rules.ju.testcases.ValidationRuleTestCase;

public class CheckAllRulesCodeTest
extends ValidationRuleTestCase {
    @Override
    protected String getRequiredTestModel() {
        return "testOnRules";
    }

    @Override
    protected EClass getTargetedEClass() {
        return null;
    }

    @Override
    protected String getRuleID() {
        return null;
    }

    @Override
    protected List<OracleDefinition> getOracleDefinitions() {
        return null;
    }

    public static void checkIfConstraintIsInError(IConstraintDescriptor icd_p, String msg_p) {
        String msg = msg_p == null ? "Constraint {0} is disabled due to error. Please check its code." : msg_p;
        Assert.assertFalse((String)NLS.bind((String)msg, (Object)icd_p.getId()), (boolean)icd_p.isError());
    }

    @Override
    public void test() throws Exception {
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        Project project = model.getProject(this.getSessionForTestModel(this.getRequiredTestModel()).getTransactionalEditingDomain());
        if (project != null) {
            IBatchValidator validator = CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator();
            for (final IConstraintDescriptor icd : ValidationHelper.getAllConstraintDescriptors()) {
                IConstraintFilter filter = new IConstraintFilter(){

                    public boolean accept(IConstraintDescriptor constraint_p, EObject target_p) {
                        return constraint_p.getId().equals(icd.getId());
                    }
                };
                try {
                    try {
                        validator.addConstraintFilter(filter);
                        CheckAllRulesCodeTest.checkIfConstraintIsInError(icd, "Constraint {0} is errored before its application. Please check its code.");
                        validator.validate((EObject)project);
                        CheckAllRulesCodeTest.checkIfConstraintIsInError(icd, "Constraint {0} is errored after its application. Please check its code.");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        validator.removeConstraintFilter(filter);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    validator.removeConstraintFilter(filter);
                    throw throwable;
                }
                validator.removeConstraintFilter(filter);
            }
        }
    }
}

