/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.misc;

import org.polarsys.capella.common.helpers.validation.xml.XHTMLEntities;
import org.polarsys.capella.core.data.core.validation.constraint.DWF_D_31;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class I25_MoreDescriptionValidationTests
extends BasicTestCase {
    DWF_D_31 validator;

    public void setUp() {
        this.validator = new DWF_D_31();
    }

    public void nullDescription() {
        this.valid(null);
    }

    public void emptyDescription() {
        this.valid("");
    }

    public void html4EntityReferences() {
        StringBuilder b = new StringBuilder();
        XHTMLEntities[] xHTMLEntitiesArray = XHTMLEntities.values();
        int n = xHTMLEntitiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            XHTMLEntities e = xHTMLEntitiesArray[n2];
            b.append(e.asCharacterEntityRef());
            b.append(" ");
            ++n2;
        }
        this.valid(b.toString());
    }

    public void html4UnicodeReferences() {
        StringBuilder b = new StringBuilder();
        XHTMLEntities[] xHTMLEntitiesArray = XHTMLEntities.values();
        int n = xHTMLEntitiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            XHTMLEntities e = xHTMLEntitiesArray[n2];
            b.append(e.asHexadecimalEntityRef());
            b.append(" ");
            ++n2;
        }
        this.valid(b.toString());
    }

    public void missingEndTag() {
        this.invalid("<toto>");
    }

    public void reservedXMLCharacterLT() {
        this.invalid("5 < 3");
    }

    public void reservedXMLCharacterGT() {
        this.invalid("5 < 3");
    }

    private void valid(String description) {
        I25_MoreDescriptionValidationTests.assertTrue((boolean)this.validator.validate(description).isEmpty());
    }

    private void invalid(String description) {
        I25_MoreDescriptionValidationTests.assertFalse((boolean)this.validator.validate(description).isEmpty());
    }

    public void test() throws Exception {
        this.nullDescription();
        this.emptyDescription();
        this.html4EntityReferences();
        this.html4UnicodeReferences();
        this.missingEndTag();
        this.reservedXMLCharacterLT();
        this.reservedXMLCharacterGT();
    }
}

