/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.misc;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.utils.ReflectUtil;
import org.polarsys.capella.core.validation.ui.ide.internal.quickfix.CapellaQuickFixExtPointUtil;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractMarkerResolutionGenerator;
import org.polarsys.capella.core.validation.utils.ValidationHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class InvalidQuickfixRegistration
extends BasicTestCase {
    private String toRuleId(String qualifiedRuleId) {
        return qualifiedRuleId.substring(qualifiedRuleId.lastIndexOf(".") + 1);
    }

    public void test() throws Exception {
        ArrayList<IStatus> logged = new ArrayList<IStatus>();
        Set existingRules = ValidationHelper.getAllConstraintDescriptors().stream().map(v -> this.toRuleId(v.getId())).collect(Collectors.toSet());
        Map resolutions = CapellaQuickFixExtPointUtil.gettAllAvailableMarkerResolution();
        for (Map.Entry values : resolutions.entrySet()) {
            Collection invalidIds = ((Set)values.getValue()).stream().filter(id -> !id.contains("ecore") && !existingRules.contains(id)).collect(Collectors.toList());
            if (invalidIds.isEmpty()) continue;
            logged.add(Status.error((String)(String.valueOf(((AbstractCapellaMarkerResolution)values.getKey()).getClass()) + "=" + invalidIds.stream().collect(Collectors.joining(",")))));
        }
        Map<AbstractMarkerResolutionGenerator, Set<String>> resolutions2 = this.getOthers();
        for (Map.Entry<AbstractMarkerResolutionGenerator, Set<String>> values : resolutions2.entrySet()) {
            Collection invalidIds = values.getValue().stream().filter(id -> !id.contains("ecore") && !existingRules.contains(id)).collect(Collectors.toList());
            if (invalidIds.isEmpty()) continue;
            logged.add(Status.error((String)(String.valueOf(values.getKey().getClass()) + "=" + invalidIds.stream().collect(Collectors.joining(",")))));
        }
        InvalidQuickfixRegistration.assertTrue((String)logged.stream().map(s -> s.getMessage()).collect(Collectors.joining("\n")), (boolean)logged.isEmpty());
    }

    public void testNoDuplicateRuleIdsTest() throws Exception {
        this.test();
    }

    private Map<AbstractMarkerResolutionGenerator, Set<String>> getOthers() {
        IConfigurationElement[] configurationElements;
        HashMap<AbstractMarkerResolutionGenerator, Set<String>> result = new HashMap<AbstractMarkerResolutionGenerator, Set<String>>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.eclipse.ui.ide", (String)"markerResolution");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerResolutionGenerator resolverClass;
            IConfigurationElement e = iConfigurationElementArray[n2];
            if ("markerResolutionGenerator".equals(e.getName()) && "org.polarsys.capella.core.validation.markers".equals(e.getAttribute("markerType")) && (resolverClass = (IMarkerResolutionGenerator)ExtensionPointHelper.createInstance((IConfigurationElement)e, (String)"class")) instanceof AbstractMarkerResolutionGenerator) {
                try {
                    String id = this.toRuleId((String)ReflectUtil.invokeInvisibleMethod((Object)resolverClass, (String)"getRuleId", (Object[])new Object[0]));
                    result.put((AbstractMarkerResolutionGenerator)resolverClass, Arrays.asList(id).stream().collect(Collectors.toSet()));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
            ++n2;
        }
        return result;
    }
}

