/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.capella.common.mdsofa.common.constant.ICommonConstants;
import org.polarsys.capella.core.validation.ui.ide.internal.quickfix.CapellaQuickFixExtPointUtil;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;
import org.polarsys.capella.core.validation.utils.ValidationHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class NoDuplicateRuleIdsTest
extends BasicTestCase {
    public void test() throws Exception {
        final ArrayList logged = new ArrayList();
        EMFModelValidationPlugin.getPlugin().getLog().addLogListener(new ILogListener(){

            public void logging(IStatus status_p, String plugin_p) {
                if (status_p.getCode() == 63) {
                    logged.add(status_p);
                }
            }
        });
        ValidationHelper.ensureEMFValidationActivation();
        if (!logged.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (IStatus s : logged) {
                builder.append(String.valueOf(s) + System.getProperty("line.separator"));
            }
            NoDuplicateRuleIdsTest.fail((String)("Recorded unexpected log message(s) while loading constraint descriptors: " + System.getProperty("line.separator") + String.valueOf(builder)));
        }
        HashMap<String, ArrayList<IConstraintDescriptor>> suffixDescriptors = new HashMap<String, ArrayList<IConstraintDescriptor>>();
        HashSet<String> dups = new HashSet<String>();
        for (IConstraintDescriptor descriptor : ValidationHelper.getAllConstraintDescriptors()) {
            ArrayList<IConstraintDescriptor> descriptorsForSuffix;
            String suffix = descriptor.getId();
            int lastDot = suffix.lastIndexOf(46);
            if (lastDot >= 0 && lastDot < suffix.length() - 1) {
                suffix = suffix.substring(lastDot + 1);
            }
            if ((descriptorsForSuffix = (ArrayList<IConstraintDescriptor>)suffixDescriptors.get(suffix)) == null) {
                descriptorsForSuffix = new ArrayList<IConstraintDescriptor>();
                suffixDescriptors.put(suffix, descriptorsForSuffix);
                descriptorsForSuffix.add(descriptor);
                continue;
            }
            descriptorsForSuffix.add(descriptor);
            dups.add(suffix);
        }
        if (!dups.isEmpty()) {
            StringBuilder message = new StringBuilder();
            Map resolutions = CapellaQuickFixExtPointUtil.gettAllAvailableMarkerResolution();
            for (Map.Entry entry : resolutions.entrySet()) {
                for (String resolutionId : (Set)entry.getValue()) {
                    if (!dups.contains(resolutionId)) continue;
                    AbstractCapellaMarkerResolution res = (AbstractCapellaMarkerResolution)entry.getKey();
                    message.append("Bundle " + res.getContributorId() + " provides a marker resolution for ruleId '" + resolutionId + "' which is ambiguous. " + ICommonConstants.LINE_SEPARATOR + "You can fix this problem by specifying one of these qualified constraint IDs in the extension's 'ruleId' attribute:" + ICommonConstants.LINE_SEPARATOR);
                    for (IConstraintDescriptor descriptor : (List)suffixDescriptors.get(resolutionId)) {
                        message.append(descriptor.getId());
                        message.append(ICommonConstants.LINE_SEPARATOR);
                    }
                }
                if (message.length() <= 0) continue;
                NoDuplicateRuleIdsTest.fail((String)message.toString());
            }
        }
    }

    public void testNoDuplicateRuleIdsTest() throws Exception {
        this.test();
    }
}

