/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.matrix.views;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.IArtifactUnpacker;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.helpers.SelectionSupportHelper;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixBodyToolTip;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixColumnHeaderDataProvider;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixDataProvider;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixEntryData;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixHeaderToolTip;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixRowHeaderDataProvider;
import org.eclipse.capra.ui.matrix.handlers.ToggleCheckArtifactExistenceHandler;
import org.eclipse.capra.ui.matrix.selection.TraceabilityMatrixSelectionProvider;
import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.capra.ui.operations.CreateTraceOperation;
import org.eclipse.capra.ui.operations.DeleteTraceOperation;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommand;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hover.HoverLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.resize.action.ColumnResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.action.RowResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEventMatcher;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEventMatcher;
import org.eclipse.nebula.widgets.nattable.resize.mode.ColumnResizeDragMode;
import org.eclipse.nebula.widgets.nattable.resize.mode.RowResizeDragMode;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class TraceabilityMatrixView
extends ViewPart {
    private static final String CONFIRM_DELETION_QUESTION = "Are you sure you want to delete the trace link?";
    private static final String CONFIRM_DELETION_TITLE = "Delete trace link";
    private static final String ARTIFACT_DOES_NOT_EXIST_LABEL = "ARTIFACT_DOES_NOT_EXIST_LABEL";
    private static final String ARTIFACT_RENAMED_LABEL = "ARTIFACT_RENAMED_LABEL";
    public static final String ID = "org.eclipse.capra.ui.matrix.views.TraceabilityMatrixView";
    private static final String SAME_LABEL = "SAME";
    private static final String LINK_LABEL = "LINKED";
    private NatTable traceMatrixTable;
    private Action deleteLinkAction;
    private Action createLinkAction;
    private Action refreshAction;
    private Action showAllAction;
    private Action exportExcelAction;
    private Composite parent;
    private ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
    private final ITraceabilityInformationModelAdapter traceAdapter = (ITraceabilityInformationModelAdapter)ExtensionPointHelper.getTraceabilityInformationModelAdapter().get();
    private IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().get();
    private TraceabilityMatrixDataProvider bodyDataProvider;
    private TraceabilityMatrixSelectionProvider selectionProvider;
    private BodyLayerStack bodyLayer;
    private List<Object> selectedModels = new ArrayList<Object>();
    private boolean selectionModified = false;
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            this.populateSelectedModels(part, selection);
            if (TraceabilityMatrixView.this.traceMatrixTable != null && TraceabilityMatrixView.this.selectionModified) {
                TraceabilityMatrixView.this.updateTraceabilityMatrix();
            }
        }

        private void populateSelectedModels(IWorkbenchPart part, ISelection selection) {
            List newSelectedObjects = SelectionSupportHelper.extractSelectedElements((ISelection)selection, (IWorkbenchPart)part);
            if (!TraceabilityMatrixView.this.listEqualsIgnoreOrder(TraceabilityMatrixView.this.selectedModels, newSelectedObjects)) {
                TraceabilityMatrixView.this.selectionModified = true;
                TraceabilityMatrixView.this.selectedModels.clear();
                TraceabilityMatrixView.this.selectedModels.addAll(newSelectedObjects);
            } else {
                TraceabilityMatrixView.this.selectionModified = false;
            }
        }
    };
    private AbstractRegistryConfiguration capraNatTableStyleConfiguration = new AbstractRegistryConfiguration(){
        private final HorizontalAlignmentEnum ALIGNMENT = HorizontalAlignmentEnum.LEFT;

        public void configureRegistry(IConfigRegistry configRegistry) {
            IStyle diagonalCellStyle = (IStyle)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", new String[]{"BODY"});
            diagonalCellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_BLACK);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)diagonalCellStyle, "NORMAL", TraceabilityMatrixView.SAME_LABEL);
            IStyle linkCellStyle = (IStyle)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", new String[]{"BODY"});
            linkCellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_GREEN);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)linkCellStyle, "NORMAL", TraceabilityMatrixView.LINK_LABEL);
            IStyle hoveredCellStyle = (IStyle)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", new String[]{"BODY"});
            hoveredCellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_YELLOW);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)hoveredCellStyle, "HOVER");
            IStyle selectedHoveredCellStyle = (IStyle)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", new String[]{"BODY"});
            selectedHoveredCellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_GREEN);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)selectedHoveredCellStyle, "SELECT_HOVER");
            IStyle columnHeaderStyle = (IStyle)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", new String[]{"COLUMN_HEADER"});
            columnHeaderStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)this.ALIGNMENT);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)columnHeaderStyle, "NORMAL", "COLUMN_HEADER");
            IStyle rowHeaderStyle = (IStyle)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", new String[]{"ROW_HEADER"});
            rowHeaderStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)this.ALIGNMENT);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)rowHeaderStyle, "NORMAL", "ROW_HEADER");
            Style rowHeaderStyleArtifactRenamed = new Style();
            rowHeaderStyleArtifactRenamed.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_YELLOW);
            rowHeaderStyleArtifactRenamed.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_BLACK);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)rowHeaderStyleArtifactRenamed, "NORMAL", TraceabilityMatrixView.ARTIFACT_RENAMED_LABEL);
            Style rowHeaderStyleArtifactNotExists = new Style();
            rowHeaderStyleArtifactNotExists.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)rowHeaderStyleArtifactNotExists, "NORMAL", TraceabilityMatrixView.ARTIFACT_DOES_NOT_EXIST_LABEL);
        }
    };
    private AbstractUiBindingConfiguration capraUiBindingConfiguration = new AbstractUiBindingConfiguration(){

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "ROW_HEADER", 0), (IMouseAction)new ColumnResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "ROW_HEADER", 1), (IDragMode)new ColumnResizeDragMode());
            uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new RowResizeEventMatcher(0, "COLUMN_HEADER", 0), (IMouseAction)new RowResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new RowResizeEventMatcher(0, "COLUMN_HEADER", 1), (IDragMode)new RowResizeDragMode());
            uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 0), (IMouseAction)new ColumnResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 1), (IDragMode)new ColumnResizeDragMode());
            uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new RowResizeEventMatcher(0, "CORNER", 0), (IMouseAction)new RowResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new RowResizeEventMatcher(0, "CORNER", 1), (IDragMode)new RowResizeDragMode());
            uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)MouseEventMatcher.bodyLeftClick((int)0), new IMouseAction(){

                public void run(NatTable natTable, MouseEvent event) {
                    (this).TraceabilityMatrixView.this.createLinkAction.run();
                }
            });
        }
    };
    private IConfigLabelAccumulator cellLabelAccumulator = new IConfigLabelAccumulator(){

        public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
            int columnIndex = TraceabilityMatrixView.this.bodyLayer.getColumnIndexByPosition(columnPosition);
            int rowIndex = TraceabilityMatrixView.this.bodyLayer.getRowIndexByPosition(rowPosition);
            if (EMFHelper.hasSameIdentifier((EObject)TraceabilityMatrixView.this.bodyDataProvider.getRow(rowIndex).getArtifact(), (EObject)TraceabilityMatrixView.this.bodyDataProvider.getColumn(columnIndex).getArtifact())) {
                configLabels.addLabel(TraceabilityMatrixView.SAME_LABEL);
            } else {
                String cellText = (String)TraceabilityMatrixView.this.bodyDataProvider.getDataValue(columnIndex, rowIndex);
                if (!cellText.equals("")) {
                    configLabels.addLabel(TraceabilityMatrixView.LINK_LABEL);
                }
            }
        }
    };
    private TraceabilityMatrixColumnHeaderDataProvider colHeaderDataProvider;
    private TraceabilityMatrixRowHeaderDataProvider rowHeaderDataProvider;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.updateTraceabilityMatrix();
        this.makeActions();
        this.contributeToActionBars();
        this.getViewSite().getPage().addSelectionListener(this.selectionListener);
    }

    private void contributeContextMenu(ISelectionProvider selectionProvider) {
        MenuManager menuManager = new MenuManager();
        this.getSite().registerContextMenu("org.eclipse.capra.ui.matrix.QuickFixMenu", menuManager, selectionProvider);
        this.traceMatrixTable.addConfiguration((IConfiguration)new QuickFixMenuConfiguration(this.traceMatrixTable, menuManager));
    }

    public void dispose() {
        this.getViewSite().getPage().removeSelectionListener(this.selectionListener);
        this.traceMatrixTable.dispose();
        this.traceMatrixTable = null;
        super.dispose();
    }

    public void setFocus() {
        if (this.traceMatrixTable != null) {
            this.traceMatrixTable.setFocus();
        }
    }

    protected void updateTraceabilityMatrix() {
        ArrayList<Connection> traces = new ArrayList();
        EObject artifactModel = this.persistenceAdapter.getArtifactWrappers(this.resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        EObject traceModel = this.persistenceAdapter.getTraceModel(this.resourceSet);
        TraceHelper traceHelper = new TraceHelper(traceModel);
        if (!this.selectedModels.isEmpty()) {
            for (Object model : this.selectedModels) {
                IArtifactHandler handler = artifactHelper.getHandler(model).orElse(null);
                if (handler == null) continue;
                Object unpackedElement = null;
                unpackedElement = handler instanceof IArtifactUnpacker ? ((IArtifactUnpacker)IArtifactUnpacker.class.cast(handler)).unpack(model) : model;
                EObject wrappedElement = handler.createWrapper(unpackedElement, artifactModel);
                if (!traceHelper.isArtifactInTraceModel(wrappedElement)) continue;
                EObject selectedObject = wrappedElement;
                traces.addAll(this.traceAdapter.getConnectedElements(selectedObject, traceModel));
            }
        } else if (traceModel != null) {
            traces = this.traceAdapter.getAllTraceLinks(traceModel);
        }
        if (!traces.isEmpty()) {
            if (this.traceMatrixTable != null) {
                this.traceMatrixTable.dispose();
                this.traceMatrixTable = null;
            }
            this.bodyDataProvider = new TraceabilityMatrixDataProvider(traces, traceModel, this.traceAdapter, artifactHelper);
            this.colHeaderDataProvider = new TraceabilityMatrixColumnHeaderDataProvider(this.bodyDataProvider.getColumns(), artifactHelper);
            this.rowHeaderDataProvider = new TraceabilityMatrixRowHeaderDataProvider(this.bodyDataProvider.getRows(), artifactHelper);
            this.bodyLayer = new BodyLayerStack(this.bodyDataProvider);
            ColumnHeaderLayerStack columnHeaderLayer = new ColumnHeaderLayerStack(this.colHeaderDataProvider);
            RowHeaderLayerStack rowHeaderLayer = new RowHeaderLayerStack(this.rowHeaderDataProvider);
            DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.colHeaderDataProvider, (IDataProvider)this.rowHeaderDataProvider);
            CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
            this.bodyLayer.setConfigLabelAccumulator(this.cellLabelAccumulator);
            GridLayer gridLayer = new GridLayer((ILayer)this.bodyLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
            gridLayer.addConfiguration((IConfiguration)this.capraUiBindingConfiguration);
            this.traceMatrixTable = new NatTable(this.parent, (ILayer)gridLayer, false);
            if (this.selectionProvider == null) {
                this.selectionProvider = new TraceabilityMatrixSelectionProvider(this.bodyLayer.getSelectionLayer(), this.bodyDataProvider);
            } else {
                this.selectionProvider.updateProvider(this.bodyLayer.getSelectionLayer(), this.bodyDataProvider);
            }
            this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
            this.traceMatrixTable.addConfiguration((IConfiguration)new ModernNatTableThemeConfiguration());
            this.traceMatrixTable.addConfiguration((IConfiguration)this.capraNatTableStyleConfiguration);
            this.contributeContextMenu(this.selectionProvider);
            this.traceMatrixTable.configure();
            this.attachToolTip();
            this.parent.layout();
        }
    }

    private <T> boolean listEqualsIgnoreOrder(List<T> list1, List<T> list2) {
        return new HashSet<T>(list1).equals(new HashSet<T>(list2));
    }

    private void attachToolTip() {
        EObject artifactModel = this.persistenceAdapter.getArtifactWrappers(this.resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        new TraceabilityMatrixBodyToolTip(this.traceMatrixTable, this.bodyDataProvider, artifactHelper);
        new TraceabilityMatrixHeaderToolTip(this.traceMatrixTable, this.bodyDataProvider, artifactHelper);
    }

    private void openEditor(EObject element) throws PartInitException {
        EObject artifactModel = this.persistenceAdapter.getArtifactWrappers(this.resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            URI uri = new URI(artifactHelper.getArtifactLocation(element));
            Path artifactPath = new Path(uri.getPath());
            artifactPath = artifactPath.removeFirstSegments(1);
            IFile artifactFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)artifactPath);
            IDE.openEditor((IWorkbenchPage)page, (IFile)artifactFile);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.createLinkAction);
        manager.add((IAction)this.deleteLinkAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.showAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.exportExcelAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.createLinkAction);
        manager.add((IAction)this.deleteLinkAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.showAllAction);
    }

    private void makeActions() {
        this.createLinkAction = new Action(){

            public void run() {
                if (TraceabilityMatrixView.this.getConnectionFromSelection() != null) {
                    return;
                }
                PositionCoordinate selectedCellCoords = TraceabilityMatrixView.this.selectionProvider.getSelectedCellPosition();
                if (selectedCellCoords != null) {
                    EObject source = TraceabilityMatrixView.this.bodyDataProvider.getRow(selectedCellCoords.rowPosition).getArtifact();
                    EObject target = TraceabilityMatrixView.this.bodyDataProvider.getColumn(selectedCellCoords.columnPosition).getArtifact();
                    CreateTraceOperation createTraceOperation = new CreateTraceOperation("Create new traceability link", Arrays.asList(source), Arrays.asList(target));
                    createTraceOperation.addContext(IOperationHistory.GLOBAL_UNDO_CONTEXT);
                    IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
                    try {
                        operationHistory.execute((IUndoableOperation)createTraceOperation, null, (IAdaptable)TraceabilityMatrixView.this.getSite());
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    TraceabilityMatrixView.this.showAllAction.run();
                }
            }
        };
        this.createLinkAction.setText("Create Link");
        this.createLinkAction.setToolTipText("Create a new traceability link with the artifact in the row of the selected cell as the source and the artifact in the column of the selected cell as the target");
        try {
            URL createLinkImageUrl = new URL("platform:/plugin/org.eclipse.ui/icons/full/obj16/add_obj.png");
            ImageDescriptor createLinkImage = ImageDescriptor.createFromURL((URL)createLinkImageUrl);
            this.createLinkAction.setImageDescriptor(createLinkImage);
        }
        catch (MalformedURLException createLinkImageUrl) {
            // empty catch block
        }
        this.deleteLinkAction = new Action(){

            public void run() {
                Shell shell;
                if (TraceabilityMatrixView.this.getConnectionFromSelection() != null && MessageDialog.open((int)3, (Shell)(shell = TraceabilityMatrixView.this.getSite().getShell()), (String)TraceabilityMatrixView.CONFIRM_DELETION_TITLE, (String)TraceabilityMatrixView.CONFIRM_DELETION_QUESTION, (int)0)) {
                    Connection connection = TraceabilityMatrixView.this.getConnectionFromSelection();
                    DeleteTraceOperation deleteTraceOperation = new DeleteTraceOperation(TraceabilityMatrixView.CONFIRM_DELETION_TITLE, connection);
                    deleteTraceOperation.addContext(IOperationHistory.GLOBAL_UNDO_CONTEXT);
                    IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
                    try {
                        operationHistory.execute((IUndoableOperation)deleteTraceOperation, null, (IAdaptable)TraceabilityMatrixView.this.getSite());
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    TraceabilityMatrixView.this.showAllAction.run();
                }
            }
        };
        this.deleteLinkAction.setText("Delete Link");
        this.deleteLinkAction.setToolTipText("Delete Link");
        try {
            URL deleteLinkImageUrl = new URL("platform:/plugin/org.eclipse.ui/icons/full/etool16/delete.png");
            ImageDescriptor deleteLinkImage = ImageDescriptor.createFromURL((URL)deleteLinkImageUrl);
            this.deleteLinkAction.setImageDescriptor(deleteLinkImage);
        }
        catch (MalformedURLException deleteLinkImageUrl) {
            // empty catch block
        }
        this.refreshAction = new Action(){

            public void run() {
                TraceabilityMatrixView.this.updateTraceabilityMatrix();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        try {
            URL refreshImageUrl = new URL("platform:/plugin/org.eclipse.search/icons/full/elcl16/refresh.png");
            ImageDescriptor refreshImage = ImageDescriptor.createFromURL((URL)refreshImageUrl);
            this.refreshAction.setImageDescriptor(refreshImage);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.showAllAction = new Action(){

            public void run() {
                TraceabilityMatrixView.this.selectedModels.clear();
                TraceabilityMatrixView.this.updateTraceabilityMatrix();
            }
        };
        this.showAllAction.setText("Show all");
        this.showAllAction.setToolTipText("Show all");
        this.exportExcelAction = new Action(){

            public void run() {
                ExportCommand cmd = new ExportCommand(TraceabilityMatrixView.this.traceMatrixTable.getConfigRegistry(), TraceabilityMatrixView.this.traceMatrixTable.getShell());
                TraceabilityMatrixView.this.traceMatrixTable.doCommand((ILayerCommand)cmd);
            }
        };
        this.exportExcelAction.setText("Export to Excel...");
        this.exportExcelAction.setToolTipText("Exports the currently shown traceability matrix as an Excel file.");
    }

    private Connection getConnectionFromSelection() {
        if (this.selectionProvider.getSelection() instanceof StructuredSelection && ((StructuredSelection)this.selectionProvider.getSelection()).getFirstElement() instanceof Connection) {
            return (Connection)((StructuredSelection)this.selectionProvider.getSelection()).getFirstElement();
        }
        return null;
    }

    public static TraceabilityMatrixView getOpenedView() {
        try {
            return (TraceabilityMatrixView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TraceabilityMatrixEntryData getSelectedColumnOrRowEntryData() {
        Object rawData = null;
        PositionCoordinate coordinate = this.selectionProvider.getSelectedCellPosition();
        if (Objects.isNull(coordinate)) {
            return null;
        }
        if (coordinate.getColumnPosition() > 0 || coordinate.getColumnPosition() == 0 && coordinate.getRowPosition() == 0) {
            rawData = this.colHeaderDataProvider.getDataValue(coordinate.getColumnPosition(), 0);
        } else if (coordinate.getRowPosition() > 0) {
            rawData = this.rowHeaderDataProvider.getDataValue(0, coordinate.getRowPosition());
        }
        if (Objects.isNull(rawData) || !(rawData instanceof TraceabilityMatrixEntryData)) {
            return null;
        }
        return (TraceabilityMatrixEntryData)rawData;
    }

    public TraceabilityMatrixEntryData getHeaderEntryDataForTablePositions(int colPos, int rowPos) {
        Object rawData = null;
        if (colPos == 0 && rowPos == 0) {
            rawData = this.colHeaderDataProvider.getDataValue(0, 0);
        } else if (colPos > 0) {
            rawData = this.colHeaderDataProvider.getDataValue(colPos - 1, 0);
        } else if (rowPos > 0) {
            rawData = this.rowHeaderDataProvider.getDataValue(0, rowPos - 1);
        }
        if (Objects.isNull(rawData) || !(rawData instanceof TraceabilityMatrixEntryData)) {
            return null;
        }
        return (TraceabilityMatrixEntryData)rawData;
    }

    private static enum AccumulatorType {
        ROW,
        COLUMN;

    }

    private final class ArtifactExistenceConfigLabelAccumulator
    implements IConfigLabelAccumulator {
        private final IDataProvider dataProvider;
        private final AccumulatorType accumulatorType;
        private final ArtifactHelper artifactHelper;

        private ArtifactExistenceConfigLabelAccumulator(IDataProvider dataProvider, AccumulatorType accumulatorType) {
            this.dataProvider = dataProvider;
            this.accumulatorType = accumulatorType;
            this.artifactHelper = new ArtifactHelper(TraceabilityMatrixView.this.persistenceAdapter.getArtifactWrappers(TraceabilityMatrixView.this.resourceSet));
        }

        public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
            if (!ToggleCheckArtifactExistenceHandler.checkArtifaceExistence()) {
                return;
            }
            Object rawData = null;
            switch (this.accumulatorType) {
                case ROW: {
                    rawData = this.dataProvider.getDataValue(0, rowPosition);
                    break;
                }
                case COLUMN: {
                    rawData = this.dataProvider.getDataValue(columnPosition, 0);
                }
            }
            if (Objects.isNull(rawData) || !(rawData instanceof TraceabilityMatrixEntryData)) {
                return;
            }
            TraceabilityMatrixEntryData entryData = (TraceabilityMatrixEntryData)rawData;
            for (IMarker marker : entryData.getMarkers()) {
                try {
                    if (!marker.exists() || !Objects.equals(marker.getAttribute("oldArtifactUri"), this.artifactHelper.getArtifactLocation(entryData.getArtifact()))) continue;
                    if (Objects.equals(marker.getAttribute("issueType"), CapraNotificationHelper.IssueType.DELETED.getValue())) {
                        configLabels.addLabel(TraceabilityMatrixView.ARTIFACT_DOES_NOT_EXIST_LABEL);
                        continue;
                    }
                    if (!Objects.equals(marker.getAttribute("issueType"), CapraNotificationHelper.IssueType.RENAMED.getValue())) continue;
                    configLabels.addLabel(TraceabilityMatrixView.ARTIFACT_RENAMED_LABEL);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class BodyLayerStack
    extends AbstractLayerTransform {
        private SelectionLayer selectionLayer;

        public BodyLayerStack(IDataProvider dataProvider) {
            DataLayer bodyDataLayer = new DataLayer(dataProvider);
            HoverLayer bodyHoverLayer = new HoverLayer((IUniqueIndexLayer)bodyDataLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyHoverLayer);
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }
    }

    private class ColumnHeaderLayerStack
    extends AbstractLayerTransform {
        public ColumnHeaderLayerStack(IDataProvider dataProvider) {
            DataLayer dataLayer = new DataLayer(dataProvider);
            ColumnHeaderLayer colHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)dataLayer, (ILayer)TraceabilityMatrixView.this.bodyLayer, TraceabilityMatrixView.this.bodyLayer.getSelectionLayer());
            colHeaderLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ArtifactExistenceConfigLabelAccumulator(dataProvider, AccumulatorType.COLUMN));
            colHeaderLayer.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

                public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                    uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)MouseEventMatcher.columnHeaderLeftClick((int)0), new IMouseAction(){

                        public void run(NatTable natTable, MouseEvent event) {
                            try {
                                int columnPosition = natTable.getColumnPositionByX(event.x);
                                int columnIndex = natTable.getColumnIndexByPosition(columnPosition);
                                EObject element = ((ColumnHeaderLayerStack)(this).ColumnHeaderLayerStack.this).TraceabilityMatrixView.this.bodyDataProvider.getColumn(columnIndex).getArtifact();
                                TraceabilityMatrixView.this.openEditor(element);
                            }
                            catch (PartInitException partInitException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            this.setUnderlyingLayer((ILayer)colHeaderLayer);
        }
    }

    private final class QuickFixMenuConfiguration
    extends AbstractUiBindingConfiguration {
        private final Menu quickFixMenu;

        public QuickFixMenuConfiguration(NatTable natTable, MenuManager menuManager) {
            this.quickFixMenu = new PopupMenuBuilder(natTable, menuManager).build();
        }

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "COLUMN_HEADER", 3), (IMouseAction)new PopupMenuAction(this.quickFixMenu));
            uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "ROW_HEADER", 3), (IMouseAction)new PopupMenuAction(this.quickFixMenu));
        }
    }

    private class RowHeaderLayerStack
    extends AbstractLayerTransform {
        public RowHeaderLayerStack(IDataProvider dataProvider) {
            DataLayer dataLayer = new DataLayer(dataProvider, 50, 20);
            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)dataLayer, (ILayer)TraceabilityMatrixView.this.bodyLayer, TraceabilityMatrixView.this.bodyLayer.getSelectionLayer());
            rowHeaderLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ArtifactExistenceConfigLabelAccumulator(dataProvider, AccumulatorType.ROW));
            rowHeaderLayer.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

                public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                    uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)MouseEventMatcher.rowHeaderLeftClick((int)0), new IMouseAction(){

                        public void run(NatTable natTable, MouseEvent event) {
                            try {
                                int rowPosition = natTable.getRowPositionByY(event.y);
                                int rowIndex = natTable.getRowIndexByPosition(rowPosition);
                                EObject element = ((RowHeaderLayerStack)(this).RowHeaderLayerStack.this).TraceabilityMatrixView.this.bodyDataProvider.getRow(rowIndex).getArtifact();
                                TraceabilityMatrixView.this.openEditor(element);
                            }
                            catch (PartInitException partInitException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            this.setUnderlyingLayer((ILayer)rowHeaderLayer);
        }
    }
}

